/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.synchronizer;

import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.repositories.FetchFailedException;
import org.mozilla.gecko.sync.repositories.StoreFailedException;
import org.mozilla.gecko.sync.synchronizer.RecordsChannel;
import org.mozilla.gecko.sync.synchronizer.Synchronizer;
import org.mozilla.gecko.sync.synchronizer.SynchronizerSession;
import org.mozilla.gecko.sync.synchronizer.SynchronizerSessionDelegate;

public class ServerLocalSynchronizerSession
extends SynchronizerSession {
    protected static final String LOG_TAG = "ServLocSynchronizerSess";

    public ServerLocalSynchronizerSession(Synchronizer synchronizer, SynchronizerSessionDelegate synchronizerSessionDelegate) {
        super(synchronizer, synchronizerSessionDelegate);
    }

    public void onFirstFlowCompleted(RecordsChannel recordsChannel, long l, long l2) {
        int n = recordsChannel.getFetchFailureCount();
        if (n > 0) {
            String string2 = "Got " + n + " failures fetching remote records!";
            Logger.warn(LOG_TAG, string2 + " Aborting session.");
            this.delegate.onSynchronizeFailed(this, new FetchFailedException(), string2);
            return;
        }
        Logger.trace(LOG_TAG, "No failures fetching remote records.");
        int n2 = recordsChannel.getStoreFailureCount();
        if (n2 > 0) {
            String string3 = "Got " + n2 + " failures storing local records!";
            Logger.warn(LOG_TAG, string3 + " Ignoring local store failures and continuing synchronizer session.");
        } else {
            Logger.trace(LOG_TAG, "No failures storing local records.");
        }
        super.onFirstFlowCompleted(recordsChannel, l, l2);
    }

    public void onSecondFlowCompleted(RecordsChannel recordsChannel, long l, long l2) {
        int n = recordsChannel.getFetchFailureCount();
        if (n > 0) {
            String string2 = "Got " + n + " failures fetching local records!";
            Logger.warn(LOG_TAG, string2 + " Aborting session.");
            this.delegate.onSynchronizeFailed(this, new FetchFailedException(), string2);
            return;
        }
        Logger.trace(LOG_TAG, "No failures fetching local records.");
        int n2 = recordsChannel.getStoreFailureCount();
        if (n2 > 0) {
            String string3 = "Got " + n2 + " failures storing remote records!";
            Logger.warn(LOG_TAG, string3 + " Aborting session.");
            this.delegate.onSynchronizeFailed(this, new StoreFailedException(), string3);
            return;
        }
        Logger.trace(LOG_TAG, "No failures storing remote records.");
        super.onSecondFlowCompleted(recordsChannel, l, l2);
    }
}

