/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.ImageButton;
import org.mozilla.gecko.R;
import org.mozilla.gecko.animation.PropertyAnimator;
import org.mozilla.gecko.animation.ViewHelper;
import org.mozilla.gecko.toolbar.BrowserToolbar;
import org.mozilla.gecko.toolbar.ToolbarEditText;
import org.mozilla.gecko.widget.GeckoLinearLayout;

public class ToolbarEditLayout
extends GeckoLinearLayout {
    private final ToolbarEditText mEditText;
    private final ImageButton mGo;
    private BrowserToolbar.OnCommitListener mCommitListener;
    private View.OnFocusChangeListener mFocusChangeListener;

    public ToolbarEditLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setOrientation(0);
        LayoutInflater.from((Context)context).inflate(R.layout.toolbar_edit_layout, (ViewGroup)this);
        this.mGo = (ImageButton)this.findViewById(R.id.go);
        this.mEditText = (ToolbarEditText)this.findViewById(R.id.url_edit_text);
    }

    public void onAttachedToWindow() {
        this.mGo.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ToolbarEditLayout.this.mCommitListener != null) {
                    ToolbarEditLayout.this.mCommitListener.onCommit();
                }
            }
        });
        this.mEditText.setOnTextTypeChangeListener(new ToolbarEditText.OnTextTypeChangeListener(){

            public void onTextTypeChange(ToolbarEditText toolbarEditText, ToolbarEditText.TextType textType) {
                ToolbarEditLayout.this.updateGoButton(textType);
            }
        });
        this.mEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean bl) {
                if (ToolbarEditLayout.this.mFocusChangeListener != null) {
                    ToolbarEditLayout.this.mFocusChangeListener.onFocusChange((View)ToolbarEditLayout.this, bl);
                }
            }
        });
    }

    public void setOnFocusChangeListener(View.OnFocusChangeListener onFocusChangeListener) {
        this.mFocusChangeListener = onFocusChangeListener;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.mGo.setEnabled(bl);
        this.mEditText.setEnabled(bl);
    }

    public void setPrivateMode(boolean bl) {
        super.setPrivateMode(bl);
        this.mEditText.setPrivateMode(bl);
    }

    private void updateGoButton(ToolbarEditText.TextType textType) {
        String string2;
        int n;
        if (textType == ToolbarEditText.TextType.EMPTY) {
            this.mGo.setVisibility(8);
            return;
        }
        this.mGo.setVisibility(0);
        if (textType == ToolbarEditText.TextType.SEARCH_QUERY) {
            n = R.drawable.ic_url_bar_search;
            string2 = this.getContext().getString(R.string.search);
        } else {
            n = R.drawable.ic_url_bar_go;
            string2 = this.getContext().getString(R.string.go);
        }
        this.mGo.setImageResource(n);
        this.mGo.setContentDescription((CharSequence)string2);
    }

    private void showSoftInput() {
        InputMethodManager inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
        inputMethodManager.showSoftInput((View)this.mEditText, 1);
    }

    void prepareShowAnimation(PropertyAnimator propertyAnimator) {
        if (propertyAnimator == null) {
            this.mEditText.requestFocus();
            this.showSoftInput();
            return;
        }
        propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

            public void onPropertyAnimationStart() {
                ViewHelper.setAlpha((View)ToolbarEditLayout.this.mGo, 0.0f);
                ToolbarEditLayout.this.mEditText.requestFocus();
            }

            public void onPropertyAnimationEnd() {
                ViewHelper.setAlpha((View)ToolbarEditLayout.this.mGo, 1.0f);
                ToolbarEditLayout.this.showSoftInput();
            }
        });
    }

    void setOnCommitListener(BrowserToolbar.OnCommitListener onCommitListener) {
        this.mCommitListener = onCommitListener;
        this.mEditText.setOnCommitListener(onCommitListener);
    }

    void setOnDismissListener(BrowserToolbar.OnDismissListener onDismissListener) {
        this.mEditText.setOnDismissListener(onDismissListener);
    }

    void setOnFilterListener(BrowserToolbar.OnFilterListener onFilterListener) {
        this.mEditText.setOnFilterListener(onFilterListener);
    }

    boolean onKey(int n, KeyEvent keyEvent) {
        int n2 = this.mEditText.getSelectionStart();
        int n3 = this.mEditText.getSelectionEnd();
        this.mEditText.dispatchKeyEvent(keyEvent);
        int n4 = this.mEditText.getSelectionStart();
        int n5 = this.mEditText.getSelectionEnd();
        if (n2 != n4 || n3 != n5) {
            this.mEditText.requestFocusFromTouch();
            this.mEditText.setSelection(n4, n5);
        }
        return true;
    }

    void onEditSuggestion(String string2) {
        this.mEditText.setText(string2);
        this.mEditText.setSelection(this.mEditText.getText().length());
        this.mEditText.requestFocus();
        this.showSoftInput();
    }

    void setText(String string2) {
        this.mEditText.setText(string2);
    }

    String getText() {
        return this.mEditText.getText().toString();
    }
}

