/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.webapp;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoThread;
import org.mozilla.gecko.webapp.ApkResources;
import org.mozilla.gecko.webapp.InstallHelper;
import org.mozilla.gecko.webapp.WebAppAllocator;

public class InstallListener
extends BroadcastReceiver {
    private static String LOGTAG = "GeckoInstallListener";
    private JSONObject mData = null;
    private String mManifestUrl;

    public InstallListener(String string2, JSONObject jSONObject) {
        this.mData = jSONObject;
        this.mManifestUrl = string2;
        assert (this.mManifestUrl != null);
    }

    public void onReceive(Context context, Intent intent) {
        String string2 = intent.getData().getSchemeSpecificPart();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            Log.i((String)LOGTAG, (String)"No package name defined in intent");
            return;
        }
        ApkResources apkResources = null;
        try {
            apkResources = new ApkResources(context, string2);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e((String)LOGTAG, (String)"Can't find package that's just been installed");
            return;
        }
        String string3 = apkResources.getManifestUrl();
        if (TextUtils.isEmpty((CharSequence)string3)) {
            Log.i((String)LOGTAG, (String)"No manifest URL present in metadata");
            return;
        }
        if (!this.isCorrectManifest(string3)) {
            Log.i((String)LOGTAG, (String)("Waiting to finish installing " + this.mManifestUrl + " but this is " + string3));
        }
        if (GeckoThread.checkLaunchState(GeckoThread.LaunchState.GeckoRunning)) {
            InstallHelper installHelper = new InstallHelper(context, apkResources, null);
            try {
                JSONObject jSONObject = this.mData;
                jSONObject = new JSONObject().put("request", (Object)jSONObject);
                WebAppAllocator webAppAllocator = WebAppAllocator.getInstance(context);
                int n = webAppAllocator.findOrAllocatePackage(string2);
                installHelper.startInstall("webapp" + n, jSONObject);
            }
            catch (JSONException jSONException) {
                Log.e((String)LOGTAG, (String)"Couldn't parse data from mozApps.install()", (Throwable)jSONException);
            }
            catch (IOException iOException) {
                Log.e((String)LOGTAG, (String)"Couldn't install packaged app", (Throwable)iOException);
            }
        }
        this.cleanup();
        context.unregisterReceiver((BroadcastReceiver)this);
    }

    public boolean isCorrectManifest(String string2) {
        try {
            URL uRL = new URL(this.mManifestUrl);
            URL uRL2 = new URL(string2);
            return uRL.sameFile(uRL2);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    public void cleanup() {
        String string2 = this.mManifestUrl.replaceAll("[^a-zA-Z0-9]", "");
        File file = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS), string2 + ".apk");
        if (file.exists()) {
            file.delete();
            Log.i((String)LOGTAG, (String)"Downloaded APK file deleted");
        }
    }
}

