/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.util.Log;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public final class JSONUtils {
    private static final String LOGTAG = "JSONUtils";

    private JSONUtils() {
    }

    public static URL getURL(String string, JSONObject jSONObject) {
        String string2 = jSONObject.optString(string, null);
        if (string2 == null) {
            return null;
        }
        try {
            return new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            Log.e((String)LOGTAG, (String)"", (Throwable)new IllegalStateException(string + "=" + string2, malformedURLException));
            return null;
        }
    }

    public static void putURL(String string, URL uRL, JSONObject jSONObject) {
        String string2 = uRL.toString();
        try {
            jSONObject.put(string, (Object)string2);
        }
        catch (JSONException jSONException) {
            throw new IllegalArgumentException(string + "=" + string2, jSONException);
        }
    }

    public static UUID getUUID(String string, JSONObject jSONObject) {
        String string2 = jSONObject.optString(string, null);
        return string2 != null ? UUID.fromString(string2) : null;
    }

    public static void putUUID(String string, UUID uUID, JSONObject jSONObject) {
        String string2 = uUID.toString();
        try {
            jSONObject.put(string, (Object)string2);
        }
        catch (JSONException jSONException) {
            throw new IllegalArgumentException(string + "=" + string2, jSONException);
        }
    }
}

