/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.activities;

import android.accounts.Account;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import ch.boye.httpclientandroidlib.HttpResponse;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountClient10;
import org.mozilla.gecko.background.fxa.FxAccountClient20;
import org.mozilla.gecko.fxa.FxAccountConstants;
import org.mozilla.gecko.fxa.activities.FxAccountAbstractSetupActivity;
import org.mozilla.gecko.fxa.activities.FxAccountSetupTask;
import org.mozilla.gecko.fxa.activities.FxAccountSignInActivity;
import org.mozilla.gecko.fxa.activities.FxAccountStatusActivity;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.fxa.authenticator.FxAccountAuthenticator;
import org.mozilla.gecko.sync.HTTPFailureException;
import org.mozilla.gecko.sync.net.SyncStorageResponse;

public class FxAccountCreateAccountActivity
extends FxAccountAbstractSetupActivity {
    protected static final String LOG_TAG = FxAccountCreateAccountActivity.class.getSimpleName();
    protected EditText yearEdit;

    public void onCreate(Bundle bundle) {
        Logger.debug(LOG_TAG, "onCreate(" + bundle + ")");
        super.onCreate(bundle);
        this.setContentView(R.layout.fxaccount_create_account);
        this.linkifyTextViews(null, new int[]{R.id.policy});
        this.localErrorTextView = (TextView)this.ensureFindViewById(null, R.id.local_error, "local error text view");
        this.emailEdit = (EditText)this.ensureFindViewById(null, R.id.email, "email edit");
        this.passwordEdit = (EditText)this.ensureFindViewById(null, R.id.password, "password edit");
        this.showPasswordButton = (Button)this.ensureFindViewById(null, R.id.show_password, "show password button");
        this.yearEdit = (EditText)this.ensureFindViewById(null, R.id.year_edit, "year edit");
        this.button = (Button)this.ensureFindViewById(null, R.id.create_account_button, "create account button");
        this.createCreateAccountButton();
        this.createYearEdit();
        this.addListeners();
        this.updateButtonState();
        this.createShowPasswordButton();
        this.launchActivityOnClick(this.ensureFindViewById(null, R.id.sign_in_instead_link, "sign in instead link"), FxAccountSignInActivity.class);
    }

    public void onResume() {
        super.onResume();
        if (FxAccountAuthenticator.getFirefoxAccounts((Context)this).length > 0) {
            this.redirectToActivity(FxAccountStatusActivity.class);
            return;
        }
    }

    protected void createYearEdit() {
        this.yearEdit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                CharSequence[] charSequenceArray = new String[20];
                for (int i = 0; i < charSequenceArray.length; ++i) {
                    charSequenceArray[i] = Integer.toString(2014 - i);
                }
                DialogInterface.OnClickListener onClickListener = new DialogInterface.OnClickListener((String[])charSequenceArray){
                    final /* synthetic */ String[] val$years;
                    {
                        this.val$years = stringArray;
                    }

                    public void onClick(DialogInterface dialogInterface, int n) {
                        FxAccountCreateAccountActivity.this.yearEdit.setText((CharSequence)this.val$years[n]);
                    }
                };
                AlertDialog alertDialog = new AlertDialog.Builder((Context)FxAccountCreateAccountActivity.this).setTitle(R.string.fxaccount_when_were_you_born).setItems(charSequenceArray, onClickListener).setIcon(R.drawable.fxaccount_icon).create();
                alertDialog.show();
            }
        });
    }

    public void createAccount(String string2, String string3) {
        String string4 = "https://api-accounts-onepw.dev.lcip.org";
        CreateAccountDelegate createAccountDelegate = new CreateAccountDelegate(string2, string3, string4);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        FxAccountClient20 fxAccountClient20 = new FxAccountClient20(string4, executorService);
        try {
            new FxAccountSetupTask.FxAccountSignUpTask((Context)this, string2, string3, fxAccountClient20, createAccountDelegate).execute(new Void[0]);
        }
        catch (Exception exception) {
            this.showRemoteError(exception);
        }
    }

    protected void createCreateAccountButton() {
        this.button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (!FxAccountCreateAccountActivity.this.updateButtonState()) {
                    return;
                }
                String string2 = FxAccountCreateAccountActivity.this.emailEdit.getText().toString();
                String string3 = FxAccountCreateAccountActivity.this.passwordEdit.getText().toString();
                FxAccountCreateAccountActivity.this.createAccount(string2, string3);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CreateAccountDelegate
    implements FxAccountClient10.RequestDelegate<String> {
        public final String email;
        public final String password;
        public final String serverURI;

        public CreateAccountDelegate(String string2, String string3, String string4) {
            this.email = string2;
            this.password = string3;
            this.serverURI = string4;
        }

        @Override
        public void handleError(Exception exception) {
            FxAccountCreateAccountActivity.this.showRemoteError(exception);
        }

        @Override
        public void handleFailure(int n, HttpResponse httpResponse) {
            this.handleError(new HTTPFailureException(new SyncStorageResponse(httpResponse)));
        }

        @Override
        public void handleSuccess(String string2) {
            Account account;
            FxAccountCreateAccountActivity fxAccountCreateAccountActivity = FxAccountCreateAccountActivity.this;
            Logger.info(LOG_TAG, "Got success creating account.");
            try {
                account = AndroidFxAccount.addAndroidAccount((Context)fxAccountCreateAccountActivity, this.email, this.password, this.serverURI, null, null, false);
                if (account == null) {
                    throw new RuntimeException("XXX what?");
                }
            }
            catch (Exception exception) {
                this.handleError(exception);
                return;
            }
            if (FxAccountConstants.LOG_PERSONAL_INFORMATION) {
                new AndroidFxAccount((Context)fxAccountCreateAccountActivity, account).dump();
            }
            Toast.makeText((Context)FxAccountCreateAccountActivity.this.getApplicationContext(), (CharSequence)"Got success creating account.", (int)1).show();
            FxAccountCreateAccountActivity.this.redirectToActivity(FxAccountStatusActivity.class);
        }
    }
}

