/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.activities;

import android.accounts.Account;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import ch.boye.httpclientandroidlib.HttpResponse;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountClient10;
import org.mozilla.gecko.background.fxa.FxAccountClient20;
import org.mozilla.gecko.fxa.FxAccountConstants;
import org.mozilla.gecko.fxa.activities.FxAccountAbstractSetupActivity;
import org.mozilla.gecko.fxa.activities.FxAccountCreateAccountActivity;
import org.mozilla.gecko.fxa.activities.FxAccountSetupTask;
import org.mozilla.gecko.fxa.activities.FxAccountStatusActivity;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.fxa.authenticator.FxAccountAuthenticator;
import org.mozilla.gecko.sync.HTTPFailureException;
import org.mozilla.gecko.sync.net.SyncStorageResponse;

public class FxAccountSignInActivity
extends FxAccountAbstractSetupActivity {
    protected static final String LOG_TAG = FxAccountSignInActivity.class.getSimpleName();

    public void onCreate(Bundle bundle) {
        Logger.debug(LOG_TAG, "onCreate(" + bundle + ")");
        super.onCreate(bundle);
        this.setContentView(R.layout.fxaccount_sign_in);
        this.localErrorTextView = (TextView)this.ensureFindViewById(null, R.id.local_error, "local error text view");
        this.emailEdit = (EditText)this.ensureFindViewById(null, R.id.email, "email edit");
        this.passwordEdit = (EditText)this.ensureFindViewById(null, R.id.password, "password edit");
        this.showPasswordButton = (Button)this.ensureFindViewById(null, R.id.show_password, "show password button");
        this.button = (Button)this.ensureFindViewById(null, R.id.sign_in_button, "sign in button");
        this.minimumPasswordLength = 1;
        this.createSignInButton();
        this.addListeners();
        this.updateButtonState();
        this.createShowPasswordButton();
        this.launchActivityOnClick(this.ensureFindViewById(null, R.id.create_account_link, "create account instead link"), FxAccountCreateAccountActivity.class);
        this.launchActivityOnClick(this.ensureFindViewById(null, R.id.forgot_password_link, "forgot password link"), null);
    }

    public void onResume() {
        super.onResume();
        if (FxAccountAuthenticator.getFirefoxAccounts((Context)this).length > 0) {
            this.redirectToActivity(FxAccountStatusActivity.class);
            return;
        }
    }

    public void signIn(String string2, String string3) {
        String string4 = "https://api-accounts-onepw.dev.lcip.org";
        SignInDelegate signInDelegate = new SignInDelegate(string2, string3, string4);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        FxAccountClient20 fxAccountClient20 = new FxAccountClient20(string4, executorService);
        try {
            new FxAccountSetupTask.FxAccountSignInTask((Context)this, string2, string3, fxAccountClient20, signInDelegate).execute(new Void[0]);
        }
        catch (Exception exception) {
            this.showRemoteError(exception);
        }
    }

    protected void createSignInButton() {
        this.button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String string2 = FxAccountSignInActivity.this.emailEdit.getText().toString();
                String string3 = FxAccountSignInActivity.this.passwordEdit.getText().toString();
                FxAccountSignInActivity.this.signIn(string2, string3);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SignInDelegate
    implements FxAccountClient10.RequestDelegate<FxAccountClient20.LoginResponse> {
        public final String email;
        public final String password;
        public final String serverURI;

        public SignInDelegate(String string2, String string3, String string4) {
            this.email = string2;
            this.password = string3;
            this.serverURI = string4;
        }

        @Override
        public void handleError(Exception exception) {
            FxAccountSignInActivity.this.showRemoteError(exception);
        }

        @Override
        public void handleFailure(int n, HttpResponse httpResponse) {
            FxAccountSignInActivity.this.showRemoteError(new HTTPFailureException(new SyncStorageResponse(httpResponse)));
        }

        @Override
        public void handleSuccess(FxAccountClient20.LoginResponse loginResponse) {
            Account account;
            FxAccountSignInActivity fxAccountSignInActivity = FxAccountSignInActivity.this;
            Logger.info(LOG_TAG, "Got success signing in.");
            try {
                account = AndroidFxAccount.addAndroidAccount((Context)fxAccountSignInActivity, this.email, this.password, this.serverURI, loginResponse.sessionToken, loginResponse.keyFetchToken, loginResponse.verified);
                if (account == null) {
                    throw new RuntimeException("XXX what?");
                }
            }
            catch (Exception exception) {
                this.handleError(exception);
                return;
            }
            if (FxAccountConstants.LOG_PERSONAL_INFORMATION) {
                new AndroidFxAccount((Context)fxAccountSignInActivity, account).dump();
            }
            Toast.makeText((Context)FxAccountSignInActivity.this.getApplicationContext(), (CharSequence)"Got success creating account.", (int)1).show();
            FxAccountSignInActivity.this.redirectToActivity(FxAccountStatusActivity.class);
        }
    }
}

