/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import org.mozilla.gecko.ActionModeCompatView;
import org.mozilla.gecko.widget.GeckoPopupMenu;

class ActionModeCompat
implements GeckoPopupMenu.OnMenuItemClickListener,
View.OnClickListener {
    private final String LOGTAG = "GeckoActionModeCompat";
    private Callback mCallback;
    private ActionModeCompatView mView;
    private Presenter mPresenter;

    public ActionModeCompat(Presenter presenter, Callback callback, ActionModeCompatView actionModeCompatView) {
        this.mPresenter = presenter;
        this.mCallback = callback;
        this.mView = actionModeCompatView;
        this.mView.initForMode(this);
    }

    public void finish() {
        this.mView.getMenu().clear();
        if (this.mCallback != null) {
            this.mCallback.onDestroyActionMode(this);
        }
    }

    public CharSequence getTitle() {
        return this.mView.getTitle();
    }

    public void setTitle(CharSequence charSequence) {
        this.mView.setTitle(charSequence);
    }

    public void setTitle(int n) {
        this.mView.setTitle(n);
    }

    public Menu getMenu() {
        return this.mView.getMenu();
    }

    public void invalidate() {
        if (this.mCallback != null) {
            this.mCallback.onPrepareActionMode(this, this.mView.getMenu());
        }
        this.mView.invalidate();
    }

    public boolean onMenuItemClick(MenuItem menuItem) {
        if (this.mCallback != null) {
            return this.mCallback.onActionItemClicked(this, menuItem);
        }
        return false;
    }

    public void onClick(View view) {
        this.mPresenter.endActionModeCompat();
    }

    public static interface Presenter {
        public void startActionModeCompat(Callback var1);

        public void endActionModeCompat();
    }

    public static interface Callback {
        public boolean onCreateActionMode(ActionModeCompat var1, Menu var2);

        public boolean onPrepareActionMode(ActionModeCompat var1, Menu var2);

        public boolean onActionItemClicked(ActionModeCompat var1, MenuItem var2);

        public void onDestroyActionMode(ActionModeCompat var1);
    }
}

