/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.mozilla.gecko.home.HomeConfig;
import org.mozilla.gecko.home.HomeFragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HomeAdapter
extends FragmentStatePagerAdapter {
    private final Context mContext;
    private final ArrayList<PanelInfo> mPanelInfos;
    private final HashMap<String, Fragment> mPanels;
    private boolean mCanLoadHint;
    private OnAddPanelListener mAddPanelListener;

    public HomeAdapter(Context context, FragmentManager fragmentManager) {
        super(fragmentManager);
        this.mContext = context;
        this.mCanLoadHint = false;
        this.mPanelInfos = new ArrayList();
        this.mPanels = new HashMap();
    }

    public int getCount() {
        return this.mPanelInfos.size();
    }

    public Fragment getItem(int n) {
        PanelInfo panelInfo = this.mPanelInfos.get(n);
        return Fragment.instantiate((Context)this.mContext, (String)panelInfo.getClassName(), (Bundle)panelInfo.getArgs());
    }

    public CharSequence getPageTitle(int n) {
        if (this.mPanelInfos.size() > 0) {
            PanelInfo panelInfo = this.mPanelInfos.get(n);
            return panelInfo.getTitle().toUpperCase();
        }
        return null;
    }

    public Object instantiateItem(ViewGroup viewGroup, int n) {
        Fragment fragment = (Fragment)super.instantiateItem(viewGroup, n);
        this.mPanels.put(this.mPanelInfos.get(n).getId(), fragment);
        return fragment;
    }

    public void destroyItem(ViewGroup viewGroup, int n, Object object) {
        super.destroyItem(viewGroup, n, object);
        this.mPanels.remove(this.mPanelInfos.get(n).getId());
    }

    public void setOnAddPanelListener(OnAddPanelListener onAddPanelListener) {
        this.mAddPanelListener = onAddPanelListener;
    }

    public int getItemPosition(String string2) {
        for (int i = 0; i < this.mPanelInfos.size(); ++i) {
            String string3 = this.mPanelInfos.get(i).getId();
            if (!string3.equals(string2)) continue;
            return i;
        }
        return -1;
    }

    public String getPanelIdAtPosition(int n) {
        if (this.mPanelInfos.isEmpty()) {
            return null;
        }
        return this.mPanelInfos.get(n).getId();
    }

    private void addPanel(PanelInfo panelInfo) {
        this.mPanelInfos.add(panelInfo);
        if (this.mAddPanelListener != null) {
            this.mAddPanelListener.onAddPanel(panelInfo.getTitle());
        }
    }

    public void update(List<HomeConfig.PanelConfig> list) {
        this.mPanels.clear();
        this.mPanelInfos.clear();
        if (list != null) {
            for (HomeConfig.PanelConfig panelConfig : list) {
                PanelInfo panelInfo = new PanelInfo(panelConfig);
                this.addPanel(panelInfo);
            }
        }
        this.notifyDataSetChanged();
    }

    public boolean getCanLoadHint() {
        return this.mCanLoadHint;
    }

    public void setCanLoadHint(boolean bl) {
        this.mCanLoadHint = bl;
        for (Fragment fragment : this.mPanels.values()) {
            HomeFragment homeFragment = (HomeFragment)fragment;
            homeFragment.setCanLoadHint(bl);
        }
    }

    private final class PanelInfo {
        private final HomeConfig.PanelConfig mPanelConfig;

        PanelInfo(HomeConfig.PanelConfig panelConfig) {
            this.mPanelConfig = panelConfig;
        }

        public String getId() {
            return this.mPanelConfig.getId();
        }

        public String getTitle() {
            return this.mPanelConfig.getTitle();
        }

        public String getClassName() {
            HomeConfig.PanelType panelType = this.mPanelConfig.getType();
            return panelType.getPanelClass().getName();
        }

        public Bundle getArgs() {
            Bundle bundle = new Bundle();
            bundle.putBoolean("canLoad", HomeAdapter.this.mCanLoadHint);
            if (this.mPanelConfig.getType() == HomeConfig.PanelType.LIST) {
                bundle.putParcelable("panelConfig", (Parcelable)this.mPanelConfig);
            }
            return bundle;
        }
    }

    static interface OnAddPanelListener {
        public void onAddPanel(String var1);
    }
}

