/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.util.EnumSet;
import java.util.List;
import org.mozilla.gecko.home.BookmarksPanel;
import org.mozilla.gecko.home.HistoryPanel;
import org.mozilla.gecko.home.HomeConfigPrefsBackend;
import org.mozilla.gecko.home.ListPanel;
import org.mozilla.gecko.home.ReadingListPanel;
import org.mozilla.gecko.home.TopSitesPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HomeConfig {
    private final HomeConfigBackend mBackend;

    public HomeConfig(HomeConfigBackend homeConfigBackend) {
        this.mBackend = homeConfigBackend;
    }

    public List<PanelConfig> load() {
        return this.mBackend.load();
    }

    public void save(List<PanelConfig> list) {
        this.mBackend.save(list);
    }

    public void setOnChangeListener(OnChangeListener onChangeListener) {
        this.mBackend.setOnChangeListener(onChangeListener);
    }

    public static HomeConfig getDefault(Context context) {
        return new HomeConfig(new HomeConfigPrefsBackend(context));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface HomeConfigBackend {
        public List<PanelConfig> load();

        public void save(List<PanelConfig> var1);

        public void setOnChangeListener(OnChangeListener var1);
    }

    public static interface OnChangeListener {
        public void onChange();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PanelConfig
    implements Parcelable {
        private final PanelType mType;
        private final String mTitle;
        private final String mId;
        private final EnumSet<Flags> mFlags;
        public static final Parcelable.Creator<PanelConfig> CREATOR = new Parcelable.Creator<PanelConfig>(){

            public PanelConfig createFromParcel(Parcel parcel) {
                return new PanelConfig(parcel);
            }

            public PanelConfig[] newArray(int n) {
                return new PanelConfig[n];
            }
        };

        public PanelConfig(Parcel parcel) {
            this.mType = (PanelType)parcel.readParcelable(this.getClass().getClassLoader());
            this.mTitle = parcel.readString();
            this.mId = parcel.readString();
            this.mFlags = (EnumSet)parcel.readSerializable();
        }

        public PanelConfig(PanelType panelType, String string2) {
            this(panelType, string2, EnumSet.noneOf(Flags.class));
        }

        public PanelConfig(PanelType panelType, String string2, EnumSet<Flags> enumSet) {
            this(panelType, string2, panelType.toString(), enumSet);
        }

        public PanelConfig(PanelType panelType, String string2, String string3) {
            this(panelType, string2, string3, EnumSet.noneOf(Flags.class));
        }

        public PanelConfig(PanelType panelType, String string2, String string3, EnumSet<Flags> enumSet) {
            if (panelType == null) {
                throw new IllegalArgumentException("Can't create PanelConfig with null type");
            }
            this.mType = panelType;
            if (string2 == null) {
                throw new IllegalArgumentException("Can't create PanelConfig with null title");
            }
            this.mTitle = string2;
            if (string3 == null) {
                throw new IllegalArgumentException("Can't create PanelConfig with null id");
            }
            this.mId = string3;
            if (enumSet == null) {
                throw new IllegalArgumentException("Can't create PanelConfig with null flags");
            }
            this.mFlags = enumSet;
        }

        public PanelType getType() {
            return this.mType;
        }

        public String getTitle() {
            return this.mTitle;
        }

        public String getId() {
            return this.mId;
        }

        public boolean isDefault() {
            return this.mFlags.contains((Object)Flags.DEFAULT_PANEL);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeParcelable((Parcelable)this.mType, 0);
            parcel.writeString(this.mTitle);
            parcel.writeString(this.mId);
            parcel.writeSerializable(this.mFlags);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Flags {
            DEFAULT_PANEL;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PanelType implements Parcelable
    {
        TOP_SITES("top_sites", TopSitesPanel.class),
        BOOKMARKS("bookmarks", BookmarksPanel.class),
        HISTORY("history", HistoryPanel.class),
        READING_LIST("reading_list", ReadingListPanel.class),
        LIST("list", ListPanel.class);

        private final String mId;
        private final Class<?> mPanelClass;
        public static final Parcelable.Creator<PanelType> CREATOR;

        private PanelType(String string3, Class<?> clazz) {
            this.mId = string3;
            this.mPanelClass = clazz;
        }

        public static PanelType fromId(String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("Could not convert null String to PanelType");
            }
            for (PanelType panelType : PanelType.values()) {
                if (!TextUtils.equals((CharSequence)panelType.mId, (CharSequence)string2.toLowerCase())) continue;
                return panelType;
            }
            throw new IllegalArgumentException("Could not convert String id to PanelType");
        }

        public String toString() {
            return this.mId;
        }

        public Class<?> getPanelClass() {
            return this.mPanelClass;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.ordinal());
        }

        static {
            CREATOR = new Parcelable.Creator<PanelType>(){

                public PanelType createFromParcel(Parcel parcel) {
                    return PanelType.values()[parcel.readInt()];
                }

                public PanelType[] newArray(int n) {
                    return new PanelType[n];
                }
            };
        }
    }
}

