/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.middleware;

import java.util.concurrent.ExecutorService;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.middleware.MiddlewareRepository;
import org.mozilla.gecko.sync.repositories.InactiveSessionException;
import org.mozilla.gecko.sync.repositories.InvalidSessionTransitionException;
import org.mozilla.gecko.sync.repositories.RepositorySession;
import org.mozilla.gecko.sync.repositories.RepositorySessionBundle;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionBeginDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionFinishDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionGuidsSinceDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionWipeDelegate;

public abstract class MiddlewareRepositorySession
extends RepositorySession {
    private static final String LOG_TAG = "MiddlewareSession";
    protected final RepositorySession inner;

    public MiddlewareRepositorySession(RepositorySession repositorySession, MiddlewareRepository middlewareRepository) {
        super(middlewareRepository);
        this.inner = repositorySession;
    }

    public void wipe(RepositorySessionWipeDelegate repositorySessionWipeDelegate) {
        this.inner.wipe(repositorySessionWipeDelegate);
    }

    public void begin(RepositorySessionBeginDelegate repositorySessionBeginDelegate) throws InvalidSessionTransitionException {
        this.inner.begin(new MiddlewareRepositorySessionBeginDelegate(this, repositorySessionBeginDelegate));
    }

    public void finish(RepositorySessionFinishDelegate repositorySessionFinishDelegate) throws InactiveSessionException {
        this.inner.finish(new MiddlewareRepositorySessionFinishDelegate(this, repositorySessionFinishDelegate));
    }

    public synchronized void ensureActive() throws InactiveSessionException {
        this.inner.ensureActive();
    }

    public synchronized boolean isActive() {
        return this.inner.isActive();
    }

    public synchronized RepositorySession.SessionStatus getStatus() {
        return this.inner.getStatus();
    }

    public synchronized void setStatus(RepositorySession.SessionStatus sessionStatus) {
        this.inner.setStatus(sessionStatus);
    }

    public synchronized void transitionFrom(RepositorySession.SessionStatus sessionStatus, RepositorySession.SessionStatus sessionStatus2) throws InvalidSessionTransitionException {
        this.inner.transitionFrom(sessionStatus, sessionStatus2);
    }

    public void abort() {
        this.inner.abort();
    }

    public void abort(RepositorySessionFinishDelegate repositorySessionFinishDelegate) {
        this.inner.abort(new MiddlewareRepositorySessionFinishDelegate(this, repositorySessionFinishDelegate));
    }

    public void guidsSince(long l, RepositorySessionGuidsSinceDelegate repositorySessionGuidsSinceDelegate) {
        this.inner.guidsSince(l, repositorySessionGuidsSinceDelegate);
    }

    public void storeDone() {
        this.inner.storeDone();
    }

    public void storeDone(long l) {
        this.inner.storeDone(l);
    }

    public class MiddlewareRepositorySessionFinishDelegate
    implements RepositorySessionFinishDelegate {
        private final MiddlewareRepositorySession outerSession;
        private final RepositorySessionFinishDelegate next;

        public MiddlewareRepositorySessionFinishDelegate(MiddlewareRepositorySession middlewareRepositorySession2, RepositorySessionFinishDelegate repositorySessionFinishDelegate) {
            this.outerSession = middlewareRepositorySession2;
            this.next = repositorySessionFinishDelegate;
        }

        public void onFinishFailed(Exception exception) {
            this.next.onFinishFailed(exception);
        }

        public void onFinishSucceeded(RepositorySession repositorySession, RepositorySessionBundle repositorySessionBundle) {
            this.next.onFinishSucceeded(this.outerSession, repositorySessionBundle);
        }

        public RepositorySessionFinishDelegate deferredFinishDelegate(ExecutorService executorService) {
            return this;
        }
    }

    public class MiddlewareRepositorySessionBeginDelegate
    implements RepositorySessionBeginDelegate {
        private MiddlewareRepositorySession outerSession;
        private RepositorySessionBeginDelegate next;

        public MiddlewareRepositorySessionBeginDelegate(MiddlewareRepositorySession middlewareRepositorySession2, RepositorySessionBeginDelegate repositorySessionBeginDelegate) {
            this.outerSession = middlewareRepositorySession2;
            this.next = repositorySessionBeginDelegate;
        }

        public void onBeginFailed(Exception exception) {
            this.next.onBeginFailed(exception);
        }

        public void onBeginSucceeded(RepositorySession repositorySession) {
            this.next.onBeginSucceeded(this.outerSession);
        }

        public RepositorySessionBeginDelegate deferredBeginDelegate(ExecutorService executorService) {
            final RepositorySessionBeginDelegate repositorySessionBeginDelegate = this.next.deferredBeginDelegate(executorService);
            return new RepositorySessionBeginDelegate(){

                public void onBeginSucceeded(RepositorySession repositorySession) {
                    if (MiddlewareRepositorySession.this.inner != repositorySession) {
                        Logger.warn(MiddlewareRepositorySession.LOG_TAG, "Got onBeginSucceeded for session " + repositorySession + ", not our inner session!");
                    }
                    repositorySessionBeginDelegate.onBeginSucceeded(MiddlewareRepositorySessionBeginDelegate.this.outerSession);
                }

                public void onBeginFailed(Exception exception) {
                    repositorySessionBeginDelegate.onBeginFailed(exception);
                }

                public RepositorySessionBeginDelegate deferredBeginDelegate(ExecutorService executorService) {
                    return this;
                }
            };
        }
    }
}

