/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.setup;

import android.accounts.AbstractAccountAuthenticator;
import android.accounts.Account;
import android.accounts.AccountAuthenticatorResponse;
import android.accounts.AccountManager;
import android.accounts.NetworkErrorException;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.setup.SyncAccounts;
import org.mozilla.gecko.sync.setup.activities.SetupSyncActivity;

public class SyncAuthenticatorService
extends Service {
    private static final String LOG_TAG = "SyncAuthService";
    private SyncAccountAuthenticator sAccountAuthenticator = null;

    public void onCreate() {
        Logger.debug(LOG_TAG, "onCreate");
        this.sAccountAuthenticator = this.getAuthenticator();
    }

    public IBinder onBind(Intent intent) {
        if (intent.getAction().equals("android.accounts.AccountAuthenticator")) {
            return this.getAuthenticator().getIBinder();
        }
        return null;
    }

    private SyncAccountAuthenticator getAuthenticator() {
        if (this.sAccountAuthenticator == null) {
            this.sAccountAuthenticator = new SyncAccountAuthenticator((Context)this);
        }
        return this.sAccountAuthenticator;
    }

    public static Bundle getPlainAuthToken(Context context, Account account) throws NetworkErrorException {
        String string2;
        AccountManager accountManager = AccountManager.get((Context)context);
        String string3 = accountManager.getPassword(account);
        if (string3 == null) {
            Logger.warn(LOG_TAG, "Returning null bundle for getPlainAuthToken since Account password is null.");
            return null;
        }
        Bundle bundle = new Bundle();
        bundle.putString("accountType", "org.mozilla.fennec_sync");
        String string4 = accountManager.getUserData(account, "option.serverUrl");
        bundle.putString("option.serverUrl", string4);
        bundle.putString("authAccount", account.name);
        try {
            string2 = Utils.usernameFromAccount(account.name);
            Logger.pii(LOG_TAG, "Account " + account.name + " hashes to " + string2 + ".");
            Logger.debug(LOG_TAG, "Setting username. Null? " + (string2 == null));
            bundle.putString("option.username", string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Logger.debug(LOG_TAG, "Exception in account lookup: " + noSuchAlgorithmException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.debug(LOG_TAG, "Exception in account lookup: " + unsupportedEncodingException);
        }
        string2 = accountManager.getUserData(account, "option.synckey");
        Logger.debug(LOG_TAG, "Setting sync key. Null? " + (string2 == null));
        bundle.putString("option.synckey", string2);
        bundle.putString("authtoken", string3);
        return bundle;
    }

    private static class SyncAccountAuthenticator
    extends AbstractAccountAuthenticator {
        private Context mContext;

        public SyncAccountAuthenticator(Context context) {
            super(context);
            this.mContext = context;
        }

        public Bundle addAccount(AccountAuthenticatorResponse accountAuthenticatorResponse, String string2, String string3, String[] stringArray, Bundle bundle) throws NetworkErrorException {
            Logger.debug(SyncAuthenticatorService.LOG_TAG, "addAccount()");
            Intent intent = new Intent(this.mContext, SetupSyncActivity.class);
            intent.putExtra("accountAuthenticatorResponse", (Parcelable)accountAuthenticatorResponse);
            intent.putExtra("accountType", "org.mozilla.fennec_sync");
            intent.putExtra("isSetup", true);
            Bundle bundle2 = new Bundle();
            bundle2.putParcelable("intent", (Parcelable)intent);
            return bundle2;
        }

        public Bundle confirmCredentials(AccountAuthenticatorResponse accountAuthenticatorResponse, Account account, Bundle bundle) throws NetworkErrorException {
            Logger.debug(SyncAuthenticatorService.LOG_TAG, "confirmCredentials()");
            return null;
        }

        public Bundle editProperties(AccountAuthenticatorResponse accountAuthenticatorResponse, String string2) {
            Logger.debug(SyncAuthenticatorService.LOG_TAG, "editProperties");
            return null;
        }

        public Bundle getAuthToken(AccountAuthenticatorResponse accountAuthenticatorResponse, Account account, String string2, Bundle bundle) throws NetworkErrorException {
            Logger.debug(SyncAuthenticatorService.LOG_TAG, "getAuthToken()");
            if ("auth.plain".equals(string2)) {
                return SyncAuthenticatorService.getPlainAuthToken(this.mContext, account);
            }
            Bundle bundle2 = new Bundle();
            bundle2.putString("errorMessage", "invalid authTokenType");
            return bundle2;
        }

        public String getAuthTokenLabel(String string2) {
            Logger.debug(SyncAuthenticatorService.LOG_TAG, "getAuthTokenLabel()");
            return null;
        }

        public Bundle hasFeatures(AccountAuthenticatorResponse accountAuthenticatorResponse, Account account, String[] stringArray) throws NetworkErrorException {
            Logger.debug(SyncAuthenticatorService.LOG_TAG, "hasFeatures()");
            return null;
        }

        public Bundle updateCredentials(AccountAuthenticatorResponse accountAuthenticatorResponse, Account account, String string2, Bundle bundle) throws NetworkErrorException {
            Logger.debug(SyncAuthenticatorService.LOG_TAG, "updateCredentials()");
            return null;
        }

        public Bundle getAccountRemovalAllowed(AccountAuthenticatorResponse accountAuthenticatorResponse, Account account) throws NetworkErrorException {
            Bundle bundle = super.getAccountRemovalAllowed(accountAuthenticatorResponse, account);
            if (bundle == null || !bundle.containsKey("booleanResult") || bundle.containsKey("intent")) {
                return bundle;
            }
            boolean bl = bundle.getBoolean("booleanResult");
            if (!bl) {
                return bundle;
            }
            Intent intent = SyncAccounts.makeSyncAccountDeletedIntent(this.mContext, AccountManager.get((Context)this.mContext), account);
            Logger.info(SyncAuthenticatorService.LOG_TAG, "Account named " + account.name + " being removed; " + "broadcasting secure intent " + intent.getAction() + ".");
            this.mContext.sendBroadcast(intent, "org.mozilla.fennec_sync.permission.PER_ACCOUNT_TYPE");
            return bundle;
        }
    }
}

