/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.message;

import ch.boye.httpclientandroidlib.HeaderIterator;
import ch.boye.httpclientandroidlib.ParseException;
import ch.boye.httpclientandroidlib.TokenIterator;
import java.util.NoSuchElementException;

public class BasicTokenIterator
implements TokenIterator {
    public static final String HTTP_SEPARATORS = " ,;=()<>@:\\\"/[]?{}\t";
    protected final HeaderIterator headerIt;
    protected String currentHeader;
    protected String currentToken;
    protected int searchPos;

    public BasicTokenIterator(HeaderIterator headerIterator) {
        if (headerIterator == null) {
            throw new IllegalArgumentException("Header iterator must not be null.");
        }
        this.headerIt = headerIterator;
        this.searchPos = this.findNext(-1);
    }

    public boolean hasNext() {
        return this.currentToken != null;
    }

    public String nextToken() throws NoSuchElementException, ParseException {
        if (this.currentToken == null) {
            throw new NoSuchElementException("Iteration already finished.");
        }
        String string = this.currentToken;
        this.searchPos = this.findNext(this.searchPos);
        return string;
    }

    public final Object next() throws NoSuchElementException, ParseException {
        return this.nextToken();
    }

    public final void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Removing tokens is not supported.");
    }

    protected int findNext(int n) throws ParseException {
        if (n < 0) {
            if (!this.headerIt.hasNext()) {
                return -1;
            }
            this.currentHeader = this.headerIt.nextHeader().getValue();
            n = 0;
        } else {
            n = this.findTokenSeparator(n);
        }
        int n2 = this.findTokenStart(n);
        if (n2 < 0) {
            this.currentToken = null;
            return -1;
        }
        int n3 = this.findTokenEnd(n2);
        this.currentToken = this.createToken(this.currentHeader, n2, n3);
        return n3;
    }

    protected String createToken(String string, int n, int n2) {
        return string.substring(n, n2);
    }

    protected int findTokenStart(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Search position must not be negative: " + n);
        }
        boolean bl = false;
        while (!bl && this.currentHeader != null) {
            int n2 = this.currentHeader.length();
            while (!bl && n < n2) {
                char c = this.currentHeader.charAt(n);
                if (this.isTokenSeparator(c) || this.isWhitespace(c)) {
                    ++n;
                    continue;
                }
                if (this.isTokenChar(this.currentHeader.charAt(n))) {
                    bl = true;
                    continue;
                }
                throw new ParseException("Invalid character before token (pos " + n + "): " + this.currentHeader);
            }
            if (bl) continue;
            if (this.headerIt.hasNext()) {
                this.currentHeader = this.headerIt.nextHeader().getValue();
                n = 0;
                continue;
            }
            this.currentHeader = null;
        }
        return bl ? n : -1;
    }

    protected int findTokenSeparator(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Search position must not be negative: " + n);
        }
        boolean bl = false;
        int n2 = this.currentHeader.length();
        while (!bl && n < n2) {
            char c = this.currentHeader.charAt(n);
            if (this.isTokenSeparator(c)) {
                bl = true;
                continue;
            }
            if (this.isWhitespace(c)) {
                ++n;
                continue;
            }
            if (this.isTokenChar(c)) {
                throw new ParseException("Tokens without separator (pos " + n + "): " + this.currentHeader);
            }
            throw new ParseException("Invalid character after token (pos " + n + "): " + this.currentHeader);
        }
        return n;
    }

    protected int findTokenEnd(int n) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException("Token start position must not be negative: " + n);
        }
        int n3 = this.currentHeader.length();
        for (n2 = n + 1; n2 < n3 && this.isTokenChar(this.currentHeader.charAt(n2)); ++n2) {
        }
        return n2;
    }

    protected boolean isTokenSeparator(char c) {
        return c == ',';
    }

    protected boolean isWhitespace(char c) {
        return c == '\t' || Character.isSpaceChar(c);
    }

    protected boolean isTokenChar(char c) {
        if (Character.isLetterOrDigit(c)) {
            return true;
        }
        if (Character.isISOControl(c)) {
            return false;
        }
        return !this.isHttpSeparator(c);
    }

    protected boolean isHttpSeparator(char c) {
        return HTTP_SEPARATORS.indexOf(c) >= 0;
    }
}

