/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.util;

import ch.boye.httpclientandroidlib.HeaderElement;
import ch.boye.httpclientandroidlib.HttpEntity;
import ch.boye.httpclientandroidlib.NameValuePair;
import ch.boye.httpclientandroidlib.ParseException;
import ch.boye.httpclientandroidlib.util.ByteArrayBuffer;
import ch.boye.httpclientandroidlib.util.CharArrayBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public final class EntityUtils {
    private EntityUtils() {
    }

    public static void consume(HttpEntity httpEntity) throws IOException {
        InputStream inputStream;
        if (httpEntity == null) {
            return;
        }
        if (httpEntity.isStreaming() && (inputStream = httpEntity.getContent()) != null) {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(HttpEntity httpEntity) throws IOException {
        if (httpEntity == null) {
            throw new IllegalArgumentException("HTTP entity may not be null");
        }
        InputStream inputStream = httpEntity.getContent();
        if (inputStream == null) {
            return null;
        }
        try {
            int n;
            if (httpEntity.getContentLength() > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("HTTP entity too large to be buffered in memory");
            }
            int n2 = (int)httpEntity.getContentLength();
            if (n2 < 0) {
                n2 = 4096;
            }
            ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(n2);
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayBuffer.append(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayBuffer.toByteArray();
            return byArray2;
        }
        finally {
            inputStream.close();
        }
    }

    public static String getContentCharSet(HttpEntity httpEntity) throws ParseException {
        NameValuePair nameValuePair;
        HeaderElement[] headerElementArray;
        if (httpEntity == null) {
            throw new IllegalArgumentException("HTTP entity may not be null");
        }
        String string = null;
        if (httpEntity.getContentType() != null && (headerElementArray = httpEntity.getContentType().getElements()).length > 0 && (nameValuePair = headerElementArray[0].getParameterByName("charset")) != null) {
            string = nameValuePair.getValue();
        }
        return string;
    }

    public static String getContentMimeType(HttpEntity httpEntity) throws ParseException {
        HeaderElement[] headerElementArray;
        if (httpEntity == null) {
            throw new IllegalArgumentException("HTTP entity may not be null");
        }
        String string = null;
        if (httpEntity.getContentType() != null && (headerElementArray = httpEntity.getContentType().getElements()).length > 0) {
            string = headerElementArray[0].getName();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(HttpEntity httpEntity, String string) throws IOException, ParseException {
        if (httpEntity == null) {
            throw new IllegalArgumentException("HTTP entity may not be null");
        }
        InputStream inputStream = httpEntity.getContent();
        if (inputStream == null) {
            return null;
        }
        try {
            int n;
            String string2;
            if (httpEntity.getContentLength() > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("HTTP entity too large to be buffered in memory");
            }
            int n2 = (int)httpEntity.getContentLength();
            if (n2 < 0) {
                n2 = 4096;
            }
            if ((string2 = EntityUtils.getContentCharSet(httpEntity)) == null) {
                string2 = string;
            }
            if (string2 == null) {
                string2 = "ISO-8859-1";
            }
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string2);
            CharArrayBuffer charArrayBuffer = new CharArrayBuffer(n2);
            char[] cArray = new char[1024];
            while ((n = inputStreamReader.read(cArray)) != -1) {
                charArrayBuffer.append(cArray, 0, n);
            }
            String string3 = charArrayBuffer.toString();
            return string3;
        }
        finally {
            inputStream.close();
        }
    }

    public static String toString(HttpEntity httpEntity) throws IOException, ParseException {
        return EntityUtils.toString(httpEntity, null);
    }
}

