/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.CursorLoader;
import android.support.v4.content.Loader;
import java.util.Queue;
import org.mozilla.gecko.ActivityHandlerHelper;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.util.ActivityResultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CameraVideoResultHandler
implements ActivityResultHandler {
    private static final String LOGTAG = "GeckoCameraVideoResultHandler";
    private final Queue<String> mFilePickerResult;
    private final ActivityHandlerHelper.FileResultHandler mHandler;

    CameraVideoResultHandler(Queue<String> queue) {
        this.mFilePickerResult = queue;
        this.mHandler = null;
    }

    public CameraVideoResultHandler(ActivityHandlerHelper.FileResultHandler fileResultHandler) {
        this.mFilePickerResult = null;
        this.mHandler = fileResultHandler;
    }

    private void sendResult(String string2) {
        if (this.mFilePickerResult != null) {
            this.mFilePickerResult.offer(string2);
        }
        if (this.mHandler != null) {
            this.mHandler.gotFile(string2);
        }
    }

    public void onActivityResult(int n, final Intent intent) {
        if (intent == null || intent.getData() == null || n != -1) {
            this.sendResult("");
            return;
        }
        final FragmentActivity fragmentActivity = (FragmentActivity)GeckoAppShell.getGeckoInterface().getActivity();
        LoaderManager loaderManager = fragmentActivity.getSupportLoaderManager();
        loaderManager.initLoader(intent.hashCode(), null, (LoaderManager.LoaderCallbacks)new LoaderManager.LoaderCallbacks<Cursor>(){

            public Loader<Cursor> onCreateLoader(int n, Bundle bundle) {
                return new CursorLoader((Context)fragmentActivity, intent.getData(), new String[]{"_data"}, null, null, null);
            }

            public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
                if (cursor.moveToFirst()) {
                    CameraVideoResultHandler.this.sendResult(cursor.getString(cursor.getColumnIndexOrThrow("_data")));
                } else {
                    CameraVideoResultHandler.this.sendResult("");
                }
            }

            public void onLoaderReset(Loader<Cursor> loader) {
            }
        });
    }
}

