/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.content.ContentResolver;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.CursorWrapper;
import android.graphics.drawable.BitmapDrawable;
import android.util.SparseArray;
import java.util.List;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.db.LocalBrowserDB;
import org.mozilla.gecko.favicons.decoders.LoadFaviconResult;
import org.mozilla.gecko.mozglue.RobocopTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserDB {
    private static boolean sAreContentProvidersEnabled = true;
    private static BrowserDBIface sDb = null;

    public static void initialize(String string2) {
        sDb = new LocalBrowserDB(string2);
    }

    public static void invalidateCachedState() {
        sDb.invalidateCachedState();
    }

    @RobocopTarget
    public static Cursor filter(ContentResolver contentResolver, CharSequence charSequence, int n) {
        return sDb.filter(contentResolver, charSequence, n);
    }

    public static Cursor getTopSites(ContentResolver contentResolver, int n, int n2) {
        Cursor cursor = sDb.getPinnedSites(contentResolver, n);
        Cursor cursor2 = sDb.getTopSites(contentResolver, n2 - cursor.getCount());
        return new TopSitesCursorWrapper(cursor, cursor2, n);
    }

    public static void updateVisitedHistory(ContentResolver contentResolver, String string2) {
        if (sAreContentProvidersEnabled) {
            sDb.updateVisitedHistory(contentResolver, string2);
        }
    }

    public static void updateHistoryTitle(ContentResolver contentResolver, String string2, String string3) {
        if (sAreContentProvidersEnabled) {
            sDb.updateHistoryTitle(contentResolver, string2, string3);
        }
    }

    public static void updateHistoryEntry(ContentResolver contentResolver, String string2, String string3, long l, int n) {
        if (sAreContentProvidersEnabled) {
            sDb.updateHistoryEntry(contentResolver, string2, string3, l, n);
        }
    }

    @RobocopTarget
    public static Cursor getAllVisitedHistory(ContentResolver contentResolver) {
        return sAreContentProvidersEnabled ? sDb.getAllVisitedHistory(contentResolver) : null;
    }

    public static Cursor getRecentHistory(ContentResolver contentResolver, int n) {
        return sDb.getRecentHistory(contentResolver, n);
    }

    public static void expireHistory(ContentResolver contentResolver, BrowserContract.ExpirePriority expirePriority) {
        if (sDb == null) {
            return;
        }
        if (expirePriority == null) {
            expirePriority = BrowserContract.ExpirePriority.NORMAL;
        }
        sDb.expireHistory(contentResolver, expirePriority);
    }

    public static void removeHistoryEntry(ContentResolver contentResolver, int n) {
        sDb.removeHistoryEntry(contentResolver, n);
    }

    @RobocopTarget
    public static void removeHistoryEntry(ContentResolver contentResolver, String string2) {
        sDb.removeHistoryEntry(contentResolver, string2);
    }

    @RobocopTarget
    public static void clearHistory(ContentResolver contentResolver) {
        sDb.clearHistory(contentResolver);
    }

    @RobocopTarget
    public static Cursor getBookmarksInFolder(ContentResolver contentResolver, long l) {
        return sDb.getBookmarksInFolder(contentResolver, l);
    }

    public static String getUrlForKeyword(ContentResolver contentResolver, String string2) {
        return sDb.getUrlForKeyword(contentResolver, string2);
    }

    public static boolean isVisited(ContentResolver contentResolver, String string2) {
        return sDb.isVisited(contentResolver, string2);
    }

    public static int getReadingListCount(ContentResolver contentResolver) {
        return sDb.getReadingListCount(contentResolver);
    }

    @RobocopTarget
    public static boolean isBookmark(ContentResolver contentResolver, String string2) {
        return sAreContentProvidersEnabled && sDb.isBookmark(contentResolver, string2);
    }

    public static boolean isReadingListItem(ContentResolver contentResolver, String string2) {
        return sAreContentProvidersEnabled && sDb.isReadingListItem(contentResolver, string2);
    }

    public static void addBookmark(ContentResolver contentResolver, String string2, String string3) {
        sDb.addBookmark(contentResolver, string2, string3);
    }

    public static void removeBookmark(ContentResolver contentResolver, int n) {
        sDb.removeBookmark(contentResolver, n);
    }

    @RobocopTarget
    public static void removeBookmarksWithURL(ContentResolver contentResolver, String string2) {
        sDb.removeBookmarksWithURL(contentResolver, string2);
    }

    @RobocopTarget
    public static void updateBookmark(ContentResolver contentResolver, int n, String string2, String string3, String string4) {
        sDb.updateBookmark(contentResolver, n, string2, string3, string4);
    }

    public static void addReadingListItem(ContentResolver contentResolver, String string2, String string3) {
        sDb.addReadingListItem(contentResolver, string2, string3);
    }

    public static void removeReadingListItemWithURL(ContentResolver contentResolver, String string2) {
        sDb.removeReadingListItemWithURL(contentResolver, string2);
    }

    public static LoadFaviconResult getFaviconForFaviconUrl(ContentResolver contentResolver, String string2) {
        return sDb.getFaviconForUrl(contentResolver, string2);
    }

    public static String getFaviconUrlForHistoryUrl(ContentResolver contentResolver, String string2) {
        return sDb.getFaviconUrlForHistoryUrl(contentResolver, string2);
    }

    public static void updateFaviconForUrl(ContentResolver contentResolver, String string2, byte[] byArray, String string3) {
        sDb.updateFaviconForUrl(contentResolver, string2, byArray, string3);
    }

    public static void updateThumbnailForUrl(ContentResolver contentResolver, String string2, BitmapDrawable bitmapDrawable) {
        sDb.updateThumbnailForUrl(contentResolver, string2, bitmapDrawable);
    }

    @RobocopTarget
    public static byte[] getThumbnailForUrl(ContentResolver contentResolver, String string2) {
        return sDb.getThumbnailForUrl(contentResolver, string2);
    }

    public static Cursor getThumbnailsForUrls(ContentResolver contentResolver, List<String> list) {
        return sDb.getThumbnailsForUrls(contentResolver, list);
    }

    @RobocopTarget
    public static void removeThumbnails(ContentResolver contentResolver) {
        sDb.removeThumbnails(contentResolver);
    }

    public static void registerBookmarkObserver(ContentResolver contentResolver, ContentObserver contentObserver) {
        sDb.registerBookmarkObserver(contentResolver, contentObserver);
    }

    public static void registerHistoryObserver(ContentResolver contentResolver, ContentObserver contentObserver) {
        sDb.registerHistoryObserver(contentResolver, contentObserver);
    }

    public static void unregisterContentObserver(ContentResolver contentResolver, ContentObserver contentObserver) {
        contentResolver.unregisterContentObserver(contentObserver);
    }

    public static int getCount(ContentResolver contentResolver, String string2) {
        return sDb.getCount(contentResolver, string2);
    }

    public static void pinSite(ContentResolver contentResolver, String string2, String string3, int n) {
        sDb.pinSite(contentResolver, string2, string3, n);
    }

    public static void unpinSite(ContentResolver contentResolver, int n) {
        sDb.unpinSite(contentResolver, n);
    }

    public static void unpinAllSites(ContentResolver contentResolver) {
        sDb.unpinAllSites(contentResolver);
    }

    public static Cursor getPinnedSites(ContentResolver contentResolver, int n) {
        return sDb.getPinnedSites(contentResolver, n);
    }

    @RobocopTarget
    public static Cursor getBookmarkForUrl(ContentResolver contentResolver, String string2) {
        return sDb.getBookmarkForUrl(contentResolver, string2);
    }

    public static boolean areContentProvidersDisabled() {
        return sAreContentProvidersEnabled;
    }

    public static void setEnableContentProviders(boolean bl) {
        sAreContentProvidersEnabled = bl;
    }

    static {
        sDb = null;
    }

    public static class TopSitesCursorWrapper
    extends CursorWrapper {
        int mIndex = -1;
        Cursor mCursor = null;
        int mSize = 0;
        private SparseArray<PinnedSite> mPinnedSites = null;

        public TopSitesCursorWrapper(Cursor cursor, Cursor cursor2, int n) {
            super(cursor2);
            this.setPinnedSites(cursor);
            this.mCursor = cursor2;
            this.mSize = Math.max(n, this.mPinnedSites.size() + this.mCursor.getCount());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPinnedSites(Cursor cursor) {
            this.mPinnedSites = new SparseArray();
            if (cursor == null) {
                return;
            }
            try {
                if (cursor.getCount() <= 0) {
                    return;
                }
                cursor.moveToPosition(0);
                do {
                    int n = cursor.getInt(cursor.getColumnIndex("position"));
                    String string2 = cursor.getString(cursor.getColumnIndex("url"));
                    String string3 = cursor.getString(cursor.getColumnIndex("title"));
                    this.mPinnedSites.put(n, (Object)new PinnedSite(string3, string2));
                } while (cursor.moveToNext());
            }
            finally {
                cursor.close();
            }
        }

        public boolean hasPinnedSites() {
            return this.mPinnedSites != null && this.mPinnedSites.size() > 0;
        }

        public PinnedSite getPinnedSite(int n) {
            if (!this.hasPinnedSites()) {
                return null;
            }
            return (PinnedSite)this.mPinnedSites.get(n);
        }

        public boolean isPinned() {
            return this.mPinnedSites.get(this.mIndex) != null;
        }

        private int getPinnedBefore(int n) {
            int n2 = 0;
            if (!this.hasPinnedSites()) {
                return n2;
            }
            for (int i = 0; i < n; ++i) {
                if (this.mPinnedSites.get(i) == null) continue;
                ++n2;
            }
            return n2;
        }

        public int getPosition() {
            return this.mIndex;
        }

        public int getCount() {
            return this.mSize;
        }

        public boolean isAfterLast() {
            return this.mIndex >= this.mSize;
        }

        public boolean isBeforeFirst() {
            return this.mIndex < 0;
        }

        public boolean isLast() {
            return this.mIndex == this.mSize - 1;
        }

        public boolean moveToNext() {
            return this.moveToPosition(this.mIndex + 1);
        }

        public boolean moveToPrevious() {
            return this.moveToPosition(this.mIndex - 1);
        }

        public boolean moveToPosition(int n) {
            this.mIndex = n;
            int n2 = this.getPinnedBefore(n);
            int n3 = n - n2;
            if (n3 <= -1) {
                super.moveToPosition(-1);
            } else if (n3 >= this.mCursor.getCount()) {
                super.moveToPosition(this.mCursor.getCount());
            } else {
                super.moveToPosition(n3);
            }
            return !this.isBeforeFirst() && !this.isAfterLast();
        }

        public long getLong(int n) {
            PinnedSite pinnedSite;
            if (this.hasPinnedSites() && (pinnedSite = this.getPinnedSite(this.mIndex)) != null) {
                return 0L;
            }
            if (!super.isBeforeFirst() && !super.isAfterLast()) {
                return super.getLong(n);
            }
            return 0L;
        }

        public int getInt(int n) {
            PinnedSite pinnedSite;
            if (this.hasPinnedSites() && (pinnedSite = this.getPinnedSite(this.mIndex)) != null) {
                return 0;
            }
            if (!super.isBeforeFirst() && !super.isAfterLast()) {
                return super.getInt(n);
            }
            return 0;
        }

        public String getString(int n) {
            PinnedSite pinnedSite;
            if (this.hasPinnedSites() && (pinnedSite = this.getPinnedSite(this.mIndex)) != null) {
                if (n == this.mCursor.getColumnIndex("url")) {
                    return pinnedSite.url;
                }
                if (n == this.mCursor.getColumnIndex("title")) {
                    return pinnedSite.title;
                }
                return "";
            }
            if (!super.isBeforeFirst() && !super.isAfterLast()) {
                return super.getString(n);
            }
            return "";
        }

        public boolean move(int n) {
            return this.moveToPosition(this.mIndex + n);
        }

        public boolean moveToFirst() {
            return this.moveToPosition(0);
        }

        public boolean moveToLast() {
            return this.moveToPosition(this.mSize - 1);
        }
    }

    public static class PinnedSite {
        public String title = "";
        public String url = "";

        public PinnedSite(String string2, String string3) {
            this.title = string2;
            this.url = string3;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface BrowserDBIface {
        public void invalidateCachedState();

        @RobocopTarget
        public Cursor filter(ContentResolver var1, CharSequence var2, int var3);

        public Cursor getTopSites(ContentResolver var1, int var2);

        public void updateVisitedHistory(ContentResolver var1, String var2);

        public void updateHistoryTitle(ContentResolver var1, String var2, String var3);

        public void updateHistoryEntry(ContentResolver var1, String var2, String var3, long var4, int var6);

        @RobocopTarget
        public Cursor getAllVisitedHistory(ContentResolver var1);

        public Cursor getRecentHistory(ContentResolver var1, int var2);

        public void expireHistory(ContentResolver var1, BrowserContract.ExpirePriority var2);

        public void removeHistoryEntry(ContentResolver var1, int var2);

        @RobocopTarget
        public void removeHistoryEntry(ContentResolver var1, String var2);

        public void clearHistory(ContentResolver var1);

        @RobocopTarget
        public Cursor getBookmarksInFolder(ContentResolver var1, long var2);

        public boolean isVisited(ContentResolver var1, String var2);

        public int getReadingListCount(ContentResolver var1);

        @RobocopTarget
        public boolean isBookmark(ContentResolver var1, String var2);

        public boolean isReadingListItem(ContentResolver var1, String var2);

        public String getUrlForKeyword(ContentResolver var1, String var2);

        @RobocopTarget
        public void addBookmark(ContentResolver var1, String var2, String var3);

        public void removeBookmark(ContentResolver var1, int var2);

        @RobocopTarget
        public void removeBookmarksWithURL(ContentResolver var1, String var2);

        @RobocopTarget
        public void updateBookmark(ContentResolver var1, int var2, String var3, String var4, String var5);

        public void addReadingListItem(ContentResolver var1, String var2, String var3);

        public void removeReadingListItemWithURL(ContentResolver var1, String var2);

        public LoadFaviconResult getFaviconForUrl(ContentResolver var1, String var2);

        public String getFaviconUrlForHistoryUrl(ContentResolver var1, String var2);

        public void updateFaviconForUrl(ContentResolver var1, String var2, byte[] var3, String var4);

        public void updateThumbnailForUrl(ContentResolver var1, String var2, BitmapDrawable var3);

        @RobocopTarget
        public byte[] getThumbnailForUrl(ContentResolver var1, String var2);

        public Cursor getThumbnailsForUrls(ContentResolver var1, List<String> var2);

        @RobocopTarget
        public void removeThumbnails(ContentResolver var1);

        public void registerBookmarkObserver(ContentResolver var1, ContentObserver var2);

        public void registerHistoryObserver(ContentResolver var1, ContentObserver var2);

        public int getCount(ContentResolver var1, String var2);

        public void pinSite(ContentResolver var1, String var2, String var3, int var4);

        public void unpinSite(ContentResolver var1, int var2);

        public void unpinAllSites(ContentResolver var1);

        public Cursor getPinnedSites(ContentResolver var1, int var2);

        @RobocopTarget
        public Cursor getBookmarkForUrl(ContentResolver var1, String var2);
    }

    public static interface URLColumns {
        public static final String URL = "url";
        public static final String TITLE = "title";
        public static final String FAVICON = "favicon";
        public static final String THUMBNAIL = "thumbnail";
        public static final String DATE_LAST_VISITED = "date-last-visited";
        public static final String VISITS = "visits";
        public static final String KEYWORD = "keyword";
    }
}

