/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.activities;

import android.accounts.Account;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;
import android.widget.ViewFlipper;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.fxa.FxAccountConstants;
import org.mozilla.gecko.fxa.activities.FxAccountAbstractActivity;
import org.mozilla.gecko.fxa.activities.FxAccountGetStartedActivity;
import org.mozilla.gecko.fxa.activities.FxAccountUpdateCredentialsActivity;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.fxa.authenticator.FxAccountAuthenticator;
import org.mozilla.gecko.fxa.login.Married;
import org.mozilla.gecko.fxa.login.State;

public class FxAccountStatusActivity
extends FxAccountAbstractActivity {
    protected static final String LOG_TAG = FxAccountStatusActivity.class.getSimpleName();
    protected ViewFlipper connectionStatusViewFlipper;
    protected View connectionStatusUnverifiedView;
    protected View connectionStatusSignInView;
    protected View connectionStatusSyncingView;
    protected TextView emailTextView;

    public FxAccountStatusActivity() {
        super(2);
    }

    public void onCreate(Bundle bundle) {
        Logger.setThreadLogTag("FxAccounts");
        Logger.debug(LOG_TAG, "onCreate(" + bundle + ")");
        super.onCreate(bundle);
        this.setContentView(R.layout.fxaccount_status);
        this.connectionStatusViewFlipper = (ViewFlipper)this.ensureFindViewById(null, R.id.connection_status_view, "connection status frame layout");
        this.connectionStatusUnverifiedView = this.ensureFindViewById(null, R.id.unverified_view, "unverified vie w");
        this.connectionStatusSignInView = this.ensureFindViewById(null, R.id.sign_in_view, "sign in view");
        this.connectionStatusSyncingView = this.ensureFindViewById(null, R.id.syncing_view, "syncing view");
        this.launchActivityOnClick(this.connectionStatusSignInView, FxAccountUpdateCredentialsActivity.class);
        this.emailTextView = (TextView)this.findViewById(R.id.email);
        if (FxAccountConstants.LOG_PERSONAL_INFORMATION) {
            this.createDebugButtons();
        }
    }

    protected void createDebugButtons() {
        if (!FxAccountConstants.LOG_PERSONAL_INFORMATION) {
            return;
        }
        this.findViewById(R.id.debug_buttons).setVisibility(0);
        this.findViewById(R.id.debug_refresh_button).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Logger.info(LOG_TAG, "Refreshing.");
                FxAccountStatusActivity.this.refresh();
            }
        });
        this.findViewById(R.id.debug_dump_button).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Logger.info(LOG_TAG, "Dumping account details.");
                Account[] accountArray = FxAccountAuthenticator.getFirefoxAccounts((Context)FxAccountStatusActivity.this);
                if (accountArray.length < 1) {
                    return;
                }
                AndroidFxAccount androidFxAccount = new AndroidFxAccount((Context)FxAccountStatusActivity.this, accountArray[0]);
                androidFxAccount.dump();
            }
        });
        this.findViewById(R.id.debug_sync_button).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Logger.info(LOG_TAG, "Syncing.");
                Account[] accountArray = FxAccountAuthenticator.getFirefoxAccounts((Context)FxAccountStatusActivity.this);
                if (accountArray.length < 1) {
                    return;
                }
                Bundle bundle = new Bundle();
                bundle.putBoolean("force", true);
                ContentResolver.requestSync((Account)accountArray[0], (String)"org.mozilla.fennec.db.browser", (Bundle)bundle);
            }
        });
        this.findViewById(R.id.debug_forget_certificate_button).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Account[] accountArray = FxAccountAuthenticator.getFirefoxAccounts((Context)FxAccountStatusActivity.this);
                if (accountArray.length < 1) {
                    return;
                }
                AndroidFxAccount androidFxAccount = new AndroidFxAccount((Context)FxAccountStatusActivity.this, accountArray[0]);
                State state = androidFxAccount.getState();
                try {
                    Married married = (Married)state;
                    Logger.info(LOG_TAG, "Moving to Cohabiting state: Forgetting certificate.");
                    androidFxAccount.setState(married.makeCohabitingState());
                    FxAccountStatusActivity.this.refresh();
                }
                catch (ClassCastException classCastException) {
                    Logger.info(LOG_TAG, "Not in Married state; can't forget certificate.");
                }
            }
        });
        this.findViewById(R.id.debug_require_password_button).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Logger.info(LOG_TAG, "Moving to Separated state: Forgetting password.");
                Account[] accountArray = FxAccountAuthenticator.getFirefoxAccounts((Context)FxAccountStatusActivity.this);
                if (accountArray.length < 1) {
                    return;
                }
                AndroidFxAccount androidFxAccount = new AndroidFxAccount((Context)FxAccountStatusActivity.this, accountArray[0]);
                State state = androidFxAccount.getState();
                androidFxAccount.setState(state.makeSeparatedState());
                FxAccountStatusActivity.this.refresh();
            }
        });
        this.findViewById(R.id.debug_require_upgrade_button).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Logger.info(LOG_TAG, "Moving to Doghouse state: Requiring upgrade.");
                Account[] accountArray = FxAccountAuthenticator.getFirefoxAccounts((Context)FxAccountStatusActivity.this);
                if (accountArray.length < 1) {
                    return;
                }
                AndroidFxAccount androidFxAccount = new AndroidFxAccount((Context)FxAccountStatusActivity.this, accountArray[0]);
                State state = androidFxAccount.getState();
                androidFxAccount.setState(state.makeDoghouseState());
                FxAccountStatusActivity.this.refresh();
            }
        });
    }

    public void onResume() {
        super.onResume();
        this.refresh();
    }

    protected void showNeedsUpgrade() {
        this.connectionStatusViewFlipper.setDisplayedChild(0);
    }

    protected void showNeedsPassword() {
        this.connectionStatusViewFlipper.setDisplayedChild(1);
    }

    protected void showNeedsVerification() {
        this.connectionStatusViewFlipper.setDisplayedChild(2);
    }

    protected void showConnected() {
        this.connectionStatusViewFlipper.setDisplayedChild(3);
    }

    protected void refresh(Account account) {
        if (account == null) {
            this.redirectToActivity(FxAccountGetStartedActivity.class);
            return;
        }
        this.emailTextView.setText((CharSequence)account.name);
        AndroidFxAccount androidFxAccount = new AndroidFxAccount((Context)this, account);
        State state = androidFxAccount.getState();
        switch (state.getNeededAction()) {
            case NeedsUpgrade: {
                this.showNeedsUpgrade();
                break;
            }
            case NeedsPassword: {
                this.showNeedsPassword();
                break;
            }
            case NeedsVerification: {
                this.showNeedsVerification();
                break;
            }
            default: {
                this.showConnected();
            }
        }
    }

    protected void refresh() {
        Account[] accountArray = FxAccountAuthenticator.getFirefoxAccounts((Context)this);
        if (accountArray.length < 1) {
            this.refresh(null);
            return;
        }
        this.refresh(accountArray[0]);
    }
}

