/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.login;

import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import org.mozilla.gecko.browserid.RSACryptoImplementation;
import org.mozilla.gecko.fxa.login.Cohabiting;
import org.mozilla.gecko.fxa.login.Doghouse;
import org.mozilla.gecko.fxa.login.Engaged;
import org.mozilla.gecko.fxa.login.Married;
import org.mozilla.gecko.fxa.login.Promised;
import org.mozilla.gecko.fxa.login.Separated;
import org.mozilla.gecko.fxa.login.State;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.NonObjectJSONException;
import org.mozilla.gecko.sync.Utils;

public class StateFactory {
    public static State fromJSONObject(State.StateLabel stateLabel, ExtendedJSONObject extendedJSONObject) throws InvalidKeySpecException, NoSuchAlgorithmException, NonObjectJSONException {
        Long l = extendedJSONObject.getLong("version");
        if (l == null || l.intValue() != 1) {
            throw new IllegalStateException("version must be 1");
        }
        switch (stateLabel) {
            case Promised: {
                return new Promised(extendedJSONObject.getString("email"), extendedJSONObject.getString("uid"), extendedJSONObject.getBoolean("verified"), Utils.hex2Byte(extendedJSONObject.getString("unwrapkB")), Utils.hex2Byte(extendedJSONObject.getString("quickStretchedPW")));
            }
            case Engaged: {
                return new Engaged(extendedJSONObject.getString("email"), extendedJSONObject.getString("uid"), extendedJSONObject.getBoolean("verified"), Utils.hex2Byte(extendedJSONObject.getString("unwrapkB")), Utils.hex2Byte(extendedJSONObject.getString("sessionToken")), Utils.hex2Byte(extendedJSONObject.getString("keyFetchToken")));
            }
            case Cohabiting: {
                return new Cohabiting(extendedJSONObject.getString("email"), extendedJSONObject.getString("uid"), Utils.hex2Byte(extendedJSONObject.getString("sessionToken")), Utils.hex2Byte(extendedJSONObject.getString("kA")), Utils.hex2Byte(extendedJSONObject.getString("kB")), RSACryptoImplementation.fromJSONObject(extendedJSONObject.getObject("keyPair")));
            }
            case Married: {
                return new Married(extendedJSONObject.getString("email"), extendedJSONObject.getString("uid"), Utils.hex2Byte(extendedJSONObject.getString("sessionToken")), Utils.hex2Byte(extendedJSONObject.getString("kA")), Utils.hex2Byte(extendedJSONObject.getString("kB")), RSACryptoImplementation.fromJSONObject(extendedJSONObject.getObject("keyPair")), extendedJSONObject.getString("certificate"));
            }
            case Separated: {
                return new Separated(extendedJSONObject.getString("email"), extendedJSONObject.getString("uid"), extendedJSONObject.getBoolean("verified"));
            }
            case Doghouse: {
                return new Doghouse(extendedJSONObject.getString("email"), extendedJSONObject.getString("uid"), extendedJSONObject.getBoolean("verified"));
            }
        }
        throw new IllegalStateException("unrecognized state label: " + (Object)((Object)stateLabel));
    }
}

