/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.util.Log;
import android.util.SparseArray;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.ThreadUtils;

public class PanelManager
implements GeckoEventListener {
    private static final String LOGTAG = "GeckoPanelManager";
    private static AtomicInteger sRequestId = new AtomicInteger(0);
    private static final SparseArray<RequestCallback> sCallbacks = new SparseArray();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestAvailablePanels(RequestCallback requestCallback) {
        int n = sRequestId.getAndIncrement();
        SparseArray<RequestCallback> sparseArray = sCallbacks;
        synchronized (sparseArray) {
            if (sCallbacks.size() == 0) {
                GeckoAppShell.getEventDispatcher().registerEventListener("HomePanels:Data", (GeckoEventListener)this);
            }
            sCallbacks.put(n, (Object)requestCallback);
        }
        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("HomePanels:Get", Integer.toString(n)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(String string2, JSONObject jSONObject) {
        final ArrayList<PanelInfo> arrayList = new ArrayList<PanelInfo>();
        try {
            RequestCallback requestCallback;
            JSONArray jSONArray = jSONObject.getJSONArray("panels");
            int n = jSONArray.length();
            for (int i = 0; i < n; ++i) {
                PanelInfo panelInfo = this.getPanelInfoFromJSON(jSONArray.getJSONObject(i));
                arrayList.add(panelInfo);
            }
            int n2 = jSONObject.getInt("requestId");
            SparseArray<RequestCallback> sparseArray = sCallbacks;
            synchronized (sparseArray) {
                requestCallback = (RequestCallback)sCallbacks.get(n2);
                sCallbacks.delete(n2);
                if (sCallbacks.size() == 0) {
                    GeckoAppShell.getEventDispatcher().unregisterEventListener("HomePanels:Data", (GeckoEventListener)this);
                }
            }
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                public void run() {
                    requestCallback.onComplete(arrayList);
                }
            });
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)("Exception handling " + string2 + " message"), (Throwable)jSONException);
        }
    }

    private PanelInfo getPanelInfoFromJSON(JSONObject jSONObject) throws JSONException {
        String string2 = jSONObject.getString("id");
        String string3 = jSONObject.getString("title");
        String string4 = jSONObject.getString("layout");
        JSONArray jSONArray = jSONObject.getJSONArray("views");
        return new PanelInfo(string2, string3, string4, jSONArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface RequestCallback {
        public void onComplete(List<PanelInfo> var1);
    }

    public class PanelInfo {
        public final String id;
        public final String title;
        public final String layout;
        public final JSONArray views;

        public PanelInfo(String string2, String string3, String string4, JSONArray jSONArray) {
            this.id = string2;
            this.title = string3;
            this.layout = string4;
            this.views = jSONArray;
        }
    }
}

