/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.simple.parser.ParseException;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.CryptoRecord;
import org.mozilla.gecko.sync.EngineSettings;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.MetaGlobalException;
import org.mozilla.gecko.sync.NonObjectJSONException;
import org.mozilla.gecko.sync.delegates.MetaGlobalDelegate;
import org.mozilla.gecko.sync.net.AuthHeaderProvider;
import org.mozilla.gecko.sync.net.SyncStorageRecordRequest;
import org.mozilla.gecko.sync.net.SyncStorageRequestDelegate;
import org.mozilla.gecko.sync.net.SyncStorageResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaGlobal
implements SyncStorageRequestDelegate {
    private static final String LOG_TAG = "MetaGlobal";
    protected String metaURL;
    protected ExtendedJSONObject engines;
    protected Long storageVersion;
    protected String syncID;
    protected Map<String, String> syncIDs;
    protected Map<String, Integer> versions;
    protected Map<String, MetaGlobalException> exceptions;
    private MetaGlobalDelegate callback;
    private boolean isUploading;
    protected final AuthHeaderProvider authHeaderProvider;

    public MetaGlobal(String string2, AuthHeaderProvider authHeaderProvider) {
        this.metaURL = string2;
        this.authHeaderProvider = authHeaderProvider;
    }

    public void fetch(MetaGlobalDelegate metaGlobalDelegate) {
        this.callback = metaGlobalDelegate;
        try {
            this.isUploading = false;
            SyncStorageRecordRequest syncStorageRecordRequest = new SyncStorageRecordRequest(this.metaURL);
            syncStorageRecordRequest.delegate = this;
            syncStorageRecordRequest.deferGet();
        }
        catch (URISyntaxException uRISyntaxException) {
            this.callback.handleError(uRISyntaxException);
        }
    }

    public void upload(MetaGlobalDelegate metaGlobalDelegate) {
        try {
            this.isUploading = true;
            SyncStorageRecordRequest syncStorageRecordRequest = new SyncStorageRecordRequest(this.metaURL);
            syncStorageRecordRequest.delegate = this;
            this.callback = metaGlobalDelegate;
            syncStorageRecordRequest.put(this.asCryptoRecord());
        }
        catch (Exception exception) {
            metaGlobalDelegate.handleError(exception);
        }
    }

    protected ExtendedJSONObject asRecordContents() {
        ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
        extendedJSONObject.put("storageVersion", this.storageVersion);
        extendedJSONObject.put("engines", this.engines);
        extendedJSONObject.put("syncID", this.syncID);
        return extendedJSONObject;
    }

    public CryptoRecord asCryptoRecord() {
        ExtendedJSONObject extendedJSONObject = this.asRecordContents();
        CryptoRecord cryptoRecord = new CryptoRecord(extendedJSONObject);
        cryptoRecord.collection = "meta";
        cryptoRecord.guid = "global";
        cryptoRecord.deleted = false;
        return cryptoRecord;
    }

    public void setFromRecord(CryptoRecord cryptoRecord) throws IllegalStateException, IOException, ParseException, NonObjectJSONException {
        if (cryptoRecord == null) {
            throw new IllegalArgumentException("Cannot set meta/global from null record");
        }
        Logger.debug(LOG_TAG, "meta/global is " + cryptoRecord.payload.toJSONString());
        this.storageVersion = (Long)cryptoRecord.payload.get("storageVersion");
        this.syncID = (String)cryptoRecord.payload.get("syncID");
        this.setEngines(cryptoRecord.payload.getObject("engines"));
    }

    public Long getStorageVersion() {
        return this.storageVersion;
    }

    public void setStorageVersion(Long l) {
        this.storageVersion = l;
    }

    public ExtendedJSONObject getEngines() {
        return this.engines;
    }

    public void setEngines(ExtendedJSONObject extendedJSONObject) {
        if (extendedJSONObject == null) {
            extendedJSONObject = new ExtendedJSONObject();
        }
        this.engines = extendedJSONObject;
        int n = extendedJSONObject.size();
        this.versions = new HashMap<String, Integer>(n);
        this.syncIDs = new HashMap<String, String>(n);
        this.exceptions = new HashMap<String, MetaGlobalException>(n);
        for (String string2 : extendedJSONObject.keySet()) {
            try {
                ExtendedJSONObject extendedJSONObject2 = extendedJSONObject.getObject(string2);
                this.recordEngineState(string2, extendedJSONObject2);
            }
            catch (NonObjectJSONException nonObjectJSONException) {
                Logger.error(LOG_TAG, "Engine field for " + string2 + " in meta/global is not an object.");
                this.recordEngineState(string2, new ExtendedJSONObject());
            }
        }
    }

    protected void recordEngineState(String string2, ExtendedJSONObject extendedJSONObject) {
        Object object;
        if (extendedJSONObject == null) {
            throw new IllegalArgumentException("engineEntry cannot be null.");
        }
        try {
            object = extendedJSONObject.getString("syncID");
            if (object == null) {
                Logger.warn(LOG_TAG, "No syncID for " + string2 + ". Recording exception.");
                this.exceptions.put(string2, new MetaGlobalException.MetaGlobalMalformedSyncIDException());
            }
            this.syncIDs.put(string2, (String)object);
        }
        catch (ClassCastException classCastException) {
            Logger.warn(LOG_TAG, "Malformed syncID " + extendedJSONObject.get("syncID") + " for " + string2 + ". Recording exception.");
            this.exceptions.put(string2, new MetaGlobalException.MetaGlobalMalformedSyncIDException());
        }
        try {
            object = extendedJSONObject.getIntegerSafely("version");
            Logger.trace(LOG_TAG, "Engine " + string2 + " has server version " + object);
            if (object == null || (Integer)object == 0) {
                Logger.warn(LOG_TAG, "Malformed version " + object + " for " + string2 + ". Recording exception.");
                this.exceptions.put(string2, new MetaGlobalException.MetaGlobalMalformedVersionException());
                return;
            }
            this.versions.put(string2, (Integer)object);
        }
        catch (NumberFormatException numberFormatException) {
            Logger.warn(LOG_TAG, "Malformed version " + extendedJSONObject.get("version") + " for " + string2 + ". Recording exception.");
            this.exceptions.put(string2, new MetaGlobalException.MetaGlobalMalformedVersionException());
            return;
        }
    }

    public Set<String> getEnabledEngineNames() {
        if (this.engines == null) {
            return null;
        }
        return new HashSet<String>(this.engines.keySet());
    }

    public void verifyEngineSettings(String string2, EngineSettings engineSettings) throws MetaGlobalException {
        if (this.syncIDs == null) {
            throw new IllegalStateException("No meta/global record yet processed.");
        }
        if (engineSettings == null) {
            throw new IllegalArgumentException("engineSettings cannot be null.");
        }
        MetaGlobalException metaGlobalException = this.exceptions.get(string2);
        if (metaGlobalException != null) {
            throw metaGlobalException;
        }
        String string3 = this.syncIDs.get(string2);
        if (string3 == null) {
            throw new IllegalArgumentException("Unknown engine " + string2);
        }
        Integer n = this.versions.get(string2);
        if (n > engineSettings.version) {
            throw new MetaGlobalException.MetaGlobalStaleClientVersionException(n);
        }
        if (!string3.equals(engineSettings.syncID)) {
            throw new MetaGlobalException.MetaGlobalStaleClientSyncIDException(string3);
        }
    }

    public String getSyncID() {
        return this.syncID;
    }

    public void setSyncID(String string2) {
        this.syncID = string2;
    }

    public String credentials() {
        return null;
    }

    @Override
    public AuthHeaderProvider getAuthHeaderProvider() {
        return this.authHeaderProvider;
    }

    @Override
    public String ifUnmodifiedSince() {
        return null;
    }

    @Override
    public void handleRequestSuccess(SyncStorageResponse syncStorageResponse) {
        if (this.isUploading) {
            this.handleUploadSuccess(syncStorageResponse);
        } else {
            this.handleDownloadSuccess(syncStorageResponse);
        }
    }

    private void handleUploadSuccess(SyncStorageResponse syncStorageResponse) {
        this.callback.handleSuccess(this, syncStorageResponse);
    }

    private void handleDownloadSuccess(SyncStorageResponse syncStorageResponse) {
        if (syncStorageResponse.wasSuccessful()) {
            try {
                CryptoRecord cryptoRecord = CryptoRecord.fromJSONRecord(syncStorageResponse.jsonObjectBody());
                this.setFromRecord(cryptoRecord);
                this.callback.handleSuccess(this, syncStorageResponse);
            }
            catch (Exception exception) {
                this.callback.handleError(exception);
            }
            return;
        }
        this.callback.handleFailure(syncStorageResponse);
    }

    @Override
    public void handleRequestFailure(SyncStorageResponse syncStorageResponse) {
        if (syncStorageResponse.getStatusCode() == 404) {
            this.callback.handleMissing(this, syncStorageResponse);
            return;
        }
        this.callback.handleFailure(syncStorageResponse);
    }

    @Override
    public void handleRequestError(Exception exception) {
        this.callback.handleError(exception);
    }
}

