/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.config;

import java.net.URI;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.net.AuthHeaderProvider;
import org.mozilla.gecko.sync.net.BaseResource;
import org.mozilla.gecko.sync.net.SyncStorageRecordRequest;
import org.mozilla.gecko.sync.net.SyncStorageRequestDelegate;
import org.mozilla.gecko.sync.net.SyncStorageResponse;

public class ClientRecordTerminator {
    public static final String LOG_TAG = "ClientRecTerminator";

    protected ClientRecordTerminator() {
    }

    public static void deleteClientRecord(String string2, String string3, final String string4, final AuthHeaderProvider authHeaderProvider) throws Exception {
        URI uRI = new URI(string3 + "1.1" + "/" + string2 + "/storage/" + "clients" + "/" + string4);
        SyncStorageRecordRequest syncStorageRecordRequest = new SyncStorageRecordRequest(uRI);
        syncStorageRecordRequest.delegate = new SyncStorageRequestDelegate(){

            public AuthHeaderProvider getAuthHeaderProvider() {
                return authHeaderProvider;
            }

            public String ifUnmodifiedSince() {
                return null;
            }

            public void handleRequestSuccess(SyncStorageResponse syncStorageResponse) {
                Logger.info(ClientRecordTerminator.LOG_TAG, "Deleted client record with GUID " + string4 + " from server.");
                BaseResource.consumeEntity(syncStorageResponse);
            }

            public void handleRequestFailure(SyncStorageResponse syncStorageResponse) {
                Logger.warn(ClientRecordTerminator.LOG_TAG, "Failed to delete client record with GUID " + string4 + " from server.");
                try {
                    Logger.warn(ClientRecordTerminator.LOG_TAG, "Server error message was: " + syncStorageResponse.getErrorMessage());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BaseResource.consumeEntity(syncStorageResponse);
            }

            public void handleRequestError(Exception exception) {
                Logger.error(ClientRecordTerminator.LOG_TAG, "Got exception trying to delete client record with GUID " + string4 + " from server; ignoring.", exception);
            }
        };
        syncStorageRecordRequest.delete();
    }
}

