/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.common.log.writers;

import android.util.Log;
import java.util.IdentityHashMap;
import java.util.Map;
import org.mozilla.gecko.background.common.log.writers.LogWriter;

public class AndroidLevelCachingLogWriter
extends LogWriter {
    protected final LogWriter inner;
    private Map<String, Boolean> isErrorLoggable = new IdentityHashMap<String, Boolean>();
    private Map<String, Boolean> isWarnLoggable = new IdentityHashMap<String, Boolean>();
    private Map<String, Boolean> isInfoLoggable = new IdentityHashMap<String, Boolean>();
    private Map<String, Boolean> isDebugLoggable = new IdentityHashMap<String, Boolean>();
    private Map<String, Boolean> isVerboseLoggable = new IdentityHashMap<String, Boolean>();

    public AndroidLevelCachingLogWriter(LogWriter logWriter) {
        this.inner = logWriter;
    }

    public void refreshLogLevels() {
        this.isErrorLoggable = new IdentityHashMap<String, Boolean>();
        this.isWarnLoggable = new IdentityHashMap<String, Boolean>();
        this.isInfoLoggable = new IdentityHashMap<String, Boolean>();
        this.isDebugLoggable = new IdentityHashMap<String, Boolean>();
        this.isVerboseLoggable = new IdentityHashMap<String, Boolean>();
    }

    private boolean shouldLogError(String string2) {
        Boolean bl = this.isErrorLoggable.get(string2);
        if (bl != null) {
            return bl;
        }
        bl = Log.isLoggable((String)string2, (int)6);
        this.isErrorLoggable.put(string2, bl);
        return bl;
    }

    private boolean shouldLogWarn(String string2) {
        Boolean bl = this.isWarnLoggable.get(string2);
        if (bl != null) {
            return bl;
        }
        bl = Log.isLoggable((String)string2, (int)5);
        this.isWarnLoggable.put(string2, bl);
        return bl;
    }

    private boolean shouldLogInfo(String string2) {
        Boolean bl = this.isInfoLoggable.get(string2);
        if (bl != null) {
            return bl;
        }
        bl = Log.isLoggable((String)string2, (int)4);
        this.isInfoLoggable.put(string2, bl);
        return bl;
    }

    private boolean shouldLogDebug(String string2) {
        Boolean bl = this.isDebugLoggable.get(string2);
        if (bl != null) {
            return bl;
        }
        bl = Log.isLoggable((String)string2, (int)3);
        this.isDebugLoggable.put(string2, bl);
        return bl;
    }

    public boolean shouldLogVerbose(String string2) {
        Boolean bl = this.isVerboseLoggable.get(string2);
        if (bl != null) {
            return bl;
        }
        bl = Log.isLoggable((String)string2, (int)2);
        this.isVerboseLoggable.put(string2, bl);
        return bl;
    }

    public void error(String string2, String string3, Throwable throwable) {
        if (this.shouldLogError(string2)) {
            this.inner.error(string2, string3, throwable);
        }
    }

    public void warn(String string2, String string3, Throwable throwable) {
        if (this.shouldLogWarn(string2)) {
            this.inner.warn(string2, string3, throwable);
        }
    }

    public void info(String string2, String string3, Throwable throwable) {
        if (this.shouldLogInfo(string2)) {
            this.inner.info(string2, string3, throwable);
        }
    }

    public void debug(String string2, String string3, Throwable throwable) {
        if (this.shouldLogDebug(string2)) {
            this.inner.debug(string2, string3, throwable);
        }
    }

    public void trace(String string2, String string3, Throwable throwable) {
        if (this.shouldLogVerbose(string2)) {
            this.inner.trace(string2, string3, throwable);
        }
    }

    public void close() {
        this.inner.close();
    }
}

