/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.activities;

import android.accounts.Account;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.SystemClock;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import ch.boye.httpclientandroidlib.HttpResponse;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountAgeLockoutHelper;
import org.mozilla.gecko.background.fxa.FxAccountClient10;
import org.mozilla.gecko.background.fxa.FxAccountClient20;
import org.mozilla.gecko.fxa.FxAccountConstants;
import org.mozilla.gecko.fxa.activities.FxAccountAbstractSetupActivity;
import org.mozilla.gecko.fxa.activities.FxAccountConfirmAccountActivity;
import org.mozilla.gecko.fxa.activities.FxAccountCreateAccountNotAllowedActivity;
import org.mozilla.gecko.fxa.activities.FxAccountSetupTask;
import org.mozilla.gecko.fxa.activities.FxAccountSignInActivity;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.sync.HTTPFailureException;
import org.mozilla.gecko.sync.net.SyncStorageResponse;

public class FxAccountCreateAccountActivity
extends FxAccountAbstractSetupActivity {
    protected static final String LOG_TAG = FxAccountCreateAccountActivity.class.getSimpleName();
    private static final int CHILD_REQUEST_CODE = 2;
    protected String[] yearItems;
    protected EditText yearEdit;

    public void onCreate(Bundle bundle) {
        Logger.debug(LOG_TAG, "onCreate(" + bundle + ")");
        super.onCreate(bundle);
        this.setContentView(R.layout.fxaccount_create_account);
        this.linkifyTextViews(null, new int[]{R.id.policy});
        this.localErrorTextView = (TextView)this.ensureFindViewById(null, R.id.local_error, "local error text view");
        this.emailEdit = (EditText)this.ensureFindViewById(null, R.id.email, "email edit");
        this.passwordEdit = (EditText)this.ensureFindViewById(null, R.id.password, "password edit");
        this.showPasswordButton = (Button)this.ensureFindViewById(null, R.id.show_password, "show password button");
        this.yearEdit = (EditText)this.ensureFindViewById(null, R.id.year_edit, "year edit");
        this.button = (Button)this.ensureFindViewById(null, R.id.create_account_button, "create account button");
        this.createCreateAccountButton();
        this.createYearEdit();
        this.addListeners();
        this.updateButtonState();
        this.createShowPasswordButton();
        View view = this.ensureFindViewById(null, R.id.sign_in_instead_link, "sign in instead link");
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent intent = new Intent((Context)FxAccountCreateAccountActivity.this, FxAccountSignInActivity.class);
                intent.putExtra("email", FxAccountCreateAccountActivity.this.emailEdit.getText().toString());
                intent.putExtra("password", FxAccountCreateAccountActivity.this.passwordEdit.getText().toString());
                intent.setFlags(65536);
                FxAccountCreateAccountActivity.this.startActivityForResult(intent, 2);
            }
        });
        if (this.getIntent() != null && this.getIntent().getExtras() != null) {
            Bundle bundle2 = this.getIntent().getExtras();
            this.emailEdit.setText((CharSequence)bundle2.getString("email"));
            this.passwordEdit.setText((CharSequence)bundle2.getString("password"));
        }
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        Logger.debug(LOG_TAG, "onActivityResult: " + n);
        if (n != 2 || n2 != -1) {
            super.onActivityResult(n, n2, intent);
            return;
        }
        this.setResult(n2, intent);
        this.finish();
    }

    protected void createYearEdit() {
        this.yearItems = this.getResources().getStringArray(R.array.fxaccount_create_account_ages_array);
        this.yearEdit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                DialogInterface.OnClickListener onClickListener = new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n) {
                        FxAccountCreateAccountActivity.this.yearEdit.setText((CharSequence)FxAccountCreateAccountActivity.this.yearItems[n]);
                        FxAccountCreateAccountActivity.this.updateButtonState();
                    }
                };
                AlertDialog alertDialog = new AlertDialog.Builder((Context)FxAccountCreateAccountActivity.this).setTitle(R.string.fxaccount_when_were_you_born).setItems((CharSequence[])FxAccountCreateAccountActivity.this.yearItems, onClickListener).setIcon(R.drawable.fxaccount_icon).create();
                alertDialog.show();
            }
        });
    }

    public void createAccount(String string2, String string3) {
        String string4 = "https://api-accounts-onepw.dev.lcip.org";
        CreateAccountDelegate createAccountDelegate = new CreateAccountDelegate(string2, string3, string4);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        FxAccountClient20 fxAccountClient20 = new FxAccountClient20(string4, executorService);
        try {
            new FxAccountSetupTask.FxAccountCreateAccountTask((Context)this, string2, string3, fxAccountClient20, createAccountDelegate).execute(new Void[0]);
        }
        catch (Exception exception) {
            this.showRemoteError(exception);
        }
    }

    protected boolean shouldButtonBeEnabled() {
        return super.shouldButtonBeEnabled() && this.yearEdit.length() > 0;
    }

    protected void createCreateAccountButton() {
        this.button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (!FxAccountCreateAccountActivity.this.updateButtonState()) {
                    return;
                }
                String string2 = FxAccountCreateAccountActivity.this.emailEdit.getText().toString();
                String string3 = FxAccountCreateAccountActivity.this.passwordEdit.getText().toString();
                if (FxAccountAgeLockoutHelper.passesAgeCheck(FxAccountCreateAccountActivity.this.yearEdit.getText().toString(), FxAccountCreateAccountActivity.this.yearItems)) {
                    FxAccountConstants.pii(LOG_TAG, "Passed age check.");
                    FxAccountCreateAccountActivity.this.createAccount(string2, string3);
                } else {
                    FxAccountConstants.pii(LOG_TAG, "Failed age check!");
                    FxAccountAgeLockoutHelper.lockOut(SystemClock.elapsedRealtime());
                    FxAccountCreateAccountActivity.this.setResult(0);
                    FxAccountCreateAccountActivity.this.redirectToActivity(FxAccountCreateAccountNotAllowedActivity.class);
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CreateAccountDelegate
    implements FxAccountClient10.RequestDelegate<String> {
        public final String email;
        public final String password;
        public final String serverURI;

        public CreateAccountDelegate(String string2, String string3, String string4) {
            this.email = string2;
            this.password = string3;
            this.serverURI = string4;
        }

        @Override
        public void handleError(Exception exception) {
            FxAccountCreateAccountActivity.this.showRemoteError(exception);
        }

        @Override
        public void handleFailure(int n, HttpResponse httpResponse) {
            this.handleError(new HTTPFailureException(new SyncStorageResponse(httpResponse)));
        }

        @Override
        public void handleSuccess(String string2) {
            Account account;
            String string3;
            FxAccountCreateAccountActivity fxAccountCreateAccountActivity = FxAccountCreateAccountActivity.this;
            Logger.info(LOG_TAG, "Got success creating account.");
            try {
                string3 = FxAccountConstants.DEFAULT_TOKEN_SERVER_URI;
                account = AndroidFxAccount.addAndroidAccount((Context)fxAccountCreateAccountActivity, this.email, this.password, "default", this.serverURI, string3, null, null, false);
                if (account == null) {
                    throw new RuntimeException("XXX what?");
                }
            }
            catch (Exception exception) {
                this.handleError(exception);
                return;
            }
            if (FxAccountConstants.LOG_PERSONAL_INFORMATION) {
                new AndroidFxAccount((Context)fxAccountCreateAccountActivity, account).dump();
            }
            Intent intent = new Intent();
            intent.putExtra("authAccount", this.email);
            intent.putExtra("accountType", "org.mozilla.fennec_account");
            FxAccountCreateAccountActivity.this.setResult(-1, intent);
            FxAccountCreateAccountActivity.this.finish();
            string3 = new Intent((Context)FxAccountCreateAccountActivity.this, FxAccountConfirmAccountActivity.class);
            string3.putExtra("email", this.email);
            string3.setFlags(65536);
            FxAccountCreateAccountActivity.this.startActivity((Intent)string3);
        }
    }
}

