/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.activities;

import android.accounts.Account;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import ch.boye.httpclientandroidlib.HttpResponse;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountClient10;
import org.mozilla.gecko.background.fxa.FxAccountClient20;
import org.mozilla.gecko.background.fxa.FxAccountUtils;
import org.mozilla.gecko.fxa.FxAccountConstants;
import org.mozilla.gecko.fxa.activities.FxAccountAbstractSetupActivity;
import org.mozilla.gecko.fxa.activities.FxAccountSetupTask;
import org.mozilla.gecko.fxa.activities.FxAccountStatusActivity;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.fxa.authenticator.FxAccountAuthenticator;
import org.mozilla.gecko.sync.HTTPFailureException;
import org.mozilla.gecko.sync.net.SyncStorageResponse;

public class FxAccountUpdateCredentialsActivity
extends FxAccountAbstractSetupActivity {
    protected static final String LOG_TAG = FxAccountUpdateCredentialsActivity.class.getSimpleName();
    protected Account account;

    public FxAccountUpdateCredentialsActivity() {
        super(2);
    }

    public void onCreate(Bundle bundle) {
        Logger.debug(LOG_TAG, "onCreate(" + bundle + ")");
        super.onCreate(bundle);
        this.setContentView(R.layout.fxaccount_update_credentials);
        this.localErrorTextView = (TextView)this.ensureFindViewById(null, R.id.local_error, "local error text view");
        this.emailEdit = (EditText)this.ensureFindViewById(null, R.id.email, "email edit");
        this.passwordEdit = (EditText)this.ensureFindViewById(null, R.id.password, "password edit");
        this.showPasswordButton = (Button)this.ensureFindViewById(null, R.id.show_password, "show password button");
        this.button = (Button)this.ensureFindViewById(null, R.id.button, "update credentials");
        this.minimumPasswordLength = 1;
        this.createButton();
        this.addListeners();
        this.updateButtonState();
        this.createShowPasswordButton();
        this.emailEdit.setEnabled(false);
    }

    public void onResume() {
        super.onResume();
        Account[] accountArray = FxAccountAuthenticator.getFirefoxAccounts((Context)this);
        this.account = accountArray[0];
        if (this.account == null) {
            this.setResult(0);
            this.finish();
            return;
        }
        this.emailEdit.setText((CharSequence)this.account.name);
    }

    public void updateCredentials(String string2, String string3) {
        String string4 = "https://api-accounts-onepw.dev.lcip.org";
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        FxAccountClient20 fxAccountClient20 = new FxAccountClient20(string4, executorService);
        try {
            UpdateCredentialsDelegate updateCredentialsDelegate = new UpdateCredentialsDelegate(string2, string3, string4);
            new FxAccountSetupTask.FxAccountSignInTask((Context)this, string2, string3, fxAccountClient20, updateCredentialsDelegate).execute(new Void[0]);
        }
        catch (Exception exception) {
            this.showRemoteError(exception);
        }
    }

    protected void createButton() {
        this.button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String string2 = FxAccountUpdateCredentialsActivity.this.emailEdit.getText().toString();
                String string3 = FxAccountUpdateCredentialsActivity.this.passwordEdit.getText().toString();
                FxAccountUpdateCredentialsActivity.this.updateCredentials(string2, string3);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class UpdateCredentialsDelegate
    implements FxAccountClient10.RequestDelegate<FxAccountClient20.LoginResponse> {
        public final String email;
        public final String password;
        public final String serverURI;
        public final byte[] quickStretchedPW;

        public UpdateCredentialsDelegate(String string2, String string3, String string4) throws UnsupportedEncodingException, GeneralSecurityException {
            this.email = string2;
            this.password = string3;
            this.serverURI = string4;
            this.quickStretchedPW = FxAccountUtils.generateQuickStretchedPW(string2.getBytes("UTF-8"), string3.getBytes("UTF-8"));
        }

        @Override
        public void handleError(Exception exception) {
            FxAccountUpdateCredentialsActivity.this.showRemoteError(exception);
        }

        @Override
        public void handleFailure(int n, HttpResponse httpResponse) {
            FxAccountUpdateCredentialsActivity.this.showRemoteError(new HTTPFailureException(new SyncStorageResponse(httpResponse)));
        }

        @Override
        public void handleSuccess(FxAccountClient20.LoginResponse loginResponse) {
            FxAccountUpdateCredentialsActivity fxAccountUpdateCredentialsActivity = FxAccountUpdateCredentialsActivity.this;
            Logger.info(LOG_TAG, "Got success signing in.");
            if (FxAccountUpdateCredentialsActivity.this.account == null) {
                Logger.warn(LOG_TAG, "account must not be null");
                return;
            }
            AndroidFxAccount androidFxAccount = new AndroidFxAccount((Context)fxAccountUpdateCredentialsActivity, FxAccountUpdateCredentialsActivity.this.account);
            androidFxAccount.setQuickStretchedPW(this.quickStretchedPW);
            if (FxAccountConstants.LOG_PERSONAL_INFORMATION) {
                androidFxAccount.dump();
            }
            FxAccountUpdateCredentialsActivity.this.redirectToActivity(FxAccountStatusActivity.class);
        }
    }
}

