/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.authenticator;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.content.Context;
import android.os.Bundle;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountUtils;
import org.mozilla.gecko.browserid.BrowserIDKeyPair;
import org.mozilla.gecko.browserid.RSACryptoImplementation;
import org.mozilla.gecko.fxa.FxAccountConstants;
import org.mozilla.gecko.fxa.authenticator.AbstractFxAccount;
import org.mozilla.gecko.fxa.authenticator.FxAccountAuthenticator;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.Utils;

public class AndroidFxAccount
implements AbstractFxAccount {
    protected static final String LOG_TAG = AndroidFxAccount.class.getSimpleName();
    public static final int CURRENT_PREFS_VERSION = 1;
    public static final int CURRENT_ACCOUNT_VERSION = 3;
    public static final String ACCOUNT_KEY_ACCOUNT_VERSION = "version";
    public static final String ACCOUNT_KEY_PROFILE = "profile";
    public static final String ACCOUNT_KEY_IDP_SERVER = "idpServerURI";
    public static final String ACCOUNT_KEY_AUDIENCE = "audience";
    public static final String ACCOUNT_KEY_TOKEN_SERVER = "tokenServerURI";
    public static final String ACCOUNT_KEY_DESCRIPTOR = "descriptor";
    public static final int CURRENT_BUNDLE_VERSION = 1;
    public static final String BUNDLE_KEY_BUNDLE_VERSION = "version";
    public static final String BUNDLE_KEY_ASSERTION = "assertion";
    public static final String BUNDLE_KEY_CERTIFICATE = "certificate";
    public static final String BUNDLE_KEY_INVALID = "invalid";
    public static final String BUNDLE_KEY_SESSION_TOKEN = "sessionToken";
    public static final String BUNDLE_KEY_KEY_FETCH_TOKEN = "keyFetchToken";
    public static final String BUNDLE_KEY_VERIFIED = "verified";
    public static final String BUNDLE_KEY_KA = "kA";
    public static final String BUNDLE_KEY_KB = "kB";
    public static final String BUNDLE_KEY_UNWRAPKB = "unwrapkB";
    public static final String BUNDLE_KEY_ASSERTION_KEY_PAIR = "assertionKeyPair";
    protected final Context context;
    protected final AccountManager accountManager;
    protected final Account account;

    public AndroidFxAccount(Context context, Account account) {
        this.context = context;
        this.account = account;
        this.accountManager = AccountManager.get((Context)this.context);
    }

    protected int getAccountVersion() {
        String string2 = this.accountManager.getUserData(this.account, "version");
        if (string2 == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string2, 10);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    protected void persistBundle(ExtendedJSONObject extendedJSONObject) {
        this.accountManager.setUserData(this.account, ACCOUNT_KEY_DESCRIPTOR, extendedJSONObject.toJSONString());
    }

    protected ExtendedJSONObject unbundle() {
        int n = this.getAccountVersion();
        if (n < 3) {
            return null;
        }
        if (n > 3) {
            return null;
        }
        String string2 = this.accountManager.getUserData(this.account, ACCOUNT_KEY_DESCRIPTOR);
        if (string2 == null) {
            return null;
        }
        return this.unbundleAccountV1(string2);
    }

    protected String getBundleData(String string2) {
        ExtendedJSONObject extendedJSONObject = this.unbundle();
        if (extendedJSONObject == null) {
            return null;
        }
        return extendedJSONObject.getString(string2);
    }

    protected boolean getBundleDataBoolean(String string2, boolean bl) {
        ExtendedJSONObject extendedJSONObject = this.unbundle();
        if (extendedJSONObject == null) {
            return bl;
        }
        Boolean bl2 = extendedJSONObject.getBoolean(string2);
        if (bl2 == null) {
            return bl;
        }
        return bl2;
    }

    protected byte[] getBundleDataBytes(String string2) {
        ExtendedJSONObject extendedJSONObject = this.unbundle();
        if (extendedJSONObject == null) {
            return null;
        }
        return extendedJSONObject.getByteArrayHex(string2);
    }

    protected void updateBundleDataBytes(String string2, byte[] byArray) {
        this.updateBundleValue(string2, byArray == null ? null : Utils.byte2Hex(byArray));
    }

    protected void updateBundleValue(String string2, boolean bl) {
        ExtendedJSONObject extendedJSONObject = this.unbundle();
        if (extendedJSONObject == null) {
            return;
        }
        extendedJSONObject.put(string2, bl);
        this.persistBundle(extendedJSONObject);
    }

    protected void updateBundleValue(String string2, String string3) {
        ExtendedJSONObject extendedJSONObject = this.unbundle();
        if (extendedJSONObject == null) {
            return;
        }
        extendedJSONObject.put(string2, string3);
        this.persistBundle(extendedJSONObject);
    }

    private ExtendedJSONObject unbundleAccountV1(String string2) {
        ExtendedJSONObject extendedJSONObject;
        try {
            extendedJSONObject = new ExtendedJSONObject(string2);
        }
        catch (Exception exception) {
            return null;
        }
        if (1 == extendedJSONObject.getIntegerSafely("version")) {
            return extendedJSONObject;
        }
        return null;
    }

    public byte[] getEmailUTF8() {
        try {
            return this.account.name.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public String getProfile() {
        return this.accountManager.getUserData(this.account, ACCOUNT_KEY_PROFILE);
    }

    public String getAccountServerURI() {
        return this.accountManager.getUserData(this.account, ACCOUNT_KEY_IDP_SERVER);
    }

    public String getAudience() {
        return this.accountManager.getUserData(this.account, ACCOUNT_KEY_AUDIENCE);
    }

    public String getTokenServerURI() {
        return this.accountManager.getUserData(this.account, ACCOUNT_KEY_TOKEN_SERVER);
    }

    public String getSyncPrefsPath() throws GeneralSecurityException, UnsupportedEncodingException {
        String string2 = this.getProfile();
        String string3 = this.account.name;
        if (string2 == null) {
            throw new IllegalStateException("Missing profile. Cannot fetch prefs.");
        }
        if (string3 == null) {
            throw new IllegalStateException("Missing username. Cannot fetch prefs.");
        }
        String string4 = this.getTokenServerURI();
        if (string4 == null) {
            throw new IllegalStateException("No token server URI. Cannot fetch prefs.");
        }
        String string5 = this.getAccountServerURI();
        if (string5 == null) {
            throw new IllegalStateException("No account server URI. Cannot fetch prefs.");
        }
        String string6 = string5 + "!" + string4;
        return Utils.getPrefsPath("org.mozilla.fennec.fxa", string3, string6, string2, 1L);
    }

    public void setQuickStretchedPW(byte[] byArray) {
        this.accountManager.setPassword(this.account, byArray == null ? null : Utils.byte2Hex(byArray));
    }

    public byte[] getQuickStretchedPW() {
        String string2 = this.accountManager.getPassword(this.account);
        return string2 == null ? null : Utils.hex2Byte(string2);
    }

    public byte[] getSessionToken() {
        return this.getBundleDataBytes(BUNDLE_KEY_SESSION_TOKEN);
    }

    public byte[] getKeyFetchToken() {
        return this.getBundleDataBytes(BUNDLE_KEY_KEY_FETCH_TOKEN);
    }

    public void setSessionToken(byte[] byArray) {
        this.updateBundleDataBytes(BUNDLE_KEY_SESSION_TOKEN, byArray);
    }

    public void setKeyFetchToken(byte[] byArray) {
        this.updateBundleDataBytes(BUNDLE_KEY_KEY_FETCH_TOKEN, byArray);
    }

    public boolean isVerified() {
        return this.getBundleDataBoolean(BUNDLE_KEY_VERIFIED, false);
    }

    public void setVerified() {
        this.updateBundleValue(BUNDLE_KEY_VERIFIED, true);
    }

    public byte[] getKa() {
        return this.getBundleDataBytes(BUNDLE_KEY_KA);
    }

    public void setKa(byte[] byArray) {
        this.updateBundleValue(BUNDLE_KEY_KA, Utils.byte2Hex(byArray));
    }

    public void setWrappedKb(byte[] byArray) {
        if (byArray == null) {
            Logger.error(LOG_TAG, "wrappedKb is null: cannot set kB.");
            throw new IllegalArgumentException("wrappedKb is null: cannot set kB.");
        }
        byte[] byArray2 = this.getBundleDataBytes(BUNDLE_KEY_UNWRAPKB);
        if (byArray2 == null) {
            Logger.error(LOG_TAG, "unwrapKb is null: cannot set kB.");
            return;
        }
        byte[] byArray3 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray3[i] = (byte)(byArray[i] ^ byArray2[i]);
        }
        this.updateBundleValue(BUNDLE_KEY_KB, Utils.byte2Hex(byArray3));
    }

    public byte[] getKb() {
        return this.getBundleDataBytes(BUNDLE_KEY_KB);
    }

    protected BrowserIDKeyPair generateNewAssertionKeyPair() throws GeneralSecurityException {
        Logger.info(LOG_TAG, "Generating new assertion key pair.");
        return RSACryptoImplementation.generateKeyPair(1024);
    }

    public BrowserIDKeyPair getAssertionKeyPair() throws GeneralSecurityException {
        try {
            String string2 = this.getBundleData(BUNDLE_KEY_ASSERTION_KEY_PAIR);
            return RSACryptoImplementation.fromJSONObject(new ExtendedJSONObject(string2));
        }
        catch (Exception exception) {
            BrowserIDKeyPair browserIDKeyPair = this.generateNewAssertionKeyPair();
            ExtendedJSONObject extendedJSONObject = this.unbundle();
            if (extendedJSONObject == null) {
                extendedJSONObject = new ExtendedJSONObject();
            }
            extendedJSONObject.put(BUNDLE_KEY_ASSERTION_KEY_PAIR, browserIDKeyPair.toJSONObject().toJSONString());
            this.persistBundle(extendedJSONObject);
            return browserIDKeyPair;
        }
    }

    public String getCertificate() {
        return this.getBundleData(BUNDLE_KEY_CERTIFICATE);
    }

    public void setCertificate(String string2) {
        this.updateBundleValue(BUNDLE_KEY_CERTIFICATE, string2);
    }

    public String getAssertion() {
        return this.getBundleData(BUNDLE_KEY_ASSERTION);
    }

    public void setAssertion(String string2) {
        this.updateBundleValue(BUNDLE_KEY_ASSERTION, string2);
    }

    public ExtendedJSONObject toJSONObject() {
        ExtendedJSONObject extendedJSONObject = this.unbundle();
        extendedJSONObject.put("email", this.account.name);
        try {
            extendedJSONObject.put("emailUTF8", Utils.byte2Hex(this.account.name.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        extendedJSONObject.put("quickStretchedPW", this.accountManager.getPassword(this.account));
        return extendedJSONObject;
    }

    public static Account addAndroidAccount(Context context, String string2, String string3, String string4, String string5, String string6, byte[] byArray, byte[] byArray2, boolean bl) throws UnsupportedEncodingException, GeneralSecurityException, URISyntaxException {
        if (string2 == null) {
            throw new IllegalArgumentException("email must not be null");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("password must not be null");
        }
        if (string5 == null) {
            throw new IllegalArgumentException("idpServerURI must not be null");
        }
        if (string6 == null) {
            throw new IllegalArgumentException("tokenServerURI must not be null");
        }
        if (byArray == null && byArray2 != null || byArray != null && byArray2 == null) {
            throw new IllegalArgumentException("none or both of sessionToken and keyFetchToken may be null");
        }
        byte[] byArray3 = string2.getBytes("UTF-8");
        byte[] byArray4 = string3.getBytes("UTF-8");
        byte[] byArray5 = FxAccountUtils.generateQuickStretchedPW(byArray3, byArray4);
        byte[] byArray6 = FxAccountUtils.generateUnwrapBKey(byArray5);
        Bundle bundle = new Bundle();
        bundle.putString("version", "3");
        bundle.putString(ACCOUNT_KEY_IDP_SERVER, string5);
        bundle.putString(ACCOUNT_KEY_TOKEN_SERVER, string6);
        bundle.putString(ACCOUNT_KEY_AUDIENCE, AndroidFxAccount.computeAudience(string6));
        bundle.putString(ACCOUNT_KEY_PROFILE, string4);
        ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
        extendedJSONObject.put("version", 1);
        extendedJSONObject.put(BUNDLE_KEY_SESSION_TOKEN, byArray == null ? null : Utils.byte2Hex(byArray));
        extendedJSONObject.put(BUNDLE_KEY_KEY_FETCH_TOKEN, byArray2 == null ? null : Utils.byte2Hex(byArray2));
        extendedJSONObject.put(BUNDLE_KEY_VERIFIED, bl);
        extendedJSONObject.put(BUNDLE_KEY_UNWRAPKB, Utils.byte2Hex(byArray6));
        bundle.putString(ACCOUNT_KEY_DESCRIPTOR, extendedJSONObject.toJSONString());
        Account account = new Account(string2, "org.mozilla.fennec_account");
        AccountManager accountManager = AccountManager.get((Context)context);
        boolean bl2 = accountManager.addAccountExplicitly(account, Utils.byte2Hex(byArray5), bundle);
        if (!bl2) {
            return null;
        }
        FxAccountAuthenticator.enableSyncing(context, account);
        return account;
    }

    private static String computeAudience(String string2) throws URISyntaxException {
        URI uRI = new URI(string2);
        return new URI(uRI.getScheme(), uRI.getHost(), null, null).toString();
    }

    public boolean isValid() {
        return !this.getBundleDataBoolean(BUNDLE_KEY_INVALID, false);
    }

    public void setInvalid() {
        this.updateBundleValue(BUNDLE_KEY_INVALID, true);
    }

    public void dump() {
        if (!FxAccountConstants.LOG_PERSONAL_INFORMATION) {
            return;
        }
        ExtendedJSONObject extendedJSONObject = this.toJSONObject();
        ArrayList<String> arrayList = new ArrayList<String>(extendedJSONObject.keySet());
        Collections.sort(arrayList);
        for (String string2 : arrayList) {
            FxAccountConstants.pii(LOG_TAG, string2 + ": " + extendedJSONObject.get(string2));
        }
    }

    public void forgetAccountTokens() {
        ExtendedJSONObject extendedJSONObject = this.unbundle();
        if (extendedJSONObject == null) {
            return;
        }
        extendedJSONObject.remove(BUNDLE_KEY_SESSION_TOKEN);
        extendedJSONObject.remove(BUNDLE_KEY_KEY_FETCH_TOKEN);
        this.persistBundle(extendedJSONObject);
    }

    public void forgetQuickstretchedPW() {
        this.accountManager.setPassword(this.account, null);
    }
}

