/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.client;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpHost;
import ch.boye.httpclientandroidlib.HttpRequest;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.ProtocolException;
import ch.boye.httpclientandroidlib.androidextra.HttpClientAndroidLog;
import ch.boye.httpclientandroidlib.annotation.Immutable;
import ch.boye.httpclientandroidlib.client.CircularRedirectException;
import ch.boye.httpclientandroidlib.client.RedirectStrategy;
import ch.boye.httpclientandroidlib.client.methods.HttpGet;
import ch.boye.httpclientandroidlib.client.methods.HttpHead;
import ch.boye.httpclientandroidlib.client.methods.HttpUriRequest;
import ch.boye.httpclientandroidlib.client.utils.URIUtils;
import ch.boye.httpclientandroidlib.impl.client.RedirectLocations;
import ch.boye.httpclientandroidlib.params.HttpParams;
import ch.boye.httpclientandroidlib.protocol.HttpContext;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;

@Immutable
public class DefaultRedirectStrategy
implements RedirectStrategy {
    public HttpClientAndroidLog log = new HttpClientAndroidLog(this.getClass());
    public static final String REDIRECT_LOCATIONS = "http.protocol.redirect-locations";

    public boolean isRedirected(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws ProtocolException {
        if (httpResponse == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        int n = httpResponse.getStatusLine().getStatusCode();
        String string = httpRequest.getRequestLine().getMethod();
        Header header = httpResponse.getFirstHeader("location");
        switch (n) {
            case 302: {
                return (string.equalsIgnoreCase("GET") || string.equalsIgnoreCase("HEAD")) && header != null;
            }
            case 301: 
            case 307: {
                return string.equalsIgnoreCase("GET") || string.equalsIgnoreCase("HEAD");
            }
            case 303: {
                return true;
            }
        }
        return false;
    }

    public URI getLocationURI(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws ProtocolException {
        Serializable serializable;
        URI uRI;
        Object object;
        if (httpResponse == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        Header header = httpResponse.getFirstHeader("location");
        if (header == null) {
            throw new ProtocolException("Received redirect response " + httpResponse.getStatusLine() + " but no location header");
        }
        String string = header.getValue();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Redirect requested to location '" + string + "'");
        }
        URI uRI2 = this.createLocationURI(string);
        HttpParams httpParams = httpResponse.getParams();
        if (!uRI2.isAbsolute()) {
            if (httpParams.isParameterTrue("http.protocol.reject-relative-redirect")) {
                throw new ProtocolException("Relative redirect location '" + uRI2 + "' not allowed");
            }
            object = (HttpHost)httpContext.getAttribute("http.target_host");
            if (object == null) {
                throw new IllegalStateException("Target host not available in the HTTP context");
            }
            try {
                uRI = new URI(httpRequest.getRequestLine().getUri());
                serializable = URIUtils.rewriteURI(uRI, (HttpHost)object, true);
                uRI2 = URIUtils.resolve(serializable, uRI2);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new ProtocolException(uRISyntaxException.getMessage(), uRISyntaxException);
            }
        }
        if (httpParams.isParameterFalse("http.protocol.allow-circular-redirects")) {
            object = (RedirectLocations)httpContext.getAttribute(REDIRECT_LOCATIONS);
            if (object == null) {
                object = new RedirectLocations();
                httpContext.setAttribute(REDIRECT_LOCATIONS, object);
            }
            if (uRI2.getFragment() != null) {
                try {
                    serializable = new HttpHost(uRI2.getHost(), uRI2.getPort(), uRI2.getScheme());
                    uRI = URIUtils.rewriteURI(uRI2, (HttpHost)serializable, true);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new ProtocolException(uRISyntaxException.getMessage(), uRISyntaxException);
                }
            } else {
                uRI = uRI2;
            }
            if (((RedirectLocations)object).contains(uRI)) {
                throw new CircularRedirectException("Circular redirect to '" + uRI + "'");
            }
            ((RedirectLocations)object).add(uRI);
        }
        return uRI2;
    }

    protected URI createLocationURI(String string) throws ProtocolException {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ProtocolException("Invalid redirect URI: " + string, uRISyntaxException);
        }
    }

    public HttpUriRequest getRedirect(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws ProtocolException {
        URI uRI = this.getLocationURI(httpRequest, httpResponse, httpContext);
        String string = httpRequest.getRequestLine().getMethod();
        if (string.equalsIgnoreCase("HEAD")) {
            return new HttpHead(uRI);
        }
        return new HttpGet(uRI);
    }
}

