/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.conn;

import ch.boye.httpclientandroidlib.HttpHost;
import ch.boye.httpclientandroidlib.androidextra.HttpClientAndroidLog;
import ch.boye.httpclientandroidlib.annotation.ThreadSafe;
import ch.boye.httpclientandroidlib.conn.ClientConnectionOperator;
import ch.boye.httpclientandroidlib.conn.ConnectTimeoutException;
import ch.boye.httpclientandroidlib.conn.HttpHostConnectException;
import ch.boye.httpclientandroidlib.conn.OperatedClientConnection;
import ch.boye.httpclientandroidlib.conn.scheme.LayeredSchemeSocketFactory;
import ch.boye.httpclientandroidlib.conn.scheme.Scheme;
import ch.boye.httpclientandroidlib.conn.scheme.SchemeRegistry;
import ch.boye.httpclientandroidlib.conn.scheme.SchemeSocketFactory;
import ch.boye.httpclientandroidlib.impl.conn.DefaultClientConnection;
import ch.boye.httpclientandroidlib.impl.conn.HttpInetSocketAddress;
import ch.boye.httpclientandroidlib.params.HttpConnectionParams;
import ch.boye.httpclientandroidlib.params.HttpParams;
import ch.boye.httpclientandroidlib.protocol.HttpContext;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;

@ThreadSafe
public class DefaultClientConnectionOperator
implements ClientConnectionOperator {
    public HttpClientAndroidLog log = new HttpClientAndroidLog(this.getClass());
    protected final SchemeRegistry schemeRegistry;

    public DefaultClientConnectionOperator(SchemeRegistry schemeRegistry) {
        if (schemeRegistry == null) {
            throw new IllegalArgumentException("Scheme registry amy not be null");
        }
        this.schemeRegistry = schemeRegistry;
    }

    public OperatedClientConnection createConnection() {
        return new DefaultClientConnection();
    }

    public void openConnection(OperatedClientConnection operatedClientConnection, HttpHost httpHost, InetAddress inetAddress, HttpContext httpContext, HttpParams httpParams) throws IOException {
        if (operatedClientConnection == null) {
            throw new IllegalArgumentException("Connection may not be null");
        }
        if (httpHost == null) {
            throw new IllegalArgumentException("Target host may not be null");
        }
        if (httpParams == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        if (operatedClientConnection.isOpen()) {
            throw new IllegalStateException("Connection must not be open");
        }
        Scheme scheme = this.schemeRegistry.getScheme(httpHost.getSchemeName());
        SchemeSocketFactory schemeSocketFactory = scheme.getSchemeSocketFactory();
        InetAddress[] inetAddressArray = this.resolveHostname(httpHost.getHostName());
        int n = scheme.resolvePort(httpHost.getPort());
        for (int i = 0; i < inetAddressArray.length; ++i) {
            HttpInetSocketAddress httpInetSocketAddress;
            block12: {
                InetAddress inetAddress2 = inetAddressArray[i];
                boolean bl = i == inetAddressArray.length - 1;
                Socket socket = schemeSocketFactory.createSocket(httpParams);
                operatedClientConnection.opening(socket, httpHost);
                httpInetSocketAddress = new HttpInetSocketAddress(httpHost, inetAddress2, n);
                InetSocketAddress inetSocketAddress = null;
                if (inetAddress != null) {
                    inetSocketAddress = new InetSocketAddress(inetAddress, 0);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Connecting to " + httpInetSocketAddress);
                }
                try {
                    Socket socket2 = schemeSocketFactory.connectSocket(socket, httpInetSocketAddress, inetSocketAddress, httpParams);
                    if (socket != socket2) {
                        socket = socket2;
                        operatedClientConnection.opening(socket, httpHost);
                    }
                    this.prepareSocket(socket, httpContext, httpParams);
                    operatedClientConnection.openCompleted(schemeSocketFactory.isSecure(socket), httpParams);
                    return;
                }
                catch (ConnectException connectException) {
                    if (bl) {
                        throw new HttpHostConnectException(httpHost, connectException);
                    }
                }
                catch (ConnectTimeoutException connectTimeoutException) {
                    if (!bl) break block12;
                    throw connectTimeoutException;
                }
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("Connect to " + httpInetSocketAddress + " timed out. " + "Connection will be retried using another IP address");
        }
    }

    public void updateSecureConnection(OperatedClientConnection operatedClientConnection, HttpHost httpHost, HttpContext httpContext, HttpParams httpParams) throws IOException {
        Socket socket;
        if (operatedClientConnection == null) {
            throw new IllegalArgumentException("Connection may not be null");
        }
        if (httpHost == null) {
            throw new IllegalArgumentException("Target host may not be null");
        }
        if (httpParams == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        if (!operatedClientConnection.isOpen()) {
            throw new IllegalStateException("Connection must be open");
        }
        Scheme scheme = this.schemeRegistry.getScheme(httpHost.getSchemeName());
        if (!(scheme.getSchemeSocketFactory() instanceof LayeredSchemeSocketFactory)) {
            throw new IllegalArgumentException("Target scheme (" + scheme.getName() + ") must have layered socket factory.");
        }
        LayeredSchemeSocketFactory layeredSchemeSocketFactory = (LayeredSchemeSocketFactory)scheme.getSchemeSocketFactory();
        try {
            socket = layeredSchemeSocketFactory.createLayeredSocket(operatedClientConnection.getSocket(), httpHost.getHostName(), httpHost.getPort(), true);
        }
        catch (ConnectException connectException) {
            throw new HttpHostConnectException(httpHost, connectException);
        }
        this.prepareSocket(socket, httpContext, httpParams);
        operatedClientConnection.update(socket, httpHost, layeredSchemeSocketFactory.isSecure(socket), httpParams);
    }

    protected void prepareSocket(Socket socket, HttpContext httpContext, HttpParams httpParams) throws IOException {
        socket.setTcpNoDelay(HttpConnectionParams.getTcpNoDelay(httpParams));
        socket.setSoTimeout(HttpConnectionParams.getSoTimeout(httpParams));
        int n = HttpConnectionParams.getLinger(httpParams);
        if (n >= 0) {
            socket.setSoLinger(n > 0, n);
        }
    }

    protected InetAddress[] resolveHostname(String string) throws UnknownHostException {
        return InetAddress.getAllByName(string);
    }
}

