/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.GeckoEventResponder;

public final class EventDispatcher {
    private static final String LOGTAG = "GeckoEventDispatcher";
    private final Map<String, CopyOnWriteArrayList<GeckoEventListener>> mEventListeners = new HashMap<String, CopyOnWriteArrayList<GeckoEventListener>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEventListener(String string, GeckoEventListener geckoEventListener) {
        Map<String, CopyOnWriteArrayList<GeckoEventListener>> map = this.mEventListeners;
        synchronized (map) {
            CopyOnWriteArrayList<GeckoEventListener> copyOnWriteArrayList = this.mEventListeners.get(string);
            if (copyOnWriteArrayList == null) {
                copyOnWriteArrayList = new CopyOnWriteArrayList();
            } else if (copyOnWriteArrayList.contains(geckoEventListener)) {
                Log.w((String)LOGTAG, (String)("EventListener already registered for event '" + string + "'"), (Throwable)new IllegalArgumentException());
            }
            copyOnWriteArrayList.add(geckoEventListener);
            this.mEventListeners.put(string, copyOnWriteArrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterEventListener(String string, GeckoEventListener geckoEventListener) {
        Map<String, CopyOnWriteArrayList<GeckoEventListener>> map = this.mEventListeners;
        synchronized (map) {
            CopyOnWriteArrayList<GeckoEventListener> copyOnWriteArrayList = this.mEventListeners.get(string);
            if (copyOnWriteArrayList == null) {
                Log.w((String)LOGTAG, (String)("unregisterEventListener: event '" + string + "' has no listeners"));
                return;
            }
            if (!copyOnWriteArrayList.remove(geckoEventListener)) {
                Log.w((String)LOGTAG, (String)("unregisterEventListener: tried to remove an unregistered listener for event '" + string + "'"));
            }
            if (copyOnWriteArrayList.size() == 0) {
                this.mEventListeners.remove(string);
            }
        }
    }

    public String dispatchEvent(String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            return this.dispatchEvent(jSONObject);
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"dispatchEvent: malformed JSON.", (Throwable)exception);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dispatchEvent(JSONObject jSONObject) {
        try {
            CopyOnWriteArrayList<GeckoEventListener> copyOnWriteArrayList;
            JSONObject jSONObject2;
            JSONObject jSONObject3 = jSONObject2 = jSONObject.has("gecko") ? jSONObject.getJSONObject("gecko") : null;
            if (jSONObject2 != null) {
                jSONObject = jSONObject2;
            }
            String string = jSONObject.getString("type");
            if (jSONObject2 != null) {
                Log.w((String)LOGTAG, (String)("Message '" + string + "' has deprecated 'gecko' property!"));
            }
            Object object = this.mEventListeners;
            synchronized (object) {
                copyOnWriteArrayList = this.mEventListeners.get(string);
            }
            if (copyOnWriteArrayList == null || copyOnWriteArrayList.size() == 0) {
                Log.d((String)LOGTAG, (String)("dispatchEvent: no listeners registered for event '" + string + "'"));
                return "";
            }
            object = null;
            for (GeckoEventListener geckoEventListener : copyOnWriteArrayList) {
                geckoEventListener.handleMessage(string, jSONObject);
                if (!(geckoEventListener instanceof GeckoEventResponder)) continue;
                String string2 = ((GeckoEventResponder)geckoEventListener).getResponse(jSONObject);
                if (object != null && string2 != null) {
                    Log.e((String)LOGTAG, (String)("Received two responses for message of type " + string));
                }
                object = string2;
            }
            if (object != null) {
                return object;
            }
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)("handleGeckoMessage throws " + exception), (Throwable)exception);
        }
        return "";
    }
}

