/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.os.Handler;
import android.os.Looper;
import java.util.concurrent.SynchronousQueue;
import org.mozilla.gecko.util.ThreadUtils;

final class GeckoBackgroundThread
extends Thread {
    private static final String LOOPER_NAME = "GeckoBackgroundThread";
    private static Handler sHandler = null;
    private SynchronousQueue<Handler> mHandlerQueue = new SynchronousQueue();

    private GeckoBackgroundThread() {
    }

    public void run() {
        this.setName(LOOPER_NAME);
        Looper.prepare();
        try {
            this.mHandlerQueue.put(new Handler());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Looper.loop();
    }

    static synchronized Handler getHandler() {
        if (sHandler == null) {
            GeckoBackgroundThread geckoBackgroundThread = new GeckoBackgroundThread();
            ThreadUtils.setBackgroundThread(geckoBackgroundThread);
            geckoBackgroundThread.start();
            try {
                sHandler = geckoBackgroundThread.mHandlerQueue.take();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return sHandler;
    }

    static void post(Runnable runnable) {
        Handler handler = GeckoBackgroundThread.getHandler();
        if (handler == null) {
            throw new IllegalStateException("No handler! Must have been interrupted. Not posting.");
        }
        handler.post(runnable);
    }
}

