/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.client;

import ch.boye.httpclientandroidlib.ConnectionReuseStrategy;
import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpEntity;
import ch.boye.httpclientandroidlib.HttpEntityEnclosingRequest;
import ch.boye.httpclientandroidlib.HttpException;
import ch.boye.httpclientandroidlib.HttpHost;
import ch.boye.httpclientandroidlib.HttpRequest;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.ProtocolException;
import ch.boye.httpclientandroidlib.ProtocolVersion;
import ch.boye.httpclientandroidlib.androidextra.HttpClientAndroidLog;
import ch.boye.httpclientandroidlib.annotation.NotThreadSafe;
import ch.boye.httpclientandroidlib.auth.AuthScheme;
import ch.boye.httpclientandroidlib.auth.AuthScope;
import ch.boye.httpclientandroidlib.auth.AuthState;
import ch.boye.httpclientandroidlib.auth.AuthenticationException;
import ch.boye.httpclientandroidlib.auth.Credentials;
import ch.boye.httpclientandroidlib.auth.MalformedChallengeException;
import ch.boye.httpclientandroidlib.client.AuthenticationHandler;
import ch.boye.httpclientandroidlib.client.CredentialsProvider;
import ch.boye.httpclientandroidlib.client.HttpRequestRetryHandler;
import ch.boye.httpclientandroidlib.client.NonRepeatableRequestException;
import ch.boye.httpclientandroidlib.client.RedirectException;
import ch.boye.httpclientandroidlib.client.RedirectHandler;
import ch.boye.httpclientandroidlib.client.RedirectStrategy;
import ch.boye.httpclientandroidlib.client.RequestDirector;
import ch.boye.httpclientandroidlib.client.UserTokenHandler;
import ch.boye.httpclientandroidlib.client.methods.AbortableHttpRequest;
import ch.boye.httpclientandroidlib.client.methods.HttpUriRequest;
import ch.boye.httpclientandroidlib.client.params.HttpClientParams;
import ch.boye.httpclientandroidlib.client.utils.URIUtils;
import ch.boye.httpclientandroidlib.conn.BasicManagedEntity;
import ch.boye.httpclientandroidlib.conn.ClientConnectionManager;
import ch.boye.httpclientandroidlib.conn.ClientConnectionRequest;
import ch.boye.httpclientandroidlib.conn.ConnectionKeepAliveStrategy;
import ch.boye.httpclientandroidlib.conn.ManagedClientConnection;
import ch.boye.httpclientandroidlib.conn.params.ConnManagerParams;
import ch.boye.httpclientandroidlib.conn.routing.BasicRouteDirector;
import ch.boye.httpclientandroidlib.conn.routing.HttpRoute;
import ch.boye.httpclientandroidlib.conn.routing.HttpRoutePlanner;
import ch.boye.httpclientandroidlib.conn.scheme.Scheme;
import ch.boye.httpclientandroidlib.entity.BufferedHttpEntity;
import ch.boye.httpclientandroidlib.impl.client.DefaultRedirectStrategyAdaptor;
import ch.boye.httpclientandroidlib.impl.client.EntityEnclosingRequestWrapper;
import ch.boye.httpclientandroidlib.impl.client.RequestWrapper;
import ch.boye.httpclientandroidlib.impl.client.RoutedRequest;
import ch.boye.httpclientandroidlib.impl.client.TunnelRefusedException;
import ch.boye.httpclientandroidlib.impl.conn.ConnectionShutdownException;
import ch.boye.httpclientandroidlib.message.AbstractHttpMessage;
import ch.boye.httpclientandroidlib.message.BasicHttpRequest;
import ch.boye.httpclientandroidlib.params.HttpConnectionParams;
import ch.boye.httpclientandroidlib.params.HttpParams;
import ch.boye.httpclientandroidlib.params.HttpProtocolParams;
import ch.boye.httpclientandroidlib.protocol.HttpContext;
import ch.boye.httpclientandroidlib.protocol.HttpProcessor;
import ch.boye.httpclientandroidlib.protocol.HttpRequestExecutor;
import ch.boye.httpclientandroidlib.util.EntityUtils;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class DefaultRequestDirector
implements RequestDirector {
    public HttpClientAndroidLog log;
    protected final ClientConnectionManager connManager;
    protected final HttpRoutePlanner routePlanner;
    protected final ConnectionReuseStrategy reuseStrategy;
    protected final ConnectionKeepAliveStrategy keepAliveStrategy;
    protected final HttpRequestExecutor requestExec;
    protected final HttpProcessor httpProcessor;
    protected final HttpRequestRetryHandler retryHandler;
    @Deprecated
    protected final RedirectHandler redirectHandler = null;
    protected final RedirectStrategy redirectStrategy;
    protected final AuthenticationHandler targetAuthHandler;
    protected final AuthenticationHandler proxyAuthHandler;
    protected final UserTokenHandler userTokenHandler;
    protected final HttpParams params;
    protected ManagedClientConnection managedConn;
    protected final AuthState targetAuthState;
    protected final AuthState proxyAuthState;
    private int execCount;
    private int redirectCount;
    private int maxRedirects;
    private HttpHost virtualHost;

    @Deprecated
    public DefaultRequestDirector(HttpRequestExecutor httpRequestExecutor, ClientConnectionManager clientConnectionManager, ConnectionReuseStrategy connectionReuseStrategy, ConnectionKeepAliveStrategy connectionKeepAliveStrategy, HttpRoutePlanner httpRoutePlanner, HttpProcessor httpProcessor, HttpRequestRetryHandler httpRequestRetryHandler, RedirectHandler redirectHandler, AuthenticationHandler authenticationHandler, AuthenticationHandler authenticationHandler2, UserTokenHandler userTokenHandler, HttpParams httpParams) {
        this(new HttpClientAndroidLog(DefaultRequestDirector.class), httpRequestExecutor, clientConnectionManager, connectionReuseStrategy, connectionKeepAliveStrategy, httpRoutePlanner, httpProcessor, httpRequestRetryHandler, new DefaultRedirectStrategyAdaptor(redirectHandler), authenticationHandler, authenticationHandler2, userTokenHandler, httpParams);
    }

    public DefaultRequestDirector(HttpClientAndroidLog httpClientAndroidLog, HttpRequestExecutor httpRequestExecutor, ClientConnectionManager clientConnectionManager, ConnectionReuseStrategy connectionReuseStrategy, ConnectionKeepAliveStrategy connectionKeepAliveStrategy, HttpRoutePlanner httpRoutePlanner, HttpProcessor httpProcessor, HttpRequestRetryHandler httpRequestRetryHandler, RedirectStrategy redirectStrategy, AuthenticationHandler authenticationHandler, AuthenticationHandler authenticationHandler2, UserTokenHandler userTokenHandler, HttpParams httpParams) {
        if (httpClientAndroidLog == null) {
            throw new IllegalArgumentException("Log may not be null.");
        }
        if (httpRequestExecutor == null) {
            throw new IllegalArgumentException("Request executor may not be null.");
        }
        if (clientConnectionManager == null) {
            throw new IllegalArgumentException("Client connection manager may not be null.");
        }
        if (connectionReuseStrategy == null) {
            throw new IllegalArgumentException("Connection reuse strategy may not be null.");
        }
        if (connectionKeepAliveStrategy == null) {
            throw new IllegalArgumentException("Connection keep alive strategy may not be null.");
        }
        if (httpRoutePlanner == null) {
            throw new IllegalArgumentException("Route planner may not be null.");
        }
        if (httpProcessor == null) {
            throw new IllegalArgumentException("HTTP protocol processor may not be null.");
        }
        if (httpRequestRetryHandler == null) {
            throw new IllegalArgumentException("HTTP request retry handler may not be null.");
        }
        if (redirectStrategy == null) {
            throw new IllegalArgumentException("Redirect strategy may not be null.");
        }
        if (authenticationHandler == null) {
            throw new IllegalArgumentException("Target authentication handler may not be null.");
        }
        if (authenticationHandler2 == null) {
            throw new IllegalArgumentException("Proxy authentication handler may not be null.");
        }
        if (userTokenHandler == null) {
            throw new IllegalArgumentException("User token handler may not be null.");
        }
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.log = httpClientAndroidLog;
        this.requestExec = httpRequestExecutor;
        this.connManager = clientConnectionManager;
        this.reuseStrategy = connectionReuseStrategy;
        this.keepAliveStrategy = connectionKeepAliveStrategy;
        this.routePlanner = httpRoutePlanner;
        this.httpProcessor = httpProcessor;
        this.retryHandler = httpRequestRetryHandler;
        this.redirectStrategy = redirectStrategy;
        this.targetAuthHandler = authenticationHandler;
        this.proxyAuthHandler = authenticationHandler2;
        this.userTokenHandler = userTokenHandler;
        this.params = httpParams;
        this.managedConn = null;
        this.execCount = 0;
        this.redirectCount = 0;
        this.maxRedirects = this.params.getIntParameter("http.protocol.max-redirects", 100);
        this.targetAuthState = new AuthState();
        this.proxyAuthState = new AuthState();
    }

    private RequestWrapper wrapRequest(HttpRequest httpRequest) throws ProtocolException {
        if (httpRequest instanceof HttpEntityEnclosingRequest) {
            return new EntityEnclosingRequestWrapper((HttpEntityEnclosingRequest)httpRequest);
        }
        return new RequestWrapper(httpRequest);
    }

    protected void rewriteRequestURI(RequestWrapper requestWrapper, HttpRoute httpRoute) throws ProtocolException {
        try {
            URI uRI = requestWrapper.getURI();
            if (httpRoute.getProxyHost() != null && !httpRoute.isTunnelled()) {
                if (!uRI.isAbsolute()) {
                    HttpHost httpHost = httpRoute.getTargetHost();
                    uRI = URIUtils.rewriteURI(uRI, httpHost);
                    requestWrapper.setURI(uRI);
                }
            } else if (uRI.isAbsolute()) {
                uRI = URIUtils.rewriteURI(uRI, null);
                requestWrapper.setURI(uRI);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ProtocolException("Invalid URI: " + requestWrapper.getRequestLine().getUri(), uRISyntaxException);
        }
    }

    @Override
    public HttpResponse execute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        int n;
        HttpRequest httpRequest2 = httpRequest;
        RequestWrapper requestWrapper = this.wrapRequest(httpRequest2);
        requestWrapper.setParams(this.params);
        HttpRoute httpRoute = this.determineRoute(httpHost, requestWrapper, httpContext);
        this.virtualHost = (HttpHost)httpRequest2.getParams().getParameter("http.virtual-host");
        if (this.virtualHost != null && this.virtualHost.getPort() == -1 && (n = httpHost.getPort()) != -1) {
            this.virtualHost = new HttpHost(this.virtualHost.getHostName(), n, this.virtualHost.getSchemeName());
        }
        RoutedRequest routedRequest = new RoutedRequest(requestWrapper, httpRoute);
        boolean bl = false;
        boolean bl2 = false;
        try {
            Object object;
            HttpResponse httpResponse = null;
            while (!bl2) {
                RoutedRequest routedRequest2;
                long l;
                Object object2;
                object = routedRequest.getRequest();
                HttpRoute httpRoute2 = routedRequest.getRoute();
                httpResponse = null;
                Object object3 = httpContext.getAttribute("http.user-token");
                if (this.managedConn == null) {
                    object2 = this.connManager.requestConnection(httpRoute2, object3);
                    if (httpRequest2 instanceof AbortableHttpRequest) {
                        ((AbortableHttpRequest)((Object)httpRequest2)).setConnectionRequest((ClientConnectionRequest)object2);
                    }
                    l = ConnManagerParams.getTimeout(this.params);
                    try {
                        this.managedConn = object2.getConnection(l, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        InterruptedIOException interruptedIOException = new InterruptedIOException();
                        interruptedIOException.initCause(interruptedException);
                        throw interruptedIOException;
                    }
                    if (HttpConnectionParams.isStaleCheckingEnabled(this.params) && this.managedConn.isOpen()) {
                        this.log.debug("Stale connection check");
                        if (this.managedConn.isStale()) {
                            this.log.debug("Stale connection detected");
                            this.managedConn.close();
                        }
                    }
                }
                if (httpRequest2 instanceof AbortableHttpRequest) {
                    ((AbortableHttpRequest)((Object)httpRequest2)).setReleaseTrigger(this.managedConn);
                }
                try {
                    this.tryConnect(routedRequest, httpContext);
                }
                catch (TunnelRefusedException tunnelRefusedException) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(tunnelRefusedException.getMessage());
                    }
                    httpResponse = tunnelRefusedException.getResponse();
                    break;
                }
                ((RequestWrapper)object).resetHeaders();
                this.rewriteRequestURI((RequestWrapper)object, httpRoute2);
                httpHost = this.virtualHost;
                if (httpHost == null) {
                    httpHost = httpRoute2.getTargetHost();
                }
                object2 = httpRoute2.getProxyHost();
                httpContext.setAttribute("http.target_host", httpHost);
                httpContext.setAttribute("http.proxy_host", object2);
                httpContext.setAttribute("http.connection", this.managedConn);
                httpContext.setAttribute("http.auth.target-scope", this.targetAuthState);
                httpContext.setAttribute("http.auth.proxy-scope", this.proxyAuthState);
                this.requestExec.preProcess((HttpRequest)object, this.httpProcessor, httpContext);
                httpResponse = this.tryExecute(routedRequest, httpContext);
                if (httpResponse == null) continue;
                httpResponse.setParams(this.params);
                this.requestExec.postProcess(httpResponse, this.httpProcessor, httpContext);
                bl = this.reuseStrategy.keepAlive(httpResponse, httpContext);
                if (bl) {
                    l = this.keepAliveStrategy.getKeepAliveDuration(httpResponse, httpContext);
                    if (this.log.isDebugEnabled()) {
                        String string = l > 0L ? "for " + l + " " + (Object)((Object)TimeUnit.MILLISECONDS) : "indefinitely";
                        this.log.debug("Connection can be kept alive " + string);
                    }
                    this.managedConn.setIdleDuration(l, TimeUnit.MILLISECONDS);
                }
                if ((routedRequest2 = this.handleResponse(routedRequest, httpResponse, httpContext)) == null) {
                    bl2 = true;
                } else {
                    if (bl) {
                        HttpEntity httpEntity = httpResponse.getEntity();
                        EntityUtils.consume(httpEntity);
                        this.managedConn.markReusable();
                    } else {
                        this.managedConn.close();
                        this.invalidateAuthIfSuccessful(this.proxyAuthState);
                        this.invalidateAuthIfSuccessful(this.targetAuthState);
                    }
                    if (!routedRequest2.getRoute().equals(routedRequest.getRoute())) {
                        this.releaseConnection();
                    }
                    routedRequest = routedRequest2;
                }
                if (this.managedConn == null || object3 != null) continue;
                object3 = this.userTokenHandler.getUserToken(httpContext);
                httpContext.setAttribute("http.user-token", object3);
                if (object3 == null) continue;
                this.managedConn.setState(object3);
            }
            if (httpResponse == null || httpResponse.getEntity() == null || !httpResponse.getEntity().isStreaming()) {
                if (bl) {
                    this.managedConn.markReusable();
                }
                this.releaseConnection();
            } else {
                object = httpResponse.getEntity();
                object = new BasicManagedEntity((HttpEntity)object, this.managedConn, bl);
                httpResponse.setEntity((HttpEntity)object);
            }
            return httpResponse;
        }
        catch (ConnectionShutdownException connectionShutdownException) {
            InterruptedIOException interruptedIOException = new InterruptedIOException("Connection has been shut down");
            interruptedIOException.initCause(connectionShutdownException);
            throw interruptedIOException;
        }
        catch (HttpException httpException) {
            this.abortConnection();
            throw httpException;
        }
        catch (IOException iOException) {
            this.abortConnection();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.abortConnection();
            throw runtimeException;
        }
    }

    private void tryConnect(RoutedRequest routedRequest, HttpContext httpContext) throws HttpException, IOException {
        HttpRoute httpRoute = routedRequest.getRoute();
        int n = 0;
        while (true) {
            ++n;
            try {
                if (!this.managedConn.isOpen()) {
                    this.managedConn.open(httpRoute, httpContext, this.params);
                } else {
                    this.managedConn.setSocketTimeout(HttpConnectionParams.getSoTimeout(this.params));
                }
                this.establishRoute(httpRoute, httpContext);
            }
            catch (IOException iOException) {
                try {
                    this.managedConn.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                if (this.retryHandler.retryRequest(iOException, n, httpContext)) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info("I/O exception (" + iOException.getClass().getName() + ") caught when connecting to the target host: " + iOException.getMessage());
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(iOException.getMessage(), iOException);
                    }
                    this.log.info("Retrying connect");
                    continue;
                }
                throw iOException;
            }
            break;
        }
    }

    private HttpResponse tryExecute(RoutedRequest routedRequest, HttpContext httpContext) throws HttpException, IOException {
        RequestWrapper requestWrapper = routedRequest.getRequest();
        HttpRoute httpRoute = routedRequest.getRoute();
        HttpResponse httpResponse = null;
        IOException iOException = null;
        while (true) {
            ++this.execCount;
            requestWrapper.incrementExecCount();
            if (!requestWrapper.isRepeatable()) {
                this.log.debug("Cannot retry non-repeatable request");
                if (iOException != null) {
                    throw new NonRepeatableRequestException("Cannot retry request with a non-repeatable request entity.  The cause lists the reason the original request failed.", iOException);
                }
                throw new NonRepeatableRequestException("Cannot retry request with a non-repeatable request entity.");
            }
            try {
                if (!this.managedConn.isOpen()) {
                    if (!httpRoute.isTunnelled()) {
                        this.log.debug("Reopening the direct connection.");
                        this.managedConn.open(httpRoute, httpContext, this.params);
                    } else {
                        this.log.debug("Proxied connection. Need to start over.");
                        break;
                    }
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Attempt " + this.execCount + " to execute request");
                }
                httpResponse = this.requestExec.execute(requestWrapper, this.managedConn, httpContext);
            }
            catch (IOException iOException2) {
                this.log.debug("Closing the connection.");
                try {
                    this.managedConn.close();
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
                if (this.retryHandler.retryRequest(iOException2, requestWrapper.getExecCount(), httpContext)) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info("I/O exception (" + iOException2.getClass().getName() + ") caught when processing request: " + iOException2.getMessage());
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(iOException2.getMessage(), iOException2);
                    }
                    this.log.info("Retrying request");
                    iOException = iOException2;
                    continue;
                }
                throw iOException2;
            }
            break;
        }
        return httpResponse;
    }

    protected void releaseConnection() {
        try {
            this.managedConn.releaseConnection();
        }
        catch (IOException iOException) {
            this.log.debug("IOException releasing connection", iOException);
        }
        this.managedConn = null;
    }

    protected HttpRoute determineRoute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws HttpException {
        if (httpHost == null) {
            httpHost = (HttpHost)httpRequest.getParams().getParameter("http.default-host");
        }
        if (httpHost == null) {
            throw new IllegalStateException("Target host must not be null, or set in parameters.");
        }
        return this.routePlanner.determineRoute(httpHost, httpRequest, httpContext);
    }

    protected void establishRoute(HttpRoute httpRoute, HttpContext httpContext) throws HttpException, IOException {
        int n;
        BasicRouteDirector basicRouteDirector = new BasicRouteDirector();
        do {
            HttpRoute httpRoute2 = this.managedConn.getRoute();
            n = basicRouteDirector.nextStep(httpRoute, httpRoute2);
            switch (n) {
                case 1: 
                case 2: {
                    this.managedConn.open(httpRoute, httpContext, this.params);
                    break;
                }
                case 3: {
                    int n2 = this.createTunnelToTarget(httpRoute, httpContext);
                    this.log.debug("Tunnel to target created.");
                    this.managedConn.tunnelTarget(n2 != 0, this.params);
                    break;
                }
                case 4: {
                    int n2 = httpRoute2.getHopCount() - 1;
                    boolean bl = this.createTunnelToProxy(httpRoute, n2, httpContext);
                    this.log.debug("Tunnel to proxy created.");
                    this.managedConn.tunnelProxy(httpRoute.getHopTarget(n2), bl, this.params);
                    break;
                }
                case 5: {
                    this.managedConn.layerProtocol(httpContext, this.params);
                    break;
                }
                case -1: {
                    throw new HttpException("Unable to establish route: planned = " + httpRoute + "; current = " + httpRoute2);
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown step indicator " + n + " from RouteDirector.");
                }
            }
        } while (n > 0);
    }

    protected boolean createTunnelToTarget(HttpRoute httpRoute, HttpContext httpContext) throws HttpException, IOException {
        int n;
        HttpHost httpHost = httpRoute.getProxyHost();
        HttpHost httpHost2 = httpRoute.getTargetHost();
        HttpResponse httpResponse = null;
        boolean bl = false;
        while (!bl) {
            bl = true;
            if (!this.managedConn.isOpen()) {
                this.managedConn.open(httpRoute, httpContext, this.params);
            }
            HttpRequest httpRequest = this.createConnectRequest(httpRoute, httpContext);
            httpRequest.setParams(this.params);
            httpContext.setAttribute("http.target_host", httpHost2);
            httpContext.setAttribute("http.proxy_host", httpHost);
            httpContext.setAttribute("http.connection", this.managedConn);
            httpContext.setAttribute("http.auth.target-scope", this.targetAuthState);
            httpContext.setAttribute("http.auth.proxy-scope", this.proxyAuthState);
            httpContext.setAttribute("http.request", httpRequest);
            this.requestExec.preProcess(httpRequest, this.httpProcessor, httpContext);
            httpResponse = this.requestExec.execute(httpRequest, this.managedConn, httpContext);
            httpResponse.setParams(this.params);
            this.requestExec.postProcess(httpResponse, this.httpProcessor, httpContext);
            int n2 = httpResponse.getStatusLine().getStatusCode();
            if (n2 < 200) {
                throw new HttpException("Unexpected response to CONNECT request: " + httpResponse.getStatusLine());
            }
            CredentialsProvider credentialsProvider = (CredentialsProvider)httpContext.getAttribute("http.auth.credentials-provider");
            if (credentialsProvider == null || !HttpClientParams.isAuthenticating(this.params)) continue;
            if (this.proxyAuthHandler.isAuthenticationRequested(httpResponse, httpContext)) {
                block9: {
                    this.log.debug("Proxy requested authentication");
                    Map<String, Header> map = this.proxyAuthHandler.getChallenges(httpResponse, httpContext);
                    try {
                        this.processChallenges(map, this.proxyAuthState, this.proxyAuthHandler, httpResponse, httpContext);
                    }
                    catch (AuthenticationException authenticationException) {
                        if (!this.log.isWarnEnabled()) break block9;
                        this.log.warn("Authentication error: " + authenticationException.getMessage());
                        break;
                    }
                }
                this.updateAuthState(this.proxyAuthState, httpHost, credentialsProvider);
                if (this.proxyAuthState.getCredentials() == null) continue;
                bl = false;
                if (this.reuseStrategy.keepAlive(httpResponse, httpContext)) {
                    this.log.debug("Connection kept alive");
                    HttpEntity httpEntity = httpResponse.getEntity();
                    EntityUtils.consume(httpEntity);
                    continue;
                }
                this.managedConn.close();
                continue;
            }
            this.proxyAuthState.setAuthScope(null);
        }
        if ((n = httpResponse.getStatusLine().getStatusCode()) > 299) {
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                httpResponse.setEntity(new BufferedHttpEntity(httpEntity));
            }
            this.managedConn.close();
            throw new TunnelRefusedException("CONNECT refused by proxy: " + httpResponse.getStatusLine(), httpResponse);
        }
        this.managedConn.markReusable();
        return false;
    }

    protected boolean createTunnelToProxy(HttpRoute httpRoute, int n, HttpContext httpContext) throws HttpException, IOException {
        throw new HttpException("Proxy chains are not supported.");
    }

    protected HttpRequest createConnectRequest(HttpRoute httpRoute, HttpContext httpContext) {
        Object object;
        HttpHost httpHost = httpRoute.getTargetHost();
        String string = httpHost.getHostName();
        int n = httpHost.getPort();
        if (n < 0) {
            object = this.connManager.getSchemeRegistry().getScheme(httpHost.getSchemeName());
            n = ((Scheme)object).getDefaultPort();
        }
        object = new StringBuilder(string.length() + 6);
        ((StringBuilder)object).append(string);
        ((StringBuilder)object).append(':');
        ((StringBuilder)object).append(Integer.toString(n));
        String string2 = ((StringBuilder)object).toString();
        ProtocolVersion protocolVersion = HttpProtocolParams.getVersion(this.params);
        BasicHttpRequest basicHttpRequest = new BasicHttpRequest("CONNECT", string2, protocolVersion);
        return basicHttpRequest;
    }

    protected RoutedRequest handleResponse(RoutedRequest routedRequest, HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        HttpRoute httpRoute = routedRequest.getRoute();
        RequestWrapper requestWrapper = routedRequest.getRequest();
        HttpParams httpParams = requestWrapper.getParams();
        if (HttpClientParams.isRedirecting(httpParams) && this.redirectStrategy.isRedirected(requestWrapper, httpResponse, httpContext)) {
            Object object;
            if (this.redirectCount >= this.maxRedirects) {
                throw new RedirectException("Maximum redirects (" + this.maxRedirects + ") exceeded");
            }
            ++this.redirectCount;
            this.virtualHost = null;
            HttpUriRequest httpUriRequest = this.redirectStrategy.getRedirect(requestWrapper, httpResponse, httpContext);
            HttpRequest httpRequest = requestWrapper.getOriginal();
            httpUriRequest.setHeaders(httpRequest.getAllHeaders());
            URI uRI = httpUriRequest.getURI();
            if (uRI.getHost() == null) {
                throw new ProtocolException("Redirect URI does not specify a valid host name: " + uRI);
            }
            HttpHost httpHost = new HttpHost(uRI.getHost(), uRI.getPort(), uRI.getScheme());
            this.targetAuthState.setAuthScope(null);
            this.proxyAuthState.setAuthScope(null);
            if (!httpRoute.getTargetHost().equals(httpHost)) {
                this.targetAuthState.invalidate();
                object = this.proxyAuthState.getAuthScheme();
                if (object != null && object.isConnectionBased()) {
                    this.proxyAuthState.invalidate();
                }
            }
            object = this.wrapRequest(httpUriRequest);
            ((AbstractHttpMessage)object).setParams(httpParams);
            HttpRoute httpRoute2 = this.determineRoute(httpHost, (HttpRequest)object, httpContext);
            RoutedRequest routedRequest2 = new RoutedRequest((RequestWrapper)object, httpRoute2);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Redirecting to '" + uRI + "' via " + httpRoute2);
            }
            return routedRequest2;
        }
        CredentialsProvider credentialsProvider = (CredentialsProvider)httpContext.getAttribute("http.auth.credentials-provider");
        if (credentialsProvider != null && HttpClientParams.isAuthenticating(httpParams)) {
            if (this.targetAuthHandler.isAuthenticationRequested(httpResponse, httpContext)) {
                HttpHost httpHost;
                block16: {
                    httpHost = (HttpHost)httpContext.getAttribute("http.target_host");
                    if (httpHost == null) {
                        httpHost = httpRoute.getTargetHost();
                    }
                    this.log.debug("Target requested authentication");
                    Map<String, Header> map = this.targetAuthHandler.getChallenges(httpResponse, httpContext);
                    try {
                        this.processChallenges(map, this.targetAuthState, this.targetAuthHandler, httpResponse, httpContext);
                    }
                    catch (AuthenticationException authenticationException) {
                        if (!this.log.isWarnEnabled()) break block16;
                        this.log.warn("Authentication error: " + authenticationException.getMessage());
                        return null;
                    }
                }
                this.updateAuthState(this.targetAuthState, httpHost, credentialsProvider);
                if (this.targetAuthState.getCredentials() != null) {
                    return routedRequest;
                }
                return null;
            }
            this.targetAuthState.setAuthScope(null);
            if (this.proxyAuthHandler.isAuthenticationRequested(httpResponse, httpContext)) {
                HttpHost httpHost;
                block17: {
                    httpHost = httpRoute.getProxyHost();
                    this.log.debug("Proxy requested authentication");
                    Map<String, Header> map = this.proxyAuthHandler.getChallenges(httpResponse, httpContext);
                    try {
                        this.processChallenges(map, this.proxyAuthState, this.proxyAuthHandler, httpResponse, httpContext);
                    }
                    catch (AuthenticationException authenticationException) {
                        if (!this.log.isWarnEnabled()) break block17;
                        this.log.warn("Authentication error: " + authenticationException.getMessage());
                        return null;
                    }
                }
                this.updateAuthState(this.proxyAuthState, httpHost, credentialsProvider);
                if (this.proxyAuthState.getCredentials() != null) {
                    return routedRequest;
                }
                return null;
            }
            this.proxyAuthState.setAuthScope(null);
        }
        return null;
    }

    private void abortConnection() {
        ManagedClientConnection managedClientConnection = this.managedConn;
        if (managedClientConnection != null) {
            block5: {
                this.managedConn = null;
                try {
                    managedClientConnection.abortConnection();
                }
                catch (IOException iOException) {
                    if (!this.log.isDebugEnabled()) break block5;
                    this.log.debug(iOException.getMessage(), iOException);
                }
            }
            try {
                managedClientConnection.releaseConnection();
            }
            catch (IOException iOException) {
                this.log.debug("Error releasing connection", iOException);
            }
        }
    }

    private void processChallenges(Map<String, Header> map, AuthState authState, AuthenticationHandler authenticationHandler, HttpResponse httpResponse, HttpContext httpContext) throws MalformedChallengeException, AuthenticationException {
        String string;
        Header header;
        AuthScheme authScheme = authState.getAuthScheme();
        if (authScheme == null) {
            authScheme = authenticationHandler.selectScheme(map, httpResponse, httpContext);
            authState.setAuthScheme(authScheme);
        }
        if ((header = map.get((string = authScheme.getSchemeName()).toLowerCase(Locale.ENGLISH))) == null) {
            throw new AuthenticationException(string + " authorization challenge expected, but not found");
        }
        authScheme.processChallenge(header);
        this.log.debug("Authorization challenge processed");
    }

    private void updateAuthState(AuthState authState, HttpHost httpHost, CredentialsProvider credentialsProvider) {
        Credentials credentials;
        Object object;
        if (!authState.isValid()) {
            return;
        }
        String string = httpHost.getHostName();
        int n = httpHost.getPort();
        if (n < 0) {
            object = this.connManager.getSchemeRegistry().getScheme(httpHost);
            n = ((Scheme)object).getDefaultPort();
        }
        object = authState.getAuthScheme();
        AuthScope authScope = new AuthScope(string, n, object.getRealm(), object.getSchemeName());
        if (this.log.isDebugEnabled()) {
            this.log.debug("Authentication scope: " + authScope);
        }
        if ((credentials = authState.getCredentials()) == null) {
            credentials = credentialsProvider.getCredentials(authScope);
            if (this.log.isDebugEnabled()) {
                if (credentials != null) {
                    this.log.debug("Found credentials");
                } else {
                    this.log.debug("Credentials not found");
                }
            }
        } else if (object.isComplete()) {
            this.log.debug("Authentication failed");
            credentials = null;
        }
        authState.setAuthScope(authScope);
        authState.setCredentials(credentials);
    }

    private void invalidateAuthIfSuccessful(AuthState authState) {
        AuthScheme authScheme = authState.getAuthScheme();
        if (authScheme != null && authScheme.isConnectionBased() && authScheme.isComplete() && authState.getCredentials() != null) {
            authState.invalidate();
        }
    }
}

