/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.conn.tsccm;

import ch.boye.httpclientandroidlib.androidextra.HttpClientAndroidLog;
import ch.boye.httpclientandroidlib.annotation.ThreadSafe;
import ch.boye.httpclientandroidlib.conn.ClientConnectionOperator;
import ch.boye.httpclientandroidlib.conn.ConnectionPoolTimeoutException;
import ch.boye.httpclientandroidlib.conn.OperatedClientConnection;
import ch.boye.httpclientandroidlib.conn.params.ConnManagerParams;
import ch.boye.httpclientandroidlib.conn.params.ConnPerRoute;
import ch.boye.httpclientandroidlib.conn.routing.HttpRoute;
import ch.boye.httpclientandroidlib.impl.conn.AbstractPoolEntry;
import ch.boye.httpclientandroidlib.impl.conn.tsccm.AbstractConnPool;
import ch.boye.httpclientandroidlib.impl.conn.tsccm.BasicPoolEntry;
import ch.boye.httpclientandroidlib.impl.conn.tsccm.PoolEntryRequest;
import ch.boye.httpclientandroidlib.impl.conn.tsccm.RouteSpecificPool;
import ch.boye.httpclientandroidlib.impl.conn.tsccm.WaitingThread;
import ch.boye.httpclientandroidlib.impl.conn.tsccm.WaitingThreadAborter;
import ch.boye.httpclientandroidlib.params.HttpParams;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ConnPoolByRoute
extends AbstractConnPool {
    public HttpClientAndroidLog log = new HttpClientAndroidLog(this.getClass());
    private final Lock poolLock;
    protected final ClientConnectionOperator operator;
    protected final ConnPerRoute connPerRoute;
    protected final Set<BasicPoolEntry> leasedConnections;
    protected final Queue<BasicPoolEntry> freeConnections;
    protected final Queue<WaitingThread> waitingThreads;
    protected final Map<HttpRoute, RouteSpecificPool> routeToPool;
    private final long connTTL;
    private final TimeUnit connTTLTimeUnit;
    protected volatile boolean shutdown;
    protected volatile int maxTotalConnections;
    protected volatile int numConnections;

    public ConnPoolByRoute(ClientConnectionOperator clientConnectionOperator, ConnPerRoute connPerRoute, int n) {
        this(clientConnectionOperator, connPerRoute, n, -1L, TimeUnit.MILLISECONDS);
    }

    public ConnPoolByRoute(ClientConnectionOperator clientConnectionOperator, ConnPerRoute connPerRoute, int n, long l, TimeUnit timeUnit) {
        if (clientConnectionOperator == null) {
            throw new IllegalArgumentException("Connection operator may not be null");
        }
        if (connPerRoute == null) {
            throw new IllegalArgumentException("Connections per route may not be null");
        }
        this.poolLock = ((AbstractConnPool)this).poolLock;
        this.leasedConnections = ((AbstractConnPool)this).leasedConnections;
        this.operator = clientConnectionOperator;
        this.connPerRoute = connPerRoute;
        this.maxTotalConnections = n;
        this.freeConnections = this.createFreeConnQueue();
        this.waitingThreads = this.createWaitingThreadQueue();
        this.routeToPool = this.createRouteToPoolMap();
        this.connTTL = l;
        this.connTTLTimeUnit = timeUnit;
    }

    protected Lock getLock() {
        return this.poolLock;
    }

    @Deprecated
    public ConnPoolByRoute(ClientConnectionOperator clientConnectionOperator, HttpParams httpParams) {
        this(clientConnectionOperator, ConnManagerParams.getMaxConnectionsPerRoute(httpParams), ConnManagerParams.getMaxTotalConnections(httpParams));
    }

    protected Queue<BasicPoolEntry> createFreeConnQueue() {
        return new LinkedList<BasicPoolEntry>();
    }

    protected Queue<WaitingThread> createWaitingThreadQueue() {
        return new LinkedList<WaitingThread>();
    }

    protected Map<HttpRoute, RouteSpecificPool> createRouteToPoolMap() {
        return new HashMap<HttpRoute, RouteSpecificPool>();
    }

    protected RouteSpecificPool newRouteSpecificPool(HttpRoute httpRoute) {
        return new RouteSpecificPool(httpRoute, this.connPerRoute);
    }

    protected WaitingThread newWaitingThread(Condition condition, RouteSpecificPool routeSpecificPool) {
        return new WaitingThread(condition, routeSpecificPool);
    }

    private void closeConnection(BasicPoolEntry basicPoolEntry) {
        OperatedClientConnection operatedClientConnection = basicPoolEntry.getConnection();
        if (operatedClientConnection != null) {
            try {
                operatedClientConnection.close();
            }
            catch (IOException iOException) {
                this.log.debug("I/O error closing connection", iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RouteSpecificPool getRoutePool(HttpRoute httpRoute, boolean bl) {
        RouteSpecificPool routeSpecificPool = null;
        this.poolLock.lock();
        try {
            routeSpecificPool = this.routeToPool.get(httpRoute);
            if (routeSpecificPool == null && bl) {
                routeSpecificPool = this.newRouteSpecificPool(httpRoute);
                this.routeToPool.put(httpRoute, routeSpecificPool);
            }
        }
        finally {
            this.poolLock.unlock();
        }
        return routeSpecificPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnectionsInPool(HttpRoute httpRoute) {
        this.poolLock.lock();
        try {
            RouteSpecificPool routeSpecificPool = this.getRoutePool(httpRoute, false);
            int n = routeSpecificPool != null ? routeSpecificPool.getEntryCount() : 0;
            return n;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnectionsInPool() {
        this.poolLock.lock();
        try {
            int n = this.numConnections;
            return n;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    @Override
    public PoolEntryRequest requestPoolEntry(final HttpRoute httpRoute, final Object object) {
        final WaitingThreadAborter waitingThreadAborter = new WaitingThreadAborter();
        return new PoolEntryRequest(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void abortRequest() {
                ConnPoolByRoute.this.poolLock.lock();
                try {
                    waitingThreadAborter.abort();
                }
                finally {
                    ConnPoolByRoute.this.poolLock.unlock();
                }
            }

            public BasicPoolEntry getPoolEntry(long l, TimeUnit timeUnit) throws InterruptedException, ConnectionPoolTimeoutException {
                return ConnPoolByRoute.this.getEntryBlocking(httpRoute, object, l, timeUnit, waitingThreadAborter);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BasicPoolEntry getEntryBlocking(HttpRoute httpRoute, Object object, long l, TimeUnit timeUnit, WaitingThreadAborter waitingThreadAborter) throws ConnectionPoolTimeoutException, InterruptedException {
        Date date = null;
        if (l > 0L) {
            date = new Date(System.currentTimeMillis() + timeUnit.toMillis(l));
        }
        BasicPoolEntry basicPoolEntry = null;
        this.poolLock.lock();
        try {
            RouteSpecificPool routeSpecificPool = this.getRoutePool(httpRoute, true);
            WaitingThread waitingThread = null;
            while (basicPoolEntry == null) {
                boolean bl;
                if (this.shutdown) {
                    throw new IllegalStateException("Connection pool shut down");
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("[" + httpRoute + "] total kept alive: " + this.freeConnections.size() + ", total issued: " + this.leasedConnections.size() + ", total allocated: " + this.numConnections + " out of " + this.maxTotalConnections);
                }
                if ((basicPoolEntry = this.getFreeEntry(routeSpecificPool, object)) != null) {
                    break;
                }
                boolean bl2 = bl = routeSpecificPool.getCapacity() > 0;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Available capacity: " + routeSpecificPool.getCapacity() + " out of " + routeSpecificPool.getMaxEntries() + " [" + httpRoute + "][" + object + "]");
                }
                if (bl && this.numConnections < this.maxTotalConnections) {
                    basicPoolEntry = this.createEntry(routeSpecificPool, this.operator);
                    continue;
                }
                if (bl && !this.freeConnections.isEmpty()) {
                    this.deleteLeastUsedEntry();
                    routeSpecificPool = this.getRoutePool(httpRoute, true);
                    basicPoolEntry = this.createEntry(routeSpecificPool, this.operator);
                    continue;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Need to wait for connection [" + httpRoute + "][" + object + "]");
                }
                if (waitingThread == null) {
                    waitingThread = this.newWaitingThread(this.poolLock.newCondition(), routeSpecificPool);
                    waitingThreadAborter.setWaitingThread(waitingThread);
                }
                boolean bl3 = false;
                try {
                    routeSpecificPool.queueThread(waitingThread);
                    this.waitingThreads.add(waitingThread);
                    bl3 = waitingThread.await(date);
                }
                finally {
                    routeSpecificPool.removeThread(waitingThread);
                    this.waitingThreads.remove(waitingThread);
                }
                if (bl3 || date == null || date.getTime() > System.currentTimeMillis()) continue;
                throw new ConnectionPoolTimeoutException("Timeout waiting for connection");
            }
        }
        finally {
            this.poolLock.unlock();
        }
        return basicPoolEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeEntry(BasicPoolEntry basicPoolEntry, boolean bl, long l, TimeUnit timeUnit) {
        HttpRoute httpRoute = basicPoolEntry.getPlannedRoute();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Releasing connection [" + httpRoute + "][" + basicPoolEntry.getState() + "]");
        }
        this.poolLock.lock();
        try {
            if (this.shutdown) {
                this.closeConnection(basicPoolEntry);
                return;
            }
            this.leasedConnections.remove(basicPoolEntry);
            RouteSpecificPool routeSpecificPool = this.getRoutePool(httpRoute, true);
            if (bl) {
                if (this.log.isDebugEnabled()) {
                    String string = l > 0L ? "for " + l + " " + (Object)((Object)timeUnit) : "indefinitely";
                    this.log.debug("Pooling connection [" + httpRoute + "][" + basicPoolEntry.getState() + "]; keep alive " + string);
                }
                routeSpecificPool.freeEntry(basicPoolEntry);
                basicPoolEntry.updateExpiry(l, timeUnit);
                this.freeConnections.add(basicPoolEntry);
            } else {
                routeSpecificPool.dropEntry();
                --this.numConnections;
            }
            this.notifyWaitingThread(routeSpecificPool);
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BasicPoolEntry getFreeEntry(RouteSpecificPool routeSpecificPool, Object object) {
        BasicPoolEntry basicPoolEntry = null;
        this.poolLock.lock();
        try {
            boolean bl = false;
            while (!bl) {
                basicPoolEntry = routeSpecificPool.allocEntry(object);
                if (basicPoolEntry != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Getting free connection [" + routeSpecificPool.getRoute() + "][" + object + "]");
                    }
                    this.freeConnections.remove(basicPoolEntry);
                    if (basicPoolEntry.isExpired(System.currentTimeMillis())) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Closing expired free connection [" + routeSpecificPool.getRoute() + "][" + object + "]");
                        }
                        this.closeConnection(basicPoolEntry);
                        routeSpecificPool.dropEntry();
                        --this.numConnections;
                        continue;
                    }
                    this.leasedConnections.add(basicPoolEntry);
                    bl = true;
                    continue;
                }
                bl = true;
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("No free connections [" + routeSpecificPool.getRoute() + "][" + object + "]");
            }
        }
        finally {
            this.poolLock.unlock();
        }
        return basicPoolEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BasicPoolEntry createEntry(RouteSpecificPool routeSpecificPool, ClientConnectionOperator clientConnectionOperator) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Creating new connection [" + routeSpecificPool.getRoute() + "]");
        }
        BasicPoolEntry basicPoolEntry = new BasicPoolEntry(clientConnectionOperator, routeSpecificPool.getRoute(), this.connTTL, this.connTTLTimeUnit);
        this.poolLock.lock();
        try {
            routeSpecificPool.createdEntry(basicPoolEntry);
            ++this.numConnections;
            this.leasedConnections.add(basicPoolEntry);
        }
        finally {
            this.poolLock.unlock();
        }
        return basicPoolEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteEntry(BasicPoolEntry basicPoolEntry) {
        HttpRoute httpRoute = basicPoolEntry.getPlannedRoute();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Deleting connection [" + httpRoute + "][" + basicPoolEntry.getState() + "]");
        }
        this.poolLock.lock();
        try {
            this.closeConnection(basicPoolEntry);
            RouteSpecificPool routeSpecificPool = this.getRoutePool(httpRoute, true);
            routeSpecificPool.deleteEntry(basicPoolEntry);
            --this.numConnections;
            if (routeSpecificPool.isUnused()) {
                this.routeToPool.remove(httpRoute);
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteLeastUsedEntry() {
        this.poolLock.lock();
        try {
            BasicPoolEntry basicPoolEntry = this.freeConnections.remove();
            if (basicPoolEntry != null) {
                this.deleteEntry(basicPoolEntry);
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("No free connection to delete");
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleLostEntry(HttpRoute httpRoute) {
        this.poolLock.lock();
        try {
            RouteSpecificPool routeSpecificPool = this.getRoutePool(httpRoute, true);
            routeSpecificPool.dropEntry();
            if (routeSpecificPool.isUnused()) {
                this.routeToPool.remove(httpRoute);
            }
            --this.numConnections;
            this.notifyWaitingThread(routeSpecificPool);
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyWaitingThread(RouteSpecificPool routeSpecificPool) {
        WaitingThread waitingThread = null;
        this.poolLock.lock();
        try {
            if (routeSpecificPool != null && routeSpecificPool.hasThread()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Notifying thread waiting on pool [" + routeSpecificPool.getRoute() + "]");
                }
                waitingThread = routeSpecificPool.nextThread();
            } else if (!this.waitingThreads.isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Notifying thread waiting on any pool");
                }
                waitingThread = this.waitingThreads.remove();
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("Notifying no-one, there are no waiting threads");
            }
            if (waitingThread != null) {
                waitingThread.wakeup();
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteClosedConnections() {
        this.poolLock.lock();
        try {
            Iterator iterator = this.freeConnections.iterator();
            while (iterator.hasNext()) {
                BasicPoolEntry basicPoolEntry = (BasicPoolEntry)iterator.next();
                if (basicPoolEntry.getConnection().isOpen()) continue;
                iterator.remove();
                this.deleteEntry(basicPoolEntry);
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeIdleConnections(long l, TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new IllegalArgumentException("Time unit must not be null.");
        }
        if (l < 0L) {
            l = 0L;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Closing connections idle longer than " + l + " " + (Object)((Object)timeUnit));
        }
        long l2 = System.currentTimeMillis() - timeUnit.toMillis(l);
        this.poolLock.lock();
        try {
            Iterator iterator = this.freeConnections.iterator();
            while (iterator.hasNext()) {
                BasicPoolEntry basicPoolEntry = (BasicPoolEntry)iterator.next();
                if (basicPoolEntry.getUpdated() > l2) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Closing connection last used @ " + new Date(basicPoolEntry.getUpdated()));
                }
                iterator.remove();
                this.deleteEntry(basicPoolEntry);
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeExpiredConnections() {
        this.log.debug("Closing expired connections");
        long l = System.currentTimeMillis();
        this.poolLock.lock();
        try {
            Iterator iterator = this.freeConnections.iterator();
            while (iterator.hasNext()) {
                BasicPoolEntry basicPoolEntry = (BasicPoolEntry)iterator.next();
                if (!basicPoolEntry.isExpired(l)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Closing connection expired @ " + new Date(basicPoolEntry.getExpiry()));
                }
                iterator.remove();
                this.deleteEntry(basicPoolEntry);
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.poolLock.lock();
        try {
            Object object;
            Object object2;
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
            Iterator<BasicPoolEntry> iterator = this.leasedConnections.iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                iterator.remove();
                this.closeConnection((BasicPoolEntry)object2);
            }
            object2 = this.freeConnections.iterator();
            while (object2.hasNext()) {
                object = (BasicPoolEntry)object2.next();
                object2.remove();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Closing connection [" + ((BasicPoolEntry)object).getPlannedRoute() + "][" + ((AbstractPoolEntry)object).getState() + "]");
                }
                this.closeConnection((BasicPoolEntry)object);
            }
            object = this.waitingThreads.iterator();
            while (object.hasNext()) {
                WaitingThread waitingThread = (WaitingThread)object.next();
                object.remove();
                waitingThread.wakeup();
            }
            this.routeToPool.clear();
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxTotalConnections(int n) {
        this.poolLock.lock();
        try {
            this.maxTotalConnections = n;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections;
    }
}

