/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.protocol;

import ch.boye.httpclientandroidlib.HttpException;
import ch.boye.httpclientandroidlib.HttpRequest;
import ch.boye.httpclientandroidlib.HttpRequestInterceptor;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.HttpResponseInterceptor;
import ch.boye.httpclientandroidlib.protocol.HttpContext;
import ch.boye.httpclientandroidlib.protocol.HttpProcessor;
import ch.boye.httpclientandroidlib.protocol.HttpRequestInterceptorList;
import ch.boye.httpclientandroidlib.protocol.HttpResponseInterceptorList;
import java.io.IOException;

public final class ImmutableHttpProcessor
implements HttpProcessor {
    private final HttpRequestInterceptor[] requestInterceptors;
    private final HttpResponseInterceptor[] responseInterceptors;

    public ImmutableHttpProcessor(HttpRequestInterceptor[] httpRequestInterceptorArray, HttpResponseInterceptor[] httpResponseInterceptorArray) {
        int n;
        int n2;
        if (httpRequestInterceptorArray != null) {
            n2 = httpRequestInterceptorArray.length;
            this.requestInterceptors = new HttpRequestInterceptor[n2];
            for (n = 0; n < n2; ++n) {
                this.requestInterceptors[n] = httpRequestInterceptorArray[n];
            }
        } else {
            this.requestInterceptors = new HttpRequestInterceptor[0];
        }
        if (httpResponseInterceptorArray != null) {
            n2 = httpResponseInterceptorArray.length;
            this.responseInterceptors = new HttpResponseInterceptor[n2];
            for (n = 0; n < n2; ++n) {
                this.responseInterceptors[n] = httpResponseInterceptorArray[n];
            }
        } else {
            this.responseInterceptors = new HttpResponseInterceptor[0];
        }
    }

    public ImmutableHttpProcessor(HttpRequestInterceptorList httpRequestInterceptorList, HttpResponseInterceptorList httpResponseInterceptorList) {
        int n;
        int n2;
        if (httpRequestInterceptorList != null) {
            n2 = httpRequestInterceptorList.getRequestInterceptorCount();
            this.requestInterceptors = new HttpRequestInterceptor[n2];
            for (n = 0; n < n2; ++n) {
                this.requestInterceptors[n] = httpRequestInterceptorList.getRequestInterceptor(n);
            }
        } else {
            this.requestInterceptors = new HttpRequestInterceptor[0];
        }
        if (httpResponseInterceptorList != null) {
            n2 = httpResponseInterceptorList.getResponseInterceptorCount();
            this.responseInterceptors = new HttpResponseInterceptor[n2];
            for (n = 0; n < n2; ++n) {
                this.responseInterceptors[n] = httpResponseInterceptorList.getResponseInterceptor(n);
            }
        } else {
            this.responseInterceptors = new HttpResponseInterceptor[0];
        }
    }

    public ImmutableHttpProcessor(HttpRequestInterceptor[] httpRequestInterceptorArray) {
        this(httpRequestInterceptorArray, null);
    }

    public ImmutableHttpProcessor(HttpResponseInterceptor[] httpResponseInterceptorArray) {
        this(null, httpResponseInterceptorArray);
    }

    public void process(HttpRequest httpRequest, HttpContext httpContext) throws IOException, HttpException {
        for (int i = 0; i < this.requestInterceptors.length; ++i) {
            this.requestInterceptors[i].process(httpRequest, httpContext);
        }
    }

    public void process(HttpResponse httpResponse, HttpContext httpContext) throws IOException, HttpException {
        for (int i = 0; i < this.responseInterceptors.length; ++i) {
            this.responseInterceptors[i].process(httpResponse, httpContext);
        }
    }
}

