/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.nfc.NfcAdapter;
import android.nfc.NfcEvent;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.ActionProvider;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.SubMenu;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.view.animation.Interpolator;
import android.widget.RelativeLayout;
import android.widget.Toast;
import android.widget.ViewFlipper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.EnumSet;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.AboutPages;
import org.mozilla.gecko.ActionModeCompat;
import org.mozilla.gecko.ActionModeCompatView;
import org.mozilla.gecko.DataReportingNotification;
import org.mozilla.gecko.Distribution;
import org.mozilla.gecko.EditBookmarkDialog;
import org.mozilla.gecko.FindInPageBar;
import org.mozilla.gecko.FirefoxAccountsHelper;
import org.mozilla.gecko.GeckoApp;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.GeckoThread;
import org.mozilla.gecko.JavaAddonManager;
import org.mozilla.gecko.MediaCastingBar;
import org.mozilla.gecko.MotionEventInterceptor;
import org.mozilla.gecko.NotificationClient;
import org.mozilla.gecko.OrderedBroadcastHelper;
import org.mozilla.gecko.PrefsHelper;
import org.mozilla.gecko.R;
import org.mozilla.gecko.ReaderModeUtils;
import org.mozilla.gecko.ServiceNotificationClient;
import org.mozilla.gecko.SharedPreferencesHelper;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.TabsPanel;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TouchEventInterceptor;
import org.mozilla.gecko.animation.PropertyAnimator;
import org.mozilla.gecko.animation.ViewHelper;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.favicons.OnFaviconLoadedListener;
import org.mozilla.gecko.favicons.decoders.IconDirectoryEntry;
import org.mozilla.gecko.gfx.BitmapUtils;
import org.mozilla.gecko.gfx.GeckoLayerClient;
import org.mozilla.gecko.gfx.ImmutableViewportMetrics;
import org.mozilla.gecko.gfx.LayerMarginsAnimator;
import org.mozilla.gecko.health.BrowserHealthReporter;
import org.mozilla.gecko.home.BrowserSearch;
import org.mozilla.gecko.home.HomePager;
import org.mozilla.gecko.home.SearchEngine;
import org.mozilla.gecko.menu.GeckoMenu;
import org.mozilla.gecko.preferences.GeckoPreferences;
import org.mozilla.gecko.prompts.Prompt;
import org.mozilla.gecko.toolbar.AutocompleteHandler;
import org.mozilla.gecko.toolbar.BrowserToolbar;
import org.mozilla.gecko.util.Clipboard;
import org.mozilla.gecko.util.GamepadUtils;
import org.mozilla.gecko.util.HardwareUtils;
import org.mozilla.gecko.util.StringUtils;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.util.UiAsyncTask;
import org.mozilla.gecko.widget.ButtonToast;
import org.mozilla.gecko.widget.GeckoActionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BrowserApp
extends GeckoApp
implements TabsPanel.TabsLayoutChangeListener,
PropertyAnimator.PropertyAnimationListener,
View.OnKeyListener,
GeckoLayerClient.OnMetricsChangedListener,
BrowserSearch.OnSearchListener,
BrowserSearch.OnEditSuggestionListener,
HomePager.OnNewTabsListener,
HomePager.OnUrlOpenListener,
ActionModeCompat.Presenter {
    private static final String LOGTAG = "GeckoBrowserApp";
    private static final String PREF_CHROME_DYNAMICTOOLBAR = "browser.chrome.dynamictoolbar";
    private static final int TABS_ANIMATION_DURATION = 450;
    private static final int READER_ADD_SUCCESS = 0;
    private static final int READER_ADD_FAILED = 1;
    private static final int READER_ADD_DUPLICATE = 2;
    private static final String ADD_SHORTCUT_TOAST = "add_shortcut_toast";
    public static final String GUEST_BROWSING_ARG = "--guest";
    private static final String STATE_ABOUT_HOME_TOP_PADDING = "abouthome_top_padding";
    private static final String STATE_DYNAMIC_TOOLBAR_ENABLED = "dynamic_toolbar";
    private static final String BROWSER_SEARCH_TAG = "browser_search";
    private BrowserSearch mBrowserSearch;
    private View mBrowserSearchContainer;
    public ViewFlipper mViewFlipper;
    public ActionModeCompatView mActionBar;
    private BrowserToolbar mBrowserToolbar;
    private HomePager mHomePager;
    private View mHomePagerContainer;
    protected Telemetry.Timer mAboutHomeStartupTimer = null;
    private ActionModeCompat mActionMode;
    private boolean mShowActionModeEndAnimation = false;
    private static final int GECKO_TOOLS_MENU = -1;
    private static final int ADDON_MENU_OFFSET = 1000;
    private Vector<MenuItemInfo> mAddonMenuItemsCache;
    private PropertyAnimator mMainLayoutAnimator;
    private static final Interpolator sTabsInterpolator = new Interpolator(){

        public float getInterpolation(float f) {
            return (f -= 1.0f) * f * f * f * f + 1.0f;
        }
    };
    private FindInPageBar mFindInPageBar;
    private MediaCastingBar mMediaCastingBar;
    private boolean mAccessibilityEnabled = false;
    private static final int FEEDBACK_LAUNCH_COUNT = 15;
    private boolean mDynamicToolbarEnabled = false;
    private int mToolbarHeight = 0;
    private boolean mDynamicToolbarCanScroll = false;
    private Integer mPrefObserverId;
    private SharedPreferencesHelper mSharedPreferencesHelper;
    private OrderedBroadcastHelper mOrderedBroadcastHelper;
    private FirefoxAccountsHelper mFirefoxAccountsHelper;
    private BrowserHealthReporter mBrowserHealthReporter;
    private Integer mTargetTabForEditingMode = null;
    private boolean mHideWebContentOnAnimationEnd = false;
    private static OnFaviconLoadedListener sFaviconLoadedListener = new OnFaviconLoadedListener(){

        public void onFaviconLoaded(String string2, String string3, Bitmap bitmap) {
            Tabs.getInstance().updateFaviconForURL(string2, bitmap == null ? Favicons.sDefaultFavicon : bitmap);
        }
    };

    @Override
    public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, Object object) {
        if (tab == null) {
            if (tabEvents != Tabs.TabEvents.RESTORED) {
                throw new IllegalArgumentException("onTabChanged:" + (Object)((Object)tabEvents) + " must specify a tab.");
            }
            return;
        }
        Log.d((String)LOGTAG, (String)("BrowserApp.onTabChanged: " + tab.getId() + ": " + (Object)((Object)tabEvents)));
        switch (tabEvents) {
            case LOCATION_CHANGE: {
                if (Tabs.getInstance().isSelectedTab(tab)) {
                    this.maybeCancelFaviconLoad(tab);
                }
            }
            case SELECTED: {
                if (!Tabs.getInstance().isSelectedTab(tab)) break;
                this.updateHomePagerForTab(tab);
                final TabsPanel.Panel panel = tab.isPrivate() ? TabsPanel.Panel.PRIVATE_TABS : TabsPanel.Panel.NORMAL_TABS;
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    public void run() {
                        if (BrowserApp.this.areTabsShown() && BrowserApp.this.mTabsPanel.getCurrentPanel() != panel) {
                            BrowserApp.this.showTabs(panel);
                        }
                    }
                });
                break;
            }
            case START: {
                if (!Tabs.getInstance().isSelectedTab(tab)) break;
                this.invalidateOptionsMenu();
                if (!this.isDynamicToolbarEnabled()) break;
                this.mLayerView.getLayerMarginsAnimator().showMargins(false);
                break;
            }
            case LOAD_ERROR: 
            case STOP: 
            case MENU_UPDATED: {
                if (!Tabs.getInstance().isSelectedTab(tab)) break;
                this.invalidateOptionsMenu();
                break;
            }
            case PAGE_SHOW: {
                this.loadFavicon(tab);
                break;
            }
            case LINK_FAVICON: {
                if (tab.getState() == 1) break;
                this.loadFavicon(tab);
            }
        }
        super.onTabChanged(tab, tabEvents, object);
    }

    public boolean onKey(View view, int n, KeyEvent keyEvent) {
        if (keyEvent.getAction() != 0) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 9 && (keyEvent.getSource() & 0x401) == 1025) {
            switch (n) {
                case 100: {
                    if (this.mViewFlipper.getVisibility() == 0) {
                        if (this.isDynamicToolbarEnabled() && !this.isHomePagerVisible()) {
                            if (this.mLayerView != null) {
                                this.mLayerView.getLayerMarginsAnimator().hideMargins(false);
                                this.mLayerView.requestFocus();
                            }
                        } else {
                            this.mBrowserToolbar.requestFocusFromTouch();
                        }
                    } else {
                        if (this.mLayerView != null) {
                            this.mLayerView.getLayerMarginsAnimator().showMargins(false);
                        }
                        this.mBrowserToolbar.requestFocusFromTouch();
                    }
                    return true;
                }
                case 102: {
                    Tabs.getInstance().getSelectedTab().doBack();
                    return true;
                }
                case 103: {
                    Tabs.getInstance().getSelectedTab().doForward();
                    return true;
                }
            }
        }
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (Build.VERSION.SDK_INT >= 11 && tab != null && keyEvent.isCtrlPressed()) {
            switch (n) {
                case 71: {
                    tab.doBack();
                    return true;
                }
                case 72: {
                    tab.doForward();
                    return true;
                }
                case 46: {
                    tab.doReload();
                    return true;
                }
                case 56: {
                    tab.doStop();
                    return true;
                }
                case 48: {
                    this.addTab();
                    return true;
                }
                case 51: {
                    Tabs.getInstance().closeTab(tab);
                    return true;
                }
                case 34: {
                    this.mFindInPageBar.show();
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        if (!this.mBrowserToolbar.isEditing() && this.onKey(null, n, keyEvent)) {
            return true;
        }
        if (this.mBrowserToolbar.onKey(n, keyEvent)) {
            return true;
        }
        return super.onKeyDown(n, keyEvent);
    }

    void handleReaderListCountRequest() {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            public void run() {
                int n = BrowserDB.getReadingListCount(BrowserApp.this.getContentResolver());
                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Reader:ListCountReturn", Integer.toString(n)));
            }
        });
    }

    void handleReaderListStatusRequest(final String string2) {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            public void run() {
                int n = BrowserDB.isReadingListItem(BrowserApp.this.getContentResolver(), string2) ? 1 : 0;
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("url", (Object)string2);
                    jSONObject.put("inReadingList", n);
                }
                catch (JSONException jSONException) {
                    Log.e((String)BrowserApp.LOGTAG, (String)"JSON error - failed to return inReadingList status", (Throwable)jSONException);
                    return;
                }
                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Reader:ListStatusReturn", jSONObject.toString()));
            }
        });
    }

    void handleReaderAdded(int n, final String string2, final String string3) {
        if (n != 0) {
            if (n == 1) {
                this.showToast(R.string.reading_list_failed, 0);
            } else if (n == 2) {
                this.showToast(R.string.reading_list_duplicate, 0);
            }
            return;
        }
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            public void run() {
                BrowserDB.addReadingListItem(BrowserApp.this.getContentResolver(), string2, string3);
                BrowserApp.this.showToast(R.string.reading_list_added, 0);
                int n = BrowserDB.getReadingListCount(BrowserApp.this.getContentResolver());
                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Reader:ListCountUpdated", Integer.toString(n)));
            }
        });
    }

    void handleReaderRemoved(final String string2) {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            public void run() {
                BrowserDB.removeReadingListItemWithURL(BrowserApp.this.getContentResolver(), string2);
                BrowserApp.this.showToast(R.string.reading_list_removed, 0);
                int n = BrowserDB.getReadingListCount(BrowserApp.this.getContentResolver());
                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Reader:ListCountUpdated", Integer.toString(n)));
            }
        });
    }

    @Override
    public void onCreate(Bundle bundle) {
        NfcAdapter nfcAdapter;
        this.mAboutHomeStartupTimer = new Telemetry.UptimeTimer("FENNEC_STARTUP_TIME_ABOUTHOME");
        Intent intent = this.getIntent();
        String string2 = intent.getStringExtra("args");
        if (string2 != null && string2.contains(GUEST_BROWSING_ARG)) {
            this.mProfile = GeckoProfile.createGuestProfile((Context)this);
        } else {
            GeckoProfile.maybeCleanupGuestProfile((Context)this);
        }
        super.onCreate(bundle);
        this.mViewFlipper = (ViewFlipper)this.findViewById(R.id.browser_actionbar);
        this.mActionBar = (ActionModeCompatView)this.findViewById(R.id.actionbar);
        this.mBrowserToolbar = (BrowserToolbar)this.findViewById(R.id.browser_toolbar);
        if ("android.intent.action.VIEW".equals(intent.getAction())) {
            this.mBrowserToolbar.setTitle(intent.getDataString());
        }
        ((GeckoApp.MainLayout)this.mMainLayout).setTouchEventInterceptor(new HideTabsTouchListener());
        ((GeckoApp.MainLayout)this.mMainLayout).setMotionEventInterceptor(new MotionEventInterceptor(){

            public boolean onInterceptMotionEvent(View view, MotionEvent motionEvent) {
                if (BrowserApp.this.mLayerView != null && !BrowserApp.this.mLayerView.hasFocus() && GamepadUtils.isPanningControl((MotionEvent)motionEvent)) {
                    if (BrowserApp.this.mHomePager == null) {
                        return false;
                    }
                    if (BrowserApp.this.isHomePagerVisible()) {
                        BrowserApp.this.mLayerView.requestFocus();
                    } else {
                        BrowserApp.this.mHomePager.requestFocus();
                    }
                }
                return false;
            }
        });
        this.mHomePagerContainer = this.findViewById(R.id.home_pager_container);
        this.mBrowserSearchContainer = this.findViewById(R.id.search_container);
        this.mBrowserSearch = (BrowserSearch)this.getSupportFragmentManager().findFragmentByTag(BROWSER_SEARCH_TAG);
        if (this.mBrowserSearch == null) {
            this.mBrowserSearch = BrowserSearch.newInstance();
            this.mBrowserSearch.setUserVisibleHint(false);
        }
        this.mBrowserToolbar.setOnActivateListener(new BrowserToolbar.OnActivateListener(){

            public void onActivate() {
                BrowserApp.this.enterEditingMode();
            }
        });
        this.mBrowserToolbar.setOnCommitListener(new BrowserToolbar.OnCommitListener(){

            public void onCommit() {
                BrowserApp.this.commitEditingMode();
            }
        });
        this.mBrowserToolbar.setOnDismissListener(new BrowserToolbar.OnDismissListener(){

            public void onDismiss() {
                BrowserApp.this.mBrowserToolbar.cancelEdit();
            }
        });
        this.mBrowserToolbar.setOnFilterListener(new BrowserToolbar.OnFilterListener(){

            public void onFilter(String string2, AutocompleteHandler autocompleteHandler) {
                BrowserApp.this.filterEditingMode(string2, autocompleteHandler);
            }
        });
        this.mBrowserToolbar.setOnStartEditingListener(new BrowserToolbar.OnStartEditingListener(){

            public void onStartEditing() {
                BrowserApp.this.mDoorHangerPopup.disable();
            }
        });
        this.mBrowserToolbar.setOnStopEditingListener(new BrowserToolbar.OnStopEditingListener(){

            public void onStopEditing() {
                BrowserApp.this.selectTargetTabForEditingMode();
                BrowserApp.this.hideBrowserSearch();
                BrowserApp.this.hideHomePager();
                BrowserApp.this.mDoorHangerPopup.enable();
            }
        });
        this.mBrowserToolbar.setOnKeyListener(this);
        if (this.mTabsPanel != null) {
            this.mTabsPanel.setTabsLayoutChangeListener(this);
            this.updateSideBarState();
        }
        this.mFindInPageBar = (FindInPageBar)this.findViewById(R.id.find_in_page);
        this.mMediaCastingBar = (MediaCastingBar)this.findViewById(R.id.media_casting);
        this.registerEventListener("CharEncoding:Data");
        this.registerEventListener("CharEncoding:State");
        this.registerEventListener("Feedback:LastUrl");
        this.registerEventListener("Feedback:OpenPlayStore");
        this.registerEventListener("Feedback:MaybeLater");
        this.registerEventListener("Telemetry:Gather");
        this.registerEventListener("Settings:Show");
        this.registerEventListener("Updater:Launch");
        Distribution.init((Context)this);
        JavaAddonManager.getInstance().init(this.getApplicationContext());
        this.mSharedPreferencesHelper = new SharedPreferencesHelper(this.getApplicationContext());
        this.mOrderedBroadcastHelper = new OrderedBroadcastHelper(this.getApplicationContext());
        this.mFirefoxAccountsHelper = new FirefoxAccountsHelper(this.getApplicationContext());
        this.mBrowserHealthReporter = new BrowserHealthReporter();
        if (Build.VERSION.SDK_INT >= 14 && (nfcAdapter = NfcAdapter.getDefaultAdapter((Context)this)) != null) {
            nfcAdapter.setNdefPushMessageCallback(new NfcAdapter.CreateNdefMessageCallback(){

                public NdefMessage createNdefMessage(NfcEvent nfcEvent) {
                    Tab tab = Tabs.getInstance().getSelectedTab();
                    if (tab == null || tab.isPrivate()) {
                        return null;
                    }
                    return new NdefMessage(new NdefRecord[]{NdefRecord.createUri((String)tab.getURL())});
                }
            }, (Activity)this, new Activity[0]);
        }
        if (bundle != null) {
            this.mDynamicToolbarEnabled = bundle.getBoolean(STATE_DYNAMIC_TOOLBAR_ENABLED);
            this.mHomePagerContainer.setPadding(0, bundle.getInt(STATE_ABOUT_HOME_TOP_PADDING), 0, 0);
        }
        this.mPrefObserverId = PrefsHelper.getPref(PREF_CHROME_DYNAMICTOOLBAR, new PrefsHelper.PrefHandlerBase(){

            public void prefValue(String string2, boolean bl) {
                if (bl == BrowserApp.this.mDynamicToolbarEnabled) {
                    return;
                }
                BrowserApp.this.mDynamicToolbarEnabled = bl;
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    public void run() {
                        if (!BrowserApp.this.mAccessibilityEnabled) {
                            BrowserApp.this.setDynamicToolbarEnabled(BrowserApp.this.mDynamicToolbarEnabled);
                        }
                    }
                });
            }

            public boolean isObserver() {
                return true;
            }
        });
        IconDirectoryEntry.setMaxBPP(GeckoAppShell.getScreenDepth());
    }

    @Override
    public void onBackPressed() {
        if (this.getSupportFragmentManager().getBackStackEntryCount() > 0) {
            super.onBackPressed();
            return;
        }
        if (this.mBrowserToolbar.onBackPressed()) {
            return;
        }
        if (this.mActionMode != null) {
            this.endActionModeCompat();
            return;
        }
        super.onBackPressed();
    }

    @Override
    public void onResume() {
        super.onResume();
        this.unregisterEventListener("Prompt:ShowTop");
    }

    @Override
    public void onPause() {
        super.onPause();
        this.registerEventListener("Prompt:ShowTop");
    }

    private void showBookmarkDialog() {
        final Tab tab = Tabs.getInstance().getSelectedTab();
        Prompt prompt = new Prompt((Context)this, new Prompt.PromptCallback(){

            public void onPromptFinished(String string2) {
                int n = -1;
                try {
                    n = new JSONObject(string2).getInt("button");
                }
                catch (JSONException jSONException) {
                    Log.e((String)BrowserApp.LOGTAG, (String)"Exception reading bookmark prompt result", (Throwable)jSONException);
                }
                if (tab == null) {
                    return;
                }
                if (n == 0) {
                    new EditBookmarkDialog((Context)BrowserApp.this).show(tab.getURL());
                } else if (n == 1) {
                    String string3 = tab.getURL();
                    String string4 = tab.getDisplayTitle();
                    Bitmap bitmap = tab.getFavicon();
                    if (string3 != null && string4 != null) {
                        GeckoAppShell.createShortcut(string4, string3, string3, bitmap, "");
                    }
                }
            }
        });
        Prompt.PromptListItem[] promptListItemArray = new Prompt.PromptListItem[2];
        Resources resources = this.getResources();
        promptListItemArray[0] = new Prompt.PromptListItem(resources.getString(R.string.contextmenu_edit_bookmark));
        promptListItemArray[1] = new Prompt.PromptListItem(resources.getString(R.string.contextmenu_add_to_launcher));
        prompt.show("", "", promptListItemArray, false);
    }

    private void setDynamicToolbarEnabled(boolean bl) {
        if (bl) {
            if (this.mLayerView != null) {
                this.mLayerView.getLayerClient().setOnMetricsChangedListener(this);
            }
            this.setToolbarMargin(0);
            this.mHomePagerContainer.setPadding(0, this.mViewFlipper.getHeight(), 0, 0);
        } else {
            if (this.mLayerView != null) {
                this.mLayerView.getLayerClient().setOnMetricsChangedListener(null);
            }
            this.mHomePagerContainer.setPadding(0, 0, 0, 0);
            if (this.mViewFlipper != null) {
                ViewHelper.setTranslationY((View)this.mViewFlipper, 0.0f);
            }
        }
        this.refreshToolbarHeight();
    }

    private boolean isDynamicToolbarEnabled() {
        return this.mDynamicToolbarEnabled && !this.mAccessibilityEnabled;
    }

    private static boolean isAboutHome(Tab tab) {
        return AboutPages.isAboutHome(tab.getURL());
    }

    public boolean onSearchRequested() {
        this.enterEditingMode();
        return true;
    }

    public boolean onContextItemSelected(MenuItem menuItem) {
        int n = menuItem.getItemId();
        if (n == R.id.pasteandgo) {
            String string2 = Clipboard.getText();
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                Tabs.getInstance().loadUrl(string2);
            }
            return true;
        }
        if (n == R.id.site_settings) {
            GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Permissions:Get", null));
            return true;
        }
        if (n == R.id.paste) {
            String string3 = Clipboard.getText();
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                this.enterEditingMode(string3);
            }
            return true;
        }
        if (n == R.id.share) {
            this.shareCurrentUrl();
            return true;
        }
        if (n == R.id.subscribe) {
            Tab tab = Tabs.getInstance().getSelectedTab();
            if (tab != null && tab.hasFeeds()) {
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("tabId", tab.getId());
                }
                catch (JSONException jSONException) {
                    Log.e((String)LOGTAG, (String)"error building json arguments");
                }
                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Feeds:Subscribe", jSONObject.toString()));
            }
            return true;
        }
        if (n == R.id.add_search_engine) {
            Tab tab = Tabs.getInstance().getSelectedTab();
            if (tab != null && tab.hasOpenSearch()) {
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("tabId", tab.getId());
                }
                catch (JSONException jSONException) {
                    Log.e((String)LOGTAG, (String)"error building json arguments");
                    return true;
                }
                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("SearchEngines:Add", jSONObject.toString()));
            }
            return true;
        }
        if (n == R.id.copyurl) {
            String string4;
            Tab tab = Tabs.getInstance().getSelectedTab();
            if (tab != null && (string4 = tab.getURL()) != null) {
                Clipboard.setText((CharSequence)string4);
            }
            return true;
        }
        if (n == R.id.add_to_launcher) {
            Tab tab = Tabs.getInstance().getSelectedTab();
            if (tab == null) {
                return true;
            }
            String string5 = tab.getURL();
            String string6 = tab.getDisplayTitle();
            if (string5 == null || string6 == null) {
                return true;
            }
            GeckoAppShell.CreateShortcutFaviconLoadedListener createShortcutFaviconLoadedListener = new GeckoAppShell.CreateShortcutFaviconLoadedListener(string5, string6);
            Favicons.getSizedFavicon(string5, tab.getFaviconURL(), Integer.MAX_VALUE, 1, createShortcutFaviconLoadedListener);
            return true;
        }
        return false;
    }

    @Override
    public void setAccessibilityEnabled(boolean bl) {
        if (this.mAccessibilityEnabled == bl) {
            return;
        }
        this.mAccessibilityEnabled = bl;
        if (this.mDynamicToolbarEnabled) {
            this.setDynamicToolbarEnabled(!bl);
        }
    }

    @Override
    public void onDestroy() {
        NfcAdapter nfcAdapter;
        if (this.mPrefObserverId != null) {
            PrefsHelper.removeObserver(this.mPrefObserverId);
            this.mPrefObserverId = null;
        }
        if (this.mBrowserToolbar != null) {
            this.mBrowserToolbar.onDestroy();
        }
        if (this.mFindInPageBar != null) {
            this.mFindInPageBar.onDestroy();
            this.mFindInPageBar = null;
        }
        if (this.mMediaCastingBar != null) {
            this.mMediaCastingBar.onDestroy();
            this.mMediaCastingBar = null;
        }
        if (this.mSharedPreferencesHelper != null) {
            this.mSharedPreferencesHelper.uninit();
            this.mSharedPreferencesHelper = null;
        }
        if (this.mOrderedBroadcastHelper != null) {
            this.mOrderedBroadcastHelper.uninit();
            this.mOrderedBroadcastHelper = null;
        }
        if (this.mFirefoxAccountsHelper != null) {
            this.mFirefoxAccountsHelper.uninit();
            this.mFirefoxAccountsHelper = null;
        }
        if (this.mBrowserHealthReporter != null) {
            this.mBrowserHealthReporter.uninit();
            this.mBrowserHealthReporter = null;
        }
        this.unregisterEventListener("CharEncoding:Data");
        this.unregisterEventListener("CharEncoding:State");
        this.unregisterEventListener("Feedback:LastUrl");
        this.unregisterEventListener("Feedback:OpenPlayStore");
        this.unregisterEventListener("Feedback:MaybeLater");
        this.unregisterEventListener("Telemetry:Gather");
        this.unregisterEventListener("Settings:Show");
        this.unregisterEventListener("Updater:Launch");
        if (Build.VERSION.SDK_INT >= 14 && (nfcAdapter = NfcAdapter.getDefaultAdapter((Context)this)) != null) {
            nfcAdapter.setNdefPushMessageCallback(null, (Activity)this, new Activity[0]);
        }
        super.onDestroy();
    }

    @Override
    protected void initializeChrome() {
        super.initializeChrome();
        this.mDoorHangerPopup.setAnchor(this.mBrowserToolbar.getDoorHangerAnchor());
        if (this.isDynamicToolbarEnabled()) {
            this.refreshToolbarHeight();
            this.mLayerView.getLayerMarginsAnimator().showMargins(true);
            this.mLayerView.getLayerClient().setOnMetricsChangedListener(this);
        }
        this.mLayerView.setOnKeyListener(this);
    }

    private void shareCurrentUrl() {
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (tab == null) {
            return;
        }
        String string2 = tab.getURL();
        if (string2 == null) {
            return;
        }
        if (AboutPages.isAboutReader(string2)) {
            string2 = ReaderModeUtils.getUrlFromAboutReader(string2);
        }
        GeckoAppShell.openUriExternal(string2, "text/plain", "", "", "android.intent.action.SEND", tab.getDisplayTitle());
    }

    @Override
    protected void loadStartupTab(String string2) {
        if (string2 != null || this.mShouldRestore) {
            this.mAboutHomeStartupTimer.cancel();
        }
        super.loadStartupTab(string2);
    }

    private void setToolbarMargin(int n) {
        ((RelativeLayout.LayoutParams)this.mGeckoLayout.getLayoutParams()).topMargin = n;
        this.mGeckoLayout.requestLayout();
    }

    @Override
    public void onMetricsChanged(ImmutableViewportMetrics immutableViewportMetrics) {
        if (this.isHomePagerVisible() || this.mViewFlipper == null) {
            return;
        }
        if (immutableViewportMetrics.getPageHeight() <= immutableViewportMetrics.getHeight()) {
            if (this.mDynamicToolbarCanScroll) {
                this.mDynamicToolbarCanScroll = false;
                if (this.mViewFlipper.getVisibility() != 0) {
                    ThreadUtils.postToUiThread((Runnable)new Runnable(){

                        public void run() {
                            BrowserApp.this.mLayerView.getLayerMarginsAnimator().showMargins(false);
                        }
                    });
                }
            }
        } else {
            this.mDynamicToolbarCanScroll = true;
        }
        ViewFlipper viewFlipper = this.mViewFlipper;
        int n = Math.round(immutableViewportMetrics.marginTop);
        ThreadUtils.postToUiThread((Runnable)new Runnable((View)viewFlipper, n){
            final /* synthetic */ View val$toolbarLayout;
            final /* synthetic */ int val$marginTop;
            {
                this.val$toolbarLayout = view;
                this.val$marginTop = n;
            }

            public void run() {
                ViewHelper.setTranslationY(this.val$toolbarLayout, this.val$marginTop - this.val$toolbarLayout.getHeight());
                if (BrowserApp.this.mDoorHangerPopup.isShowing()) {
                    BrowserApp.this.mDoorHangerPopup.updatePopup();
                }
            }
        });
        if (this.mFormAssistPopup != null) {
            this.mFormAssistPopup.onMetricsChanged(immutableViewportMetrics);
        }
    }

    @Override
    public void onPanZoomStopped() {
        if (!this.isDynamicToolbarEnabled() || this.isHomePagerVisible()) {
            return;
        }
        ImmutableViewportMetrics immutableViewportMetrics = this.mLayerView.getViewportMetrics();
        if (immutableViewportMetrics.getPageHeight() < immutableViewportMetrics.getHeight() || immutableViewportMetrics.marginTop >= (float)(this.mToolbarHeight / 2)) {
            this.mLayerView.getLayerMarginsAnimator().showMargins(false);
        } else {
            this.mLayerView.getLayerMarginsAnimator().hideMargins(false);
        }
    }

    public void refreshToolbarHeight() {
        int n = 0;
        if (this.mViewFlipper != null) {
            n = this.mViewFlipper.getHeight();
        }
        if (!this.isDynamicToolbarEnabled() || this.isHomePagerVisible()) {
            if (this.isDynamicToolbarEnabled()) {
                this.mHomePagerContainer.setPadding(0, n, 0, 0);
            } else {
                this.setToolbarMargin(n);
                n = 0;
            }
        } else {
            this.setToolbarMargin(0);
        }
        if (this.mLayerView != null && n != this.mToolbarHeight) {
            this.mToolbarHeight = n;
            this.mLayerView.getLayerMarginsAnimator().setMaxMargins(0.0f, n, 0.0f, 0.0f);
            this.mLayerView.getLayerMarginsAnimator().showMargins(true);
        }
    }

    @Override
    void toggleChrome(final boolean bl) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            public void run() {
                if (bl) {
                    BrowserApp.this.mViewFlipper.setVisibility(0);
                } else {
                    BrowserApp.this.mViewFlipper.setVisibility(8);
                    if (BrowserApp.this.hasTabsSideBar()) {
                        BrowserApp.this.hideTabs();
                    }
                }
            }
        });
        super.toggleChrome(bl);
    }

    @Override
    void focusChrome() {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            public void run() {
                BrowserApp.this.mViewFlipper.setVisibility(0);
                BrowserApp.this.mViewFlipper.requestFocusFromTouch();
            }
        });
    }

    @Override
    public void refreshChrome() {
        this.invalidateOptionsMenu();
        this.updateSideBarState();
        this.mTabsPanel.refresh();
        this.mBrowserToolbar.refresh();
    }

    @Override
    public boolean hasTabsSideBar() {
        return this.mTabsPanel != null && this.mTabsPanel.isSideBar();
    }

    private void updateSideBarState() {
        if (this.mMainLayoutAnimator != null) {
            this.mMainLayoutAnimator.stop();
        }
        boolean bl = HardwareUtils.isTablet() && mOrientation == 2;
        int n = this.getResources().getDimensionPixelSize(R.dimen.tabs_sidebar_width);
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)this.mTabsPanel.getLayoutParams();
        marginLayoutParams.width = bl ? n : -1;
        this.mTabsPanel.requestLayout();
        boolean bl2 = bl && this.mTabsPanel.isShown();
        int n2 = bl2 ? -n : 0;
        this.mMainLayout.scrollTo(n2, 0);
        this.mTabsPanel.setIsSideBar(bl);
    }

    @Override
    public void handleMessage(String string2, JSONObject jSONObject) {
        try {
            if (string2.equals("Menu:Add")) {
                MenuItemInfo menuItemInfo = new MenuItemInfo();
                menuItemInfo.label = jSONObject.getString("name");
                menuItemInfo.id = jSONObject.getInt("id") + 1000;
                menuItemInfo.icon = jSONObject.optString("icon", null);
                menuItemInfo.checked = jSONObject.optBoolean("checked", false);
                menuItemInfo.enabled = jSONObject.optBoolean("enabled", true);
                menuItemInfo.visible = jSONObject.optBoolean("visible", true);
                menuItemInfo.checkable = jSONObject.optBoolean("checkable", false);
                int n = jSONObject.optInt("parent", 0);
                menuItemInfo.parent = n <= 0 ? n : n + 1000;
                final MenuItemInfo menuItemInfo2 = menuItemInfo;
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    public void run() {
                        BrowserApp.this.addAddonMenuItem(menuItemInfo2);
                    }
                });
            } else if (string2.equals("Menu:Remove")) {
                final int n = jSONObject.getInt("id") + 1000;
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    public void run() {
                        BrowserApp.this.removeAddonMenuItem(n);
                    }
                });
            } else if (string2.equals("Menu:Update")) {
                final int n = jSONObject.getInt("id") + 1000;
                final JSONObject jSONObject2 = jSONObject.getJSONObject("options");
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    public void run() {
                        BrowserApp.this.updateAddonMenuItem(n, jSONObject2);
                    }
                });
            } else if (string2.equals("CharEncoding:Data")) {
                final JSONArray jSONArray = jSONObject.getJSONArray("charsets");
                int n = jSONObject.getInt("selected");
                int n2 = jSONArray.length();
                CharSequence[] charSequenceArray = new String[n2];
                for (int i = 0; i < n2; ++i) {
                    JSONObject jSONObject3 = jSONArray.getJSONObject(i);
                    charSequenceArray[i] = jSONObject3.getString("title");
                }
                final AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
                builder.setSingleChoiceItems(charSequenceArray, n, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n) {
                        try {
                            JSONObject jSONObject = jSONArray.getJSONObject(n);
                            GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("CharEncoding:Set", jSONObject.getString("code")));
                            dialogInterface.dismiss();
                        }
                        catch (JSONException jSONException) {
                            Log.e((String)BrowserApp.LOGTAG, (String)"error parsing json", (Throwable)jSONException);
                        }
                    }
                });
                builder.setNegativeButton(R.string.button_cancel, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n) {
                        dialogInterface.dismiss();
                    }
                });
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    public void run() {
                        builder.show();
                    }
                });
            } else if (string2.equals("CharEncoding:State")) {
                final boolean bl = jSONObject.getString("visible").equals("true");
                GeckoPreferences.setCharEncodingState(bl);
                final Menu menu2 = this.mMenu;
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    public void run() {
                        if (menu2 != null) {
                            menu2.findItem(R.id.char_encoding).setVisible(bl);
                        }
                    }
                });
            } else if (string2.equals("Feedback:OpenPlayStore")) {
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setData(Uri.parse((String)("market://details?id=" + this.getPackageName())));
                this.startActivity(intent);
            } else if (string2.equals("Feedback:MaybeLater")) {
                this.resetFeedbackLaunchCount();
            } else if (string2.equals("Feedback:LastUrl")) {
                this.getLastUrl();
            } else if (string2.equals("Gecko:Ready")) {
                super.handleMessage(string2, jSONObject);
                final Menu menu3 = this.mMenu;
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    public void run() {
                        if (menu3 != null) {
                            menu3.findItem(R.id.settings).setEnabled(true);
                        }
                    }
                });
                DataReportingNotification.checkAndNotifyPolicy(GeckoAppShell.getContext());
            } else if (string2.equals("Telemetry:Gather")) {
                Telemetry.HistogramAdd("PLACES_PAGES_COUNT", BrowserDB.getCount(this.getContentResolver(), "history"));
                Telemetry.HistogramAdd("PLACES_BOOKMARKS_COUNT", BrowserDB.getCount(this.getContentResolver(), "bookmarks"));
                Telemetry.HistogramAdd("FENNEC_FAVICONS_COUNT", BrowserDB.getCount(this.getContentResolver(), "favicons"));
                Telemetry.HistogramAdd("FENNEC_THUMBNAILS_COUNT", BrowserDB.getCount(this.getContentResolver(), "thumbnails"));
            } else if (string2.equals("Reader:ListCountRequest")) {
                this.handleReaderListCountRequest();
            } else if (string2.equals("Reader:ListStatusRequest")) {
                this.handleReaderListStatusRequest(jSONObject.getString("url"));
            } else if (string2.equals("Reader:Added")) {
                int n = jSONObject.getInt("result");
                String string3 = jSONObject.getString("title");
                String string4 = jSONObject.getString("url");
                this.handleReaderAdded(n, string3, string4);
            } else if (string2.equals("Reader:Removed")) {
                String string5 = jSONObject.getString("url");
                this.handleReaderRemoved(string5);
            } else if (string2.equals("Reader:Share")) {
                String string6 = jSONObject.getString("title");
                String string7 = jSONObject.getString("url");
                GeckoAppShell.openUriExternal(string7, "text/plain", "", "", "android.intent.action.SEND", string6);
            } else if (string2.equals("Settings:Show")) {
                String string8 = null;
                if (!jSONObject.isNull("resource")) {
                    string8 = jSONObject.getString("resource");
                }
                Intent intent = new Intent((Context)this, GeckoPreferences.class);
                GeckoPreferences.setResourceToOpen(intent, string8);
                this.startActivity(intent);
            } else if (string2.equals("Updater:Launch")) {
                this.handleUpdaterLaunch();
            } else if (string2.equals("Prompt:ShowTop")) {
                Intent intent = new Intent();
                intent.setClassName("org.mozilla.fennec", "org.mozilla.fennec.App");
                intent.setFlags(131072);
                this.startActivity(intent);
            } else {
                super.handleMessage(string2, jSONObject);
            }
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)("Exception handling message \"" + string2 + "\":"), (Throwable)exception);
        }
    }

    @Override
    public void addTab() {
        Tabs.getInstance().loadUrl("about:home", 1);
    }

    @Override
    public void addPrivateTab() {
        Tabs.getInstance().loadUrl("about:privatebrowsing", 5);
    }

    @Override
    public void showNormalTabs() {
        this.showTabs(TabsPanel.Panel.NORMAL_TABS);
    }

    @Override
    public void showPrivateTabs() {
        this.showTabs(TabsPanel.Panel.PRIVATE_TABS);
    }

    @Override
    public void showRemoteTabs() {
        this.showTabs(TabsPanel.Panel.REMOTE_TABS);
    }

    private void showTabs(TabsPanel.Panel panel) {
        if (Tabs.getInstance().getDisplayCount() == 0) {
            return;
        }
        this.mTabsPanel.show(panel);
    }

    @Override
    public void hideTabs() {
        this.mTabsPanel.hide();
    }

    @Override
    public boolean autoHideTabs() {
        if (this.areTabsShown()) {
            this.hideTabs();
            return true;
        }
        return false;
    }

    @Override
    public boolean areTabsShown() {
        return this.mTabsPanel.isShown();
    }

    @Override
    public void onTabsLayoutChange(int n, int n2) {
        int n3 = 450;
        if (this.mMainLayoutAnimator != null) {
            n3 = Math.max(1, n3 - (int)this.mMainLayoutAnimator.getRemainingTime());
            this.mMainLayoutAnimator.stop(false);
        }
        if (this.areTabsShown()) {
            this.mTabsPanel.setDescendantFocusability(262144);
        }
        this.mMainLayoutAnimator = new PropertyAnimator(n3, sTabsInterpolator);
        this.mMainLayoutAnimator.addPropertyAnimationListener(this);
        if (this.hasTabsSideBar()) {
            this.mMainLayoutAnimator.attach((View)this.mMainLayout, PropertyAnimator.Property.SCROLL_X, -n);
        } else {
            this.mMainLayoutAnimator.attach((View)this.mMainLayout, PropertyAnimator.Property.SCROLL_Y, -n2);
        }
        this.mTabsPanel.prepareTabsAnimation(this.mMainLayoutAnimator);
        this.mBrowserToolbar.prepareTabsAnimation(this.mMainLayoutAnimator, this.areTabsShown());
        if (this.mLayerView != null && this.isDynamicToolbarEnabled()) {
            if (n > 0 && n2 > 0) {
                this.mLayerView.getLayerMarginsAnimator().setMarginsPinned(true);
                this.mLayerView.getLayerMarginsAnimator().showMargins(false);
            } else {
                this.mLayerView.getLayerMarginsAnimator().setMarginsPinned(false);
            }
        }
        this.mMainLayoutAnimator.start();
    }

    @Override
    public void onPropertyAnimationStart() {
    }

    @Override
    public void onPropertyAnimationEnd() {
        if (!this.areTabsShown()) {
            this.mTabsPanel.setVisibility(4);
            this.mTabsPanel.setDescendantFocusability(393216);
        }
        this.mTabsPanel.finishTabsAnimation();
        this.mMainLayoutAnimator = null;
    }

    @Override
    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        this.mToast.onSaveInstanceState(bundle);
        bundle.putBoolean(STATE_DYNAMIC_TOOLBAR_ENABLED, this.mDynamicToolbarEnabled);
        bundle.putInt(STATE_ABOUT_HOME_TOP_PADDING, this.mHomePagerContainer.getPaddingTop());
    }

    private boolean maybeSwitchToTab(String string2, EnumSet<HomePager.OnUrlOpenListener.Flags> enumSet) {
        if (!enumSet.contains((Object)HomePager.OnUrlOpenListener.Flags.ALLOW_SWITCH_TO_TAB)) {
            return false;
        }
        Tabs tabs = Tabs.getInstance();
        int n = tabs.getTabIdForUrl(string2, tabs.getSelectedTab().isPrivate());
        if (n < 0) {
            return false;
        }
        this.mTargetTabForEditingMode = null;
        Tabs.getInstance().selectTab(n);
        this.mBrowserToolbar.cancelEdit();
        return true;
    }

    private void openUrlAndStopEditing(String string2) {
        this.openUrlAndStopEditing(string2, null, false);
    }

    private void openUrlAndStopEditing(String string2, boolean bl) {
        this.openUrlAndStopEditing(string2, null, bl);
    }

    private void openUrlAndStopEditing(String string2, String string3) {
        this.openUrlAndStopEditing(string2, string3, false);
    }

    private void openUrlAndStopEditing(String string2, String string3, boolean bl) {
        int n = 0;
        if (bl) {
            n |= 1;
        }
        Tabs.getInstance().loadUrl(string2, string3, -1, n);
        this.mBrowserToolbar.cancelEdit();
    }

    private boolean isHomePagerVisible() {
        return this.mHomePager != null && this.mHomePager.isVisible();
    }

    private void loadFavicon(Tab tab) {
        this.maybeCancelFaviconLoad(tab);
        int n = this.getResources().getDimensionPixelSize(R.dimen.browser_toolbar_favicon_size);
        int n2 = tab.isPrivate() || tab.getErrorType() != Tab.ErrorType.NONE ? 0 : 1;
        int n3 = Favicons.getSizedFavicon(tab.getURL(), tab.getFaviconURL(), n, n2, sFaviconLoadedListener);
        tab.setFaviconLoadId(n3);
    }

    private void maybeCancelFaviconLoad(Tab tab) {
        int n = tab.getFaviconLoadId();
        if (0 == n) {
            return;
        }
        Favicons.cancelFaviconLoad(n);
        tab.setFaviconLoadId(0);
    }

    private void enterEditingMode() {
        String string2 = "";
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (tab != null) {
            String string3 = tab.getUserSearch();
            string2 = TextUtils.isEmpty((CharSequence)string3) ? tab.getURL() : string3;
        }
        this.enterEditingMode(string2);
    }

    private void enterEditingMode(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("Cannot handle null URLs in enterEditingMode");
        }
        Tab tab = Tabs.getInstance().getSelectedTab();
        this.mTargetTabForEditingMode = tab != null ? Integer.valueOf(tab.getId()) : null;
        PropertyAnimator propertyAnimator = new PropertyAnimator(250L);
        propertyAnimator.setUseHardwareLayer(false);
        this.mBrowserToolbar.startEditing(string2, propertyAnimator);
        this.showHomePagerWithAnimator(propertyAnimator);
        propertyAnimator.start();
    }

    private void commitEditingMode() {
        if (!this.mBrowserToolbar.isEditing()) {
            return;
        }
        final String string2 = this.mBrowserToolbar.commitEdit();
        this.hideHomePager(string2);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        if (!StringUtils.isSearchQuery((String)string2, (boolean)true)) {
            Tabs.getInstance().loadUrl(string2, 2);
            return;
        }
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            public void run() {
                String string22;
                String string3;
                int n = string2.indexOf(" ");
                if (n == -1) {
                    string3 = string2;
                    string22 = "";
                } else {
                    string3 = string2.substring(0, n);
                    string22 = string2.substring(n + 1);
                }
                String string4 = BrowserDB.getUrlForKeyword(BrowserApp.this.getContentResolver(), string3);
                if (TextUtils.isEmpty((CharSequence)string4)) {
                    Tabs.getInstance().loadUrl(string2, 2);
                    return;
                }
                BrowserApp.recordSearch(null, "barkeyword");
                String string5 = string4.replace("%s", URLEncoder.encode(string22));
                Tabs.getInstance().loadUrl(string5, 2);
            }
        });
    }

    private static void recordSearch(SearchEngine searchEngine, String string2) {
        Log.i((String)LOGTAG, (String)("Recording search: " + (searchEngine == null ? "null" : searchEngine.name) + ", " + string2));
        try {
            String string3 = searchEngine == null ? "other" : searchEngine.getEngineIdentifier();
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("type", (Object)"Search:Event");
            jSONObject.put("location", (Object)string2);
            jSONObject.put("identifier", (Object)string3);
            GeckoAppShell.getEventDispatcher().dispatchEvent(jSONObject);
        }
        catch (Exception exception) {
            Log.w((String)LOGTAG, (String)"Error recording search.", (Throwable)exception);
        }
    }

    void filterEditingMode(String string2, AutocompleteHandler autocompleteHandler) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.hideBrowserSearch();
        } else {
            this.showBrowserSearch();
            this.mBrowserSearch.filter(string2, autocompleteHandler);
        }
    }

    private void selectTargetTabForEditingMode() {
        if (this.mTargetTabForEditingMode != null) {
            Tabs.getInstance().selectTab(this.mTargetTabForEditingMode);
        }
        this.mTargetTabForEditingMode = null;
    }

    private void updateHomePagerForTab(Tab tab) {
        if (this.mBrowserToolbar.isEditing()) {
            return;
        }
        if (BrowserApp.isAboutHome(tab)) {
            String string2 = AboutPages.getPageIdFromAboutHomeUrl(tab.getURL());
            this.showHomePager(string2);
            if (this.isDynamicToolbarEnabled()) {
                this.mLayerView.getLayerMarginsAnimator().showMargins(false);
            }
        } else {
            this.hideHomePager();
        }
    }

    @Override
    public void onLocaleReady(String string2) {
        super.onLocaleReady(string2);
        if (this.mHomePager != null) {
            this.mHomePager.invalidate(this.getSupportLoaderManager(), this.getSupportFragmentManager());
        }
        if (this.mMenu != null) {
            this.mMenu.clear();
            this.onCreateOptionsMenu(this.mMenu);
        }
    }

    private void showHomePager(String string2) {
        this.showHomePagerWithAnimator(string2, null);
    }

    private void showHomePagerWithAnimator(PropertyAnimator propertyAnimator) {
        this.showHomePagerWithAnimator(null, propertyAnimator);
    }

    private void showHomePagerWithAnimator(String string2, PropertyAnimator propertyAnimator) {
        if (this.isHomePagerVisible()) {
            return;
        }
        this.refreshToolbarHeight();
        if (this.isDynamicToolbarEnabled() && this.mLayerView != null) {
            this.mLayerView.getLayerMarginsAnimator().showMargins(true);
        }
        if (this.mHomePager == null) {
            ViewStub viewStub = (ViewStub)this.findViewById(R.id.home_pager_stub);
            this.mHomePager = (HomePager)viewStub.inflate();
        }
        this.mHomePager.show(this.getSupportLoaderManager(), this.getSupportFragmentManager(), string2, propertyAnimator);
        this.hideWebContentOnPropertyAnimationEnd(propertyAnimator);
    }

    private void hideWebContentOnPropertyAnimationEnd(PropertyAnimator propertyAnimator) {
        if (propertyAnimator == null) {
            this.hideWebContent();
            return;
        }
        propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

            public void onPropertyAnimationStart() {
                BrowserApp.this.mHideWebContentOnAnimationEnd = true;
            }

            public void onPropertyAnimationEnd() {
                if (BrowserApp.this.mHideWebContentOnAnimationEnd) {
                    BrowserApp.this.hideWebContent();
                }
            }
        });
    }

    private void hideWebContent() {
        this.mLayerView.setVisibility(4);
    }

    private void hideHomePager() {
        Tab tab = Tabs.getInstance().getSelectedTab();
        String string2 = tab != null ? tab.getURL() : null;
        this.hideHomePager(string2);
    }

    private void hideHomePager(String string2) {
        if (!this.isHomePagerVisible() || AboutPages.isAboutHome(string2)) {
            return;
        }
        this.mHideWebContentOnAnimationEnd = false;
        this.mLayerView.setVisibility(0);
        if (this.mHomePager != null) {
            this.mHomePager.hide();
        }
        this.mBrowserToolbar.setNextFocusDownId(R.id.layer_view);
        this.refreshToolbarHeight();
    }

    private void showBrowserSearch() {
        if (this.mBrowserSearch.getUserVisibleHint()) {
            return;
        }
        this.mBrowserSearchContainer.setVisibility(0);
        this.mHomePager.setVisibility(4);
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        fragmentManager.executePendingTransactions();
        fragmentManager.beginTransaction().add(R.id.search_container, (Fragment)this.mBrowserSearch, BROWSER_SEARCH_TAG).commitAllowingStateLoss();
        this.mBrowserSearch.setUserVisibleHint(true);
    }

    private void hideBrowserSearch() {
        if (!this.mBrowserSearch.getUserVisibleHint()) {
            return;
        }
        this.mHomePager.setVisibility(0);
        this.mBrowserSearchContainer.setVisibility(4);
        this.getSupportFragmentManager().beginTransaction().remove((Fragment)this.mBrowserSearch).commitAllowingStateLoss();
        this.mBrowserSearch.setUserVisibleHint(false);
    }

    private static Menu findParentMenu(Menu menu2, MenuItem menuItem) {
        int n = menuItem.getItemId();
        int n2 = menu2 != null ? menu2.size() : 0;
        for (int i = 0; i < n2; ++i) {
            Menu menu3;
            MenuItem menuItem2 = menu2.getItem(i);
            if (menuItem2.getItemId() == n) {
                return menu2;
            }
            if (!menuItem2.hasSubMenu() || (menu3 = BrowserApp.findParentMenu((Menu)menuItem2.getSubMenu(), menuItem)) == null) continue;
            return menu3;
        }
        return null;
    }

    private void addAddonMenuItemToMenu(Menu menu2, final MenuItemInfo menuItemInfo) {
        MenuItem menuItem;
        Menu menu3;
        menuItemInfo.added = true;
        if (menuItemInfo.parent == 0) {
            menu3 = menu2;
        } else if (menuItemInfo.parent == -1) {
            menuItem = menu2.findItem(R.id.tools);
            menu3 = menuItem != null ? menuItem.getSubMenu() : menu2;
        } else {
            menuItem = menu2.findItem(menuItemInfo.parent);
            if (menuItem == null) {
                return;
            }
            Menu menu4 = BrowserApp.findParentMenu(menu2, menuItem);
            if (!menuItem.hasSubMenu()) {
                menu4.removeItem(menuItem.getItemId());
                menu3 = menu4.addSubMenu(0, menuItem.getItemId(), 0, menuItem.getTitle());
                if (menuItem.getIcon() != null) {
                    ((SubMenu)menu3).getItem().setIcon(menuItem.getIcon());
                }
            } else {
                menu3 = menuItem.getSubMenu();
            }
        }
        menuItem = menu3.add(0, menuItemInfo.id, 0, (CharSequence)menuItemInfo.label);
        menuItem.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem menuItem) {
                Log.i((String)BrowserApp.LOGTAG, (String)"Menu item clicked");
                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Menu:Clicked", Integer.toString(menuItemInfo.id - 1000)));
                return true;
            }
        });
        if (menuItemInfo.icon == null) {
            menuItem.setIcon(R.drawable.ic_menu_addons_filler);
        } else {
            final int n = menuItemInfo.id;
            BitmapUtils.getDrawable((Context)this, menuItemInfo.icon, new BitmapUtils.BitmapLoader(){

                public void onBitmapFound(Drawable drawable2) {
                    MenuItem menuItem = menu3.findItem(n);
                    if (menuItem == null) {
                        return;
                    }
                    if (drawable2 == null) {
                        menuItem.setIcon(R.drawable.ic_menu_addons_filler);
                        return;
                    }
                    menuItem.setIcon(drawable2);
                }
            });
        }
        menuItem.setCheckable(menuItemInfo.checkable);
        menuItem.setChecked(menuItemInfo.checked);
        menuItem.setEnabled(menuItemInfo.enabled);
        menuItem.setVisible(menuItemInfo.visible);
    }

    private void addAddonMenuItem(MenuItemInfo menuItemInfo) {
        if (this.mAddonMenuItemsCache == null) {
            this.mAddonMenuItemsCache = new Vector();
        }
        menuItemInfo.added = this.mMenu != null;
        this.mAddonMenuItemsCache.add(menuItemInfo);
        if (this.mMenu == null) {
            return;
        }
        this.addAddonMenuItemToMenu(this.mMenu, menuItemInfo);
    }

    private void removeAddonMenuItem(int n) {
        if (this.mAddonMenuItemsCache != null && !this.mAddonMenuItemsCache.isEmpty()) {
            for (MenuItemInfo menuItemInfo : this.mAddonMenuItemsCache) {
                if (menuItemInfo.id != n) continue;
                this.mAddonMenuItemsCache.remove(menuItemInfo);
                break;
            }
        }
        if (this.mMenu == null) {
            return;
        }
        MenuItem menuItem = this.mMenu.findItem(n);
        if (menuItem != null) {
            this.mMenu.removeItem(n);
        }
    }

    private void updateAddonMenuItem(int n, JSONObject jSONObject) {
        if (this.mAddonMenuItemsCache != null && !this.mAddonMenuItemsCache.isEmpty()) {
            for (MenuItemInfo menuItemInfo : this.mAddonMenuItemsCache) {
                if (menuItemInfo.id != n) continue;
                menuItemInfo.label = jSONObject.optString("name", menuItemInfo.label);
                menuItemInfo.checkable = jSONObject.optBoolean("checkable", menuItemInfo.checkable);
                menuItemInfo.checked = jSONObject.optBoolean("checked", menuItemInfo.checked);
                menuItemInfo.enabled = jSONObject.optBoolean("enabled", menuItemInfo.enabled);
                menuItemInfo.visible = jSONObject.optBoolean("visible", menuItemInfo.visible);
                menuItemInfo.added = this.mMenu != null;
                break;
            }
        }
        if (this.mMenu == null) {
            return;
        }
        MenuItem menuItem = this.mMenu.findItem(n);
        if (menuItem != null) {
            menuItem.setTitle((CharSequence)jSONObject.optString("name", ((Object)menuItem.getTitle()).toString()));
            menuItem.setCheckable(jSONObject.optBoolean("checkable", menuItem.isCheckable()));
            menuItem.setChecked(jSONObject.optBoolean("checked", menuItem.isChecked()));
            menuItem.setEnabled(jSONObject.optBoolean("enabled", menuItem.isEnabled()));
            menuItem.setVisible(jSONObject.optBoolean("visible", menuItem.isVisible()));
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu2) {
        super.onCreateOptionsMenu(menu2);
        if (menu2 instanceof GeckoMenu && HardwareUtils.isTablet()) {
            ((GeckoMenu)menu2).setActionItemBarPresenter(this.mBrowserToolbar);
        }
        MenuInflater menuInflater = this.getMenuInflater();
        menuInflater.inflate(R.menu.browser_app_menu, this.mMenu);
        if (this.mAddonMenuItemsCache != null && !this.mAddonMenuItemsCache.isEmpty()) {
            for (MenuItemInfo object : this.mAddonMenuItemsCache) {
                this.addAddonMenuItemToMenu(this.mMenu, object);
            }
        }
        if (Build.VERSION.SDK_INT >= 14) {
            MenuItem menuItem = this.mMenu.findItem(R.id.share);
            GeckoActionProvider geckoActionProvider = new GeckoActionProvider((Context)this);
            menuItem.setActionProvider((ActionProvider)geckoActionProvider);
        }
        return true;
    }

    public void openOptionsMenu() {
        if (!this.hasTabsSideBar() && this.areTabsShown() || this.mBrowserToolbar.isEditing()) {
            return;
        }
        if (this.mMenuPanel != null) {
            this.mMenuPanel.scrollTo(0, 0);
        }
        if (!this.mBrowserToolbar.openOptionsMenu()) {
            super.openOptionsMenu();
        }
        if (this.isDynamicToolbarEnabled() && this.mLayerView != null) {
            this.mLayerView.getLayerMarginsAnimator().showMargins(false);
        }
    }

    public void closeOptionsMenu() {
        if (!this.mBrowserToolbar.closeOptionsMenu()) {
            super.closeOptionsMenu();
        }
    }

    @Override
    public void setFullScreen(final boolean bl) {
        super.setFullScreen(bl);
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            public void run() {
                if (bl) {
                    BrowserApp.this.mViewFlipper.setVisibility(8);
                    if (BrowserApp.this.isDynamicToolbarEnabled()) {
                        BrowserApp.this.mLayerView.getLayerMarginsAnimator().hideMargins(true);
                        BrowserApp.this.mLayerView.getLayerMarginsAnimator().setMaxMargins(0.0f, 0.0f, 0.0f, 0.0f);
                    } else {
                        BrowserApp.this.setToolbarMargin(0);
                    }
                } else {
                    BrowserApp.this.mViewFlipper.setVisibility(0);
                    if (BrowserApp.this.isDynamicToolbarEnabled()) {
                        BrowserApp.this.mLayerView.getLayerMarginsAnimator().showMargins(true);
                        BrowserApp.this.mLayerView.getLayerMarginsAnimator().setMaxMargins(0.0f, BrowserApp.this.mToolbarHeight, 0.0f, 0.0f);
                    }
                }
            }
        });
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        GeckoActionProvider geckoActionProvider;
        String string2;
        if (menu2 == null) {
            return false;
        }
        if (!GeckoThread.checkLaunchState(GeckoThread.LaunchState.GeckoRunning)) {
            menu2.findItem(R.id.settings).setEnabled(false);
        }
        Tab tab = Tabs.getInstance().getSelectedTab();
        MenuItem menuItem = menu2.findItem(R.id.bookmark);
        MenuItem menuItem2 = menu2.findItem(R.id.back);
        MenuItem menuItem3 = menu2.findItem(R.id.forward);
        MenuItem menuItem4 = menu2.findItem(R.id.share);
        MenuItem menuItem5 = menu2.findItem(R.id.save_as_pdf);
        MenuItem menuItem6 = menu2.findItem(R.id.char_encoding);
        MenuItem menuItem7 = menu2.findItem(R.id.find_in_page);
        MenuItem menuItem8 = menu2.findItem(R.id.desktop_mode);
        MenuItem menuItem9 = menu2.findItem(R.id.new_guest_session);
        MenuItem menuItem10 = menu2.findItem(R.id.exit_guest_session);
        menu2.findItem(R.id.quit).setVisible(Build.VERSION.SDK_INT < 14 || HardwareUtils.isTelevision());
        if (tab == null || tab.getURL() == null) {
            menuItem.setEnabled(false);
            menuItem2.setEnabled(false);
            menuItem3.setEnabled(false);
            menuItem4.setEnabled(false);
            menuItem5.setEnabled(false);
            menuItem7.setEnabled(false);
            return true;
        }
        menuItem.setEnabled(!AboutPages.isAboutReader(tab.getURL()));
        menuItem.setCheckable(true);
        menuItem.setChecked(tab.isBookmark());
        menuItem.setIcon(tab.isBookmark() ? R.drawable.ic_menu_bookmark_remove : R.drawable.ic_menu_bookmark_add);
        menuItem2.setEnabled(tab.canDoBack());
        menuItem3.setEnabled(tab.canDoForward());
        menuItem8.setChecked(tab.getDesktopMode());
        menuItem8.setIcon(tab.getDesktopMode() ? R.drawable.ic_menu_desktop_mode_on : R.drawable.ic_menu_desktop_mode_off);
        String string3 = tab.getURL();
        if (AboutPages.isAboutReader(string3) && (string2 = ReaderModeUtils.getUrlFromAboutReader(string3)) != null) {
            string3 = string2;
        }
        string2 = Uri.parse((String)string3).getScheme();
        menuItem4.setVisible(!GeckoProfile.get((Context)this).inGuestMode());
        menuItem4.setEnabled(!string2.equals("about") && !string2.equals("chrome") && !string2.equals("file") && !string2.equals("resource"));
        if (Build.VERSION.SDK_INT >= 14 && (geckoActionProvider = (GeckoActionProvider)menuItem4.getActionProvider()) != null) {
            Intent intent = geckoActionProvider.getIntent();
            if (intent == null) {
                intent = new Intent("android.intent.action.SEND");
                intent.setType("text/plain");
                geckoActionProvider.setIntent(intent);
            }
            intent.putExtra("android.intent.extra.TEXT", string3);
            intent.putExtra("android.intent.extra.SUBJECT", tab.getDisplayTitle());
            intent.putExtra("android.intent.extra.TITLE", tab.getDisplayTitle());
            intent.removeExtra("share_screenshot_uri");
            BitmapDrawable bitmapDrawable = tab.getThumbnail();
            if (bitmapDrawable != null) {
                File file;
                Bitmap bitmap = bitmapDrawable.getBitmap();
                if (Build.MANUFACTURER.equals("Kobo") && bitmap != null && (file = this.getExternalCacheDir()) != null) {
                    File file2 = new File(file, "thumbnail.png");
                    try {
                        FileOutputStream fileOutputStream = new FileOutputStream(file2);
                        bitmap.compress(Bitmap.CompressFormat.PNG, 90, (OutputStream)fileOutputStream);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        Log.e((String)LOGTAG, (String)"File not found", (Throwable)fileNotFoundException);
                    }
                    intent.putExtra("share_screenshot_uri", (Parcelable)Uri.parse((String)file2.getPath()));
                }
            }
        }
        menuItem5.setEnabled(!BrowserApp.isAboutHome(tab) && !tab.getContentType().equals("application/vnd.mozilla.xul+xml"));
        menuItem7.setEnabled(!BrowserApp.isAboutHome(tab));
        menuItem6.setVisible(GeckoPreferences.getCharEncodingState());
        if (this.mProfile.inGuestMode()) {
            menuItem10.setVisible(true);
        } else {
            menuItem9.setVisible(true);
        }
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        Tab tab = null;
        Intent intent = null;
        int n = menuItem.getItemId();
        if (n == R.id.bookmark) {
            tab = Tabs.getInstance().getSelectedTab();
            if (tab != null) {
                if (menuItem.isChecked()) {
                    tab.removeBookmark();
                    Toast.makeText((Context)this, (int)R.string.bookmark_removed, (int)0).show();
                    menuItem.setIcon(R.drawable.ic_menu_bookmark_add);
                } else {
                    tab.addBookmark();
                    this.mToast.show(false, this.getResources().getString(R.string.bookmark_added), this.getResources().getString(R.string.bookmark_options), null, new ButtonToast.ToastListener(){

                        public void onButtonClicked() {
                            BrowserApp.this.showBookmarkDialog();
                        }

                        public void onToastHidden(ButtonToast.ReasonHidden reasonHidden) {
                        }
                    });
                    menuItem.setIcon(R.drawable.ic_menu_bookmark_remove);
                }
            }
            return true;
        }
        if (n == R.id.share) {
            this.shareCurrentUrl();
            return true;
        }
        if (n == R.id.reload) {
            tab = Tabs.getInstance().getSelectedTab();
            if (tab != null) {
                tab.doReload();
            }
            return true;
        }
        if (n == R.id.back) {
            tab = Tabs.getInstance().getSelectedTab();
            if (tab != null) {
                tab.doBack();
            }
            return true;
        }
        if (n == R.id.forward) {
            tab = Tabs.getInstance().getSelectedTab();
            if (tab != null) {
                tab.doForward();
            }
            return true;
        }
        if (n == R.id.save_as_pdf) {
            GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("SaveAs:PDF", null));
            return true;
        }
        if (n == R.id.settings) {
            intent = new Intent((Context)this, GeckoPreferences.class);
            this.startActivity(intent);
            return true;
        }
        if (n == R.id.addons) {
            Tabs.getInstance().loadUrlInTab("about:addons");
            return true;
        }
        if (n == R.id.apps) {
            Tabs.getInstance().loadUrlInTab("about:apps");
            return true;
        }
        if (n == R.id.downloads) {
            Tabs.getInstance().loadUrlInTab("about:downloads");
            return true;
        }
        if (n == R.id.char_encoding) {
            GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("CharEncoding:Get", null));
            return true;
        }
        if (n == R.id.find_in_page) {
            this.mFindInPageBar.show();
            return true;
        }
        if (n == R.id.desktop_mode) {
            Tab tab2 = Tabs.getInstance().getSelectedTab();
            if (tab2 == null) {
                return true;
            }
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("desktopMode", !menuItem.isChecked());
                jSONObject.put("tabId", tab2.getId());
            }
            catch (JSONException jSONException) {
                Log.e((String)LOGTAG, (String)"error building json arguments");
            }
            GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("DesktopMode:Change", jSONObject.toString()));
            return true;
        }
        if (n == R.id.new_tab) {
            this.addTab();
            return true;
        }
        if (n == R.id.new_private_tab) {
            this.addPrivateTab();
            return true;
        }
        if (n == R.id.new_guest_session) {
            this.showGuestModeDialog(GuestModeDialog.ENTERING);
            return true;
        }
        if (n == R.id.exit_guest_session) {
            this.showGuestModeDialog(GuestModeDialog.LEAVING);
            return true;
        }
        return super.onOptionsItemSelected(menuItem);
    }

    private void showGuestModeDialog(final GuestModeDialog guestModeDialog) {
        Prompt prompt = new Prompt((Context)this, new Prompt.PromptCallback(){

            public void onPromptFinished(String string2) {
                try {
                    int n = new JSONObject(string2).getInt("button");
                    if (n == 0) {
                        String string3 = "";
                        if (guestModeDialog == GuestModeDialog.ENTERING) {
                            string3 = BrowserApp.GUEST_BROWSING_ARG;
                        } else {
                            GeckoProfile.leaveGuestSession((Context)BrowserApp.this);
                        }
                        BrowserApp.this.doRestart(string3);
                        System.exit(0);
                    }
                }
                catch (JSONException jSONException) {
                    Log.e((String)BrowserApp.LOGTAG, (String)"Exception reading guest mode prompt result", (Throwable)jSONException);
                }
            }
        });
        Resources resources = this.getResources();
        prompt.setButtons(new String[]{resources.getString(R.string.guest_session_dialog_continue), resources.getString(R.string.guest_session_dialog_cancel)});
        int n = 0;
        int n2 = 0;
        if (guestModeDialog == GuestModeDialog.ENTERING) {
            n = R.string.new_guest_session_title;
            n2 = R.string.new_guest_session_text;
        } else {
            n = R.string.exit_guest_session_title;
            n2 = R.string.exit_guest_session_text;
        }
        prompt.show(resources.getString(n), resources.getString(n2), null, false);
    }

    public boolean onKeyLongPress(int n, KeyEvent keyEvent) {
        Tab tab;
        if (n == 4 && (tab = Tabs.getInstance().getSelectedTab()) != null) {
            return tab.showAllHistory();
        }
        return super.onKeyLongPress(n, keyEvent);
    }

    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        String string2 = intent.getAction();
        if (Build.VERSION.SDK_INT >= 10 && "android.nfc.action.NDEF_DISCOVERED".equals(string2)) {
            String string3 = intent.getDataString();
            GeckoAppShell.sendEventToGecko(GeckoEvent.createURILoadEvent(string3));
        }
        if (!this.mInitialized) {
            return;
        }
        if ("android.intent.action.VIEW".equals(string2)) {
            this.mBrowserToolbar.cancelEdit();
            return;
        }
        if (!"android.intent.action.MAIN".equals(string2)) {
            return;
        }
        new UiAsyncTask<Void, Void, Boolean>(ThreadUtils.getBackgroundHandler()){

            public synchronized Boolean doInBackground(Void ... voidArray) {
                String string2;
                SharedPreferences sharedPreferences = BrowserApp.this.getPreferences(0);
                int n = sharedPreferences.getInt(string2 = BrowserApp.this.getPackageName() + ".feedback_launch_count", 0);
                if (n >= 15) {
                    return false;
                }
                sharedPreferences.edit().putInt(string2, ++n).commit();
                return n == 15;
            }

            public void onPostExecute(Boolean bl) {
                if (bl.booleanValue()) {
                    GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Feedback:Show", null));
                }
            }
        }.execute((Object[])new Void[0]);
    }

    @Override
    protected NotificationClient makeNotificationClient() {
        return new ServiceNotificationClient(this.getApplicationContext());
    }

    private void resetFeedbackLaunchCount() {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            public synchronized void run() {
                SharedPreferences sharedPreferences = BrowserApp.this.getPreferences(0);
                sharedPreferences.edit().putInt(BrowserApp.this.getPackageName() + ".feedback_launch_count", 0).commit();
            }
        });
    }

    private void getLastUrl() {
        new UiAsyncTask<Void, Void, String>(ThreadUtils.getBackgroundHandler()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized String doInBackground(Void ... voidArray) {
                String string2 = "";
                Cursor cursor = null;
                try {
                    cursor = BrowserDB.getRecentHistory(BrowserApp.this.getContentResolver(), 1);
                    if (cursor.moveToFirst()) {
                        string2 = cursor.getString(cursor.getColumnIndexOrThrow("url"));
                    }
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                return string2;
            }

            public void onPostExecute(String string2) {
                if (string2.length() > 0) {
                    GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Feedback:LastUrl", string2));
                }
            }
        }.execute((Object[])new Void[0]);
    }

    @Override
    public void onNewTabs(String[] stringArray) {
        EnumSet<HomePager.OnUrlOpenListener.Flags> enumSet = EnumSet.of(HomePager.OnUrlOpenListener.Flags.ALLOW_SWITCH_TO_TAB);
        for (String string2 : stringArray) {
            if (this.maybeSwitchToTab(string2, enumSet)) continue;
            this.openUrlAndStopEditing(string2, true);
        }
    }

    @Override
    public void onUrlOpen(String string2, EnumSet<HomePager.OnUrlOpenListener.Flags> enumSet) {
        if (!this.maybeSwitchToTab(string2, enumSet)) {
            this.openUrlAndStopEditing(string2);
        }
    }

    @Override
    public void onSearch(SearchEngine searchEngine, String string2) {
        BrowserApp.recordSearch(searchEngine, "barsuggest");
        this.openUrlAndStopEditing(string2, searchEngine.name);
    }

    @Override
    public void onEditSuggestion(String string2) {
        this.mBrowserToolbar.onEditSuggestion(string2);
    }

    @Override
    public int getLayout() {
        return R.layout.gecko_app;
    }

    @Override
    protected String getDefaultProfileName() {
        String string2 = GeckoProfile.findDefaultProfile((Context)this);
        return string2 != null ? string2 : "default";
    }

    protected boolean handleUpdaterLaunch() {
        Tabs.getInstance().loadUrlInTab("about:");
        return true;
    }

    @Override
    public void startActionModeCompat(ActionModeCompat.Callback callback) {
        if (this.mActionMode == null) {
            this.mViewFlipper.showNext();
            LayerMarginsAnimator layerMarginsAnimator = this.mLayerView.getLayerMarginsAnimator();
            if (this.isDynamicToolbarEnabled() && !layerMarginsAnimator.areMarginsShown()) {
                layerMarginsAnimator.setMaxMargins(0.0f, this.mViewFlipper.getHeight(), 0.0f, 0.0f);
                layerMarginsAnimator.showMargins(false);
                this.mShowActionModeEndAnimation = true;
            } else {
                this.mActionBar.animateIn();
            }
            layerMarginsAnimator.setMarginsPinned(true);
        } else {
            this.mActionMode.finish();
        }
        this.mActionMode = new ActionModeCompat(this, callback, this.mActionBar);
        if (callback.onCreateActionMode(this.mActionMode, this.mActionMode.getMenu())) {
            this.mActionMode.invalidate();
        }
    }

    @Override
    public void endActionModeCompat() {
        if (this.mActionMode == null) {
            return;
        }
        this.mActionMode.finish();
        this.mActionMode = null;
        LayerMarginsAnimator layerMarginsAnimator = this.mLayerView.getLayerMarginsAnimator();
        layerMarginsAnimator.setMarginsPinned(false);
        this.mViewFlipper.showPrevious();
        if (this.mShowActionModeEndAnimation) {
            layerMarginsAnimator.hideMargins(true);
            this.mShowActionModeEndAnimation = false;
        }
    }

    private class HideTabsTouchListener
    implements TouchEventInterceptor {
        private boolean mIsHidingTabs = false;

        private HideTabsTouchListener() {
        }

        public boolean onInterceptTouchEvent(View view, MotionEvent motionEvent) {
            if (view.getScrollX() != 0 || view.getScrollY() != 0) {
                Rect rect = new Rect();
                view.getHitRect(rect);
                rect.offset(-view.getScrollX(), -view.getScrollY());
                int[] nArray = new int[2];
                view.getLocationOnScreen(nArray);
                int n = (int)motionEvent.getRawX() - nArray[0];
                int n2 = (int)motionEvent.getRawY() - nArray[1];
                if (!rect.contains(n, n2)) {
                    return false;
                }
            }
            if (motionEvent.getActionMasked() == 0 && BrowserApp.this.autoHideTabs()) {
                this.mIsHidingTabs = true;
                return true;
            }
            return false;
        }

        public boolean onTouch(View view, MotionEvent motionEvent) {
            if (this.mIsHidingTabs) {
                int n = motionEvent.getActionMasked();
                if (n == 1 || n == 3) {
                    this.mIsHidingTabs = false;
                }
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum GuestModeDialog {
        ENTERING,
        LEAVING;

    }

    private static class MenuItemInfo {
        public int id;
        public String label;
        public String icon;
        public boolean checkable = false;
        public boolean checked = false;
        public boolean enabled = true;
        public boolean visible = true;
        public int parent;
        public boolean added = false;

        private MenuItemInfo() {
        }
    }
}

