/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.SystemClock;
import android.util.Log;
import java.util.Locale;
import org.mozilla.gecko.ContextGetter;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;

public class LocaleManager {
    private static final String LOG_TAG = "GeckoLocales";
    private static volatile ContextGetter getter = null;
    private static volatile Locale currentLocale = null;
    private static volatile boolean inited = false;
    private static boolean systemLocaleDidChange = false;
    private static BroadcastReceiver receiver;

    public static void setContextGetter(ContextGetter contextGetter) {
        Log.d((String)LOG_TAG, (String)("Calling setContextGetter: " + contextGetter));
        getter = contextGetter;
    }

    public static void initialize() {
        if (inited) {
            return;
        }
        receiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                systemLocaleDidChange = true;
            }
        };
        LocaleManager.getContext().registerReceiver(receiver, new IntentFilter("android.intent.action.LOCALE_CHANGED"));
        inited = true;
    }

    public static boolean systemLocaleDidChange() {
        return systemLocaleDidChange;
    }

    private static Context getContext() {
        if (getter == null) {
            throw new IllegalStateException("No ContextGetter; cannot fetch context.");
        }
        return getter.getContext();
    }

    private static SharedPreferences getSharedPreferences() {
        if (getter == null) {
            throw new IllegalStateException("No ContextGetter; cannot fetch prefs.", new RuntimeException("No prefs."));
        }
        return getter.getSharedPreferences();
    }

    public static void correctLocale(Resources resources, Configuration configuration) {
        Locale locale = LocaleManager.getCurrentLocale();
        if (locale == null) {
            return;
        }
        configuration.locale = locale;
        Locale.setDefault(locale);
        resources.updateConfiguration(configuration, resources.getDisplayMetrics());
    }

    private static Locale parseLocaleCode(String string2) {
        int n = string2.indexOf(45);
        if (n != -1 || (n = string2.indexOf(95)) != -1) {
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            return new Locale(string3, string4);
        }
        return new Locale(string2);
    }

    public static String getLanguageTag(Locale locale) {
        String string2 = locale.getLanguage();
        if (string2.equals("iw")) {
            string2 = "he";
        } else if (string2.equals("in")) {
            string2 = "id";
        } else if (string2.equals("ji")) {
            string2 = "yi";
        }
        String string3 = locale.getCountry();
        if (string3.equals("")) {
            return string2;
        }
        return string2 + "-" + string3;
    }

    public static Locale getCurrentLocale() {
        if (currentLocale != null) {
            return currentLocale;
        }
        String string2 = LocaleManager.getPersistedLocale();
        if (string2 == null) {
            return null;
        }
        currentLocale = LocaleManager.parseLocaleCode(string2);
        return currentLocale;
    }

    private static String updateLocale(String string2) {
        Locale locale = Locale.getDefault();
        if (locale.toString().equals(string2)) {
            return null;
        }
        Locale locale2 = LocaleManager.parseLocaleCode(string2);
        if (locale.equals(locale2)) {
            return null;
        }
        Locale.setDefault(locale2);
        currentLocale = locale2;
        Resources resources = LocaleManager.getContext().getResources();
        Configuration configuration = resources.getConfiguration();
        configuration.locale = locale2;
        resources.updateConfiguration(configuration, resources.getDisplayMetrics());
        return locale2.toString();
    }

    public static void notifyGeckoOfLocaleChange(Locale locale) {
        GeckoEvent geckoEvent = GeckoEvent.createBroadcastEvent("Locale:Changed", LocaleManager.getLanguageTag(locale));
        GeckoAppShell.sendEventToGecko(geckoEvent);
    }

    private static String getPrefName() {
        return LocaleManager.getContext().getPackageName() + ".locale";
    }

    public static String getPersistedLocale() {
        SharedPreferences sharedPreferences = LocaleManager.getSharedPreferences();
        String string2 = sharedPreferences.getString(LocaleManager.getPrefName(), "");
        if ("".equals(string2)) {
            return null;
        }
        return string2;
    }

    private static void persistLocale(String string2) {
        SharedPreferences sharedPreferences = LocaleManager.getSharedPreferences();
        sharedPreferences.edit().putString(LocaleManager.getPrefName(), string2).commit();
    }

    public static String getAndApplyPersistedLocale() {
        long l = SystemClock.uptimeMillis();
        String string2 = LocaleManager.getPersistedLocale();
        if (string2 == null) {
            return null;
        }
        LocaleManager.updateLocale(string2);
        long l2 = SystemClock.uptimeMillis();
        Log.i((String)LOG_TAG, (String)("Locale read and update took: " + (l2 - l) + "ms."));
        return string2;
    }

    public static String setSelectedLocale(String string2) {
        String string3 = LocaleManager.updateLocale(string2);
        LocaleManager.persistLocale(string2);
        LocaleManager.notifyGeckoOfLocaleChange(LocaleManager.getCurrentLocale());
        return string3;
    }
}

