/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.util.GeckoEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrefsHelper {
    private static final String LOGTAG = "GeckoPrefsHelper";
    private static boolean sRegistered = false;
    private static final Map<Integer, PrefHandler> sCallbacks = new HashMap<Integer, PrefHandler>();
    private static int sUniqueRequestId = 1;

    public static int getPref(String string2, PrefHandler prefHandler) {
        return PrefsHelper.getPrefsInternal(new String[]{string2}, prefHandler);
    }

    public static int getPrefs(String[] stringArray, PrefHandler prefHandler) {
        return PrefsHelper.getPrefsInternal(stringArray, prefHandler);
    }

    public static int getPrefs(ArrayList<String> arrayList, PrefHandler prefHandler) {
        return PrefsHelper.getPrefsInternal(arrayList.toArray(new String[arrayList.size()]), prefHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getPrefsInternal(String[] stringArray, PrefHandler prefHandler) {
        Object object = PrefsHelper.class;
        synchronized (PrefsHelper.class) {
            PrefsHelper.ensureRegistered();
            int n = sUniqueRequestId++;
            sCallbacks.put(n, prefHandler);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            object = prefHandler.isObserver() ? GeckoEvent.createPreferencesObserveEvent(n, stringArray) : GeckoEvent.createPreferencesGetEvent(n, stringArray);
            GeckoAppShell.sendEventToGecko((GeckoEvent)object);
            return n;
        }
    }

    private static void ensureRegistered() {
        if (sRegistered) {
            return;
        }
        GeckoAppShell.getEventDispatcher().registerEventListener("Preferences:Data", new GeckoEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleMessage(String string2, JSONObject jSONObject) {
                try {
                    JSONArray jSONArray = PrefsHelper.class;
                    synchronized (PrefsHelper.class) {
                        PrefHandler prefHandler;
                        int n;
                        try {
                            n = jSONObject.getInt("requestId");
                            prefHandler = (PrefHandler)sCallbacks.get(n);
                            if (prefHandler != null && !prefHandler.isObserver()) {
                                sCallbacks.remove(n);
                            }
                        }
                        catch (Exception exception) {
                            prefHandler = null;
                        }
                        if (prefHandler == null) {
                            Log.d((String)PrefsHelper.LOGTAG, (String)"Preferences:Data message had an unknown requestId; ignoring");
                            return;
                        }
                        jSONArray = jSONObject.getJSONArray("preferences");
                        for (n = 0; n < jSONArray.length(); ++n) {
                            JSONObject jSONObject2 = jSONArray.getJSONObject(n);
                            String string3 = jSONObject2.getString("name");
                            String string4 = jSONObject2.getString("type");
                            try {
                                if ("bool".equals(string4)) {
                                    prefHandler.prefValue(string3, jSONObject2.getBoolean("value"));
                                    continue;
                                }
                                if ("int".equals(string4)) {
                                    prefHandler.prefValue(string3, jSONObject2.getInt("value"));
                                    continue;
                                }
                                if ("string".equals(string4)) {
                                    prefHandler.prefValue(string3, jSONObject2.getString("value"));
                                    continue;
                                }
                                Log.e((String)PrefsHelper.LOGTAG, (String)("Unknown pref value type [" + string4 + "] for pref [" + string3 + "]"));
                                continue;
                            }
                            catch (Exception exception) {
                                Log.e((String)PrefsHelper.LOGTAG, (String)("Handler for preference [" + string3 + "] threw exception"), (Throwable)exception);
                            }
                        }
                        prefHandler.finish();
                    }
                }
                catch (Exception exception) {
                    Log.e((String)PrefsHelper.LOGTAG, (String)"Error handling Preferences:Data message", (Throwable)exception);
                }
            }
        });
        sRegistered = true;
    }

    public static void setPref(String string2, Object object) {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("Pref name must be non-empty");
        }
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("name", (Object)string2);
            if (object instanceof Boolean) {
                jSONObject.put("type", (Object)"bool");
                jSONObject.put("value", ((Boolean)object).booleanValue());
            } else if (object instanceof Integer) {
                jSONObject.put("type", (Object)"int");
                jSONObject.put("value", ((Integer)object).intValue());
            } else {
                jSONObject.put("type", (Object)"string");
                jSONObject.put("value", (Object)String.valueOf(object));
            }
            GeckoEvent geckoEvent = GeckoEvent.createBroadcastEvent("Preferences:Set", jSONObject.toString());
            GeckoAppShell.sendEventToGecko(geckoEvent);
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)("Error setting pref [" + string2 + "]"), (Throwable)jSONException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeObserver(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid request ID");
        }
        Object object = PrefsHelper.class;
        synchronized (PrefsHelper.class) {
            PrefHandler prefHandler = sCallbacks.remove(n);
            if (prefHandler == null) {
                Log.e((String)LOGTAG, (String)("Unknown request ID " + n));
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            object = GeckoEvent.createBroadcastEvent("Preferences:RemoveObserver", Integer.toString(n));
            GeckoAppShell.sendEventToGecko((GeckoEvent)object);
            return;
        }
    }

    public static abstract class PrefHandlerBase
    implements PrefHandler {
        public void prefValue(String string2, boolean bl) {
            Log.w((String)PrefsHelper.LOGTAG, (String)("Unhandled boolean value for pref [" + string2 + "]"));
        }

        public void prefValue(String string2, int n) {
            Log.w((String)PrefsHelper.LOGTAG, (String)("Unhandled int value for pref [" + string2 + "]"));
        }

        public void prefValue(String string2, String string3) {
            Log.w((String)PrefsHelper.LOGTAG, (String)("Unhandled String value for pref [" + string2 + "]"));
        }

        public void finish() {
        }

        public boolean isObserver() {
            return false;
        }
    }

    public static interface PrefHandler {
        public void prefValue(String var1, boolean var2);

        public void prefValue(String var1, int var2);

        public void prefValue(String var1, String var2);

        public boolean isObserver();

        public void finish();
    }
}

