/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.text.TextUtils;
import org.json.JSONObject;

public class SiteIdentity {
    private SecurityMode mSecurityMode;
    private String mHost;
    private String mOwner;
    private String mSupplemental;
    private String mVerifier;
    private String mEncrypted;

    public SiteIdentity() {
        this.reset(SecurityMode.UNKNOWN);
    }

    private void reset(SecurityMode securityMode) {
        this.mSecurityMode = securityMode;
        this.mHost = null;
        this.mOwner = null;
        this.mSupplemental = null;
        this.mVerifier = null;
        this.mEncrypted = null;
    }

    void update(JSONObject jSONObject) {
        try {
            this.mSecurityMode = SecurityMode.fromString(jSONObject.getString("mode"));
        }
        catch (Exception exception) {
            this.reset(SecurityMode.UNKNOWN);
            return;
        }
        try {
            this.mHost = jSONObject.getString("host");
            this.mOwner = jSONObject.getString("owner");
            this.mSupplemental = jSONObject.optString("supplemental", null);
            this.mVerifier = jSONObject.getString("verifier");
            this.mEncrypted = jSONObject.getString("encrypted");
        }
        catch (Exception exception) {
            this.reset(this.mSecurityMode);
        }
    }

    public SecurityMode getSecurityMode() {
        return this.mSecurityMode;
    }

    public String getHost() {
        return this.mHost;
    }

    public String getOwner() {
        return this.mOwner;
    }

    public String getSupplemental() {
        return this.mSupplemental;
    }

    public String getVerifier() {
        return this.mVerifier;
    }

    public String getEncrypted() {
        return this.mEncrypted;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SecurityMode {
        UNKNOWN("unknown"),
        IDENTIFIED("identified"),
        VERIFIED("verified"),
        MIXED_CONTENT_BLOCKED("mixed_content_blocked"),
        MIXED_CONTENT_LOADED("mixed_content_loaded");

        private final String mId;

        private SecurityMode(String string3) {
            this.mId = string3;
        }

        public static SecurityMode fromString(String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("Can't convert null String to SiteIdentity");
            }
            for (SecurityMode securityMode : SecurityMode.values()) {
                if (!TextUtils.equals((CharSequence)securityMode.mId, (CharSequence)string2.toLowerCase())) continue;
                return securityMode;
            }
            throw new IllegalArgumentException("Could not convert String id to SiteIdentity");
        }

        public String toString() {
            return this.mId;
        }
    }
}

