/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.os.SystemClock;
import android.util.Log;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.mozglue.RobocopTarget;

@RobocopTarget
public class Telemetry {
    private static final String LOGTAG = "Telemetry";

    public static long uptime() {
        return SystemClock.uptimeMillis();
    }

    public static long realtime() {
        return SystemClock.elapsedRealtime();
    }

    public static void HistogramAdd(String string2, int n) {
        GeckoEvent geckoEvent = GeckoEvent.createTelemetryHistogramAddEvent(string2, n);
        GeckoAppShell.sendEventToGecko(geckoEvent);
    }

    public static void startUISession(String string2) {
        GeckoEvent geckoEvent = GeckoEvent.createTelemetryUISessionStartEvent(string2, Telemetry.realtime());
        GeckoAppShell.sendEventToGecko(geckoEvent);
    }

    public static void stopUISession(String string2, String string3) {
        GeckoEvent geckoEvent = GeckoEvent.createTelemetryUISessionStopEvent(string2, string3, Telemetry.realtime());
        GeckoAppShell.sendEventToGecko(geckoEvent);
    }

    public static void sendUIEvent(String string2, String string3, long l, String string4) {
        GeckoEvent geckoEvent = GeckoEvent.createTelemetryUIEvent(string2, string3, l, string4);
        GeckoAppShell.sendEventToGecko(geckoEvent);
    }

    public static void sendUIEvent(String string2, String string3, long l) {
        Telemetry.sendUIEvent(string2, string3, l, null);
    }

    public static void sendUIEvent(String string2, String string3, String string4) {
        Telemetry.sendUIEvent(string2, string3, Telemetry.realtime(), string4);
    }

    public static void sendUIEvent(String string2, String string3) {
        Telemetry.sendUIEvent(string2, string3, Telemetry.realtime(), null);
    }

    public static void sendUIEvent(String string2) {
        Telemetry.sendUIEvent(string2, null, Telemetry.realtime(), null);
    }

    public static class UptimeTimer
    extends Timer {
        public UptimeTimer(String string2) {
            super(string2);
        }

        protected long now() {
            return Telemetry.uptime();
        }
    }

    public static class RealtimeTimer
    extends Timer {
        public RealtimeTimer(String string2) {
            super(string2);
        }

        protected long now() {
            return Telemetry.realtime();
        }
    }

    public static abstract class Timer {
        private final long mStartTime;
        private final String mName;
        private volatile boolean mHasFinished = false;
        private volatile long mElapsed = -1L;

        protected abstract long now();

        public Timer(String string2) {
            this.mName = string2;
            this.mStartTime = this.now();
        }

        public void cancel() {
            this.mHasFinished = true;
        }

        public long getElapsed() {
            return this.mElapsed;
        }

        public void stop() {
            if (this.mHasFinished) {
                return;
            }
            this.mHasFinished = true;
            long l = this.now() - this.mStartTime;
            if (l < 0L) {
                Log.e((String)Telemetry.LOGTAG, (String)"Current time less than start time -- clock shenanigans?");
                return;
            }
            this.mElapsed = l;
            if (l > Integer.MAX_VALUE) {
                Log.e((String)Telemetry.LOGTAG, (String)("Duration of " + l + "ms is too great to add to histogram."));
                return;
            }
            Telemetry.HistogramAdd(this.mName, (int)l);
        }
    }
}

