/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.favicons.cache;

import android.graphics.Bitmap;
import org.mozilla.gecko.favicons.cache.FaviconsForURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaviconCacheElement
implements Comparable<FaviconCacheElement> {
    final boolean mIsPrimary;
    Bitmap mFaviconPayload;
    volatile boolean mInvalidated;
    final int mImageSize;
    final FaviconsForURL mBackpointer;

    public FaviconCacheElement(Bitmap bitmap, boolean bl, int n, FaviconsForURL faviconsForURL) {
        this.mFaviconPayload = bitmap;
        this.mIsPrimary = bl;
        this.mImageSize = n;
        this.mBackpointer = faviconsForURL;
    }

    public FaviconCacheElement(Bitmap bitmap, boolean bl, FaviconsForURL faviconsForURL) {
        this.mFaviconPayload = bitmap;
        this.mIsPrimary = bl;
        this.mBackpointer = faviconsForURL;
        this.mImageSize = bitmap != null ? bitmap.getWidth() : 0;
    }

    public int sizeOf() {
        if (this.mInvalidated) {
            return 0;
        }
        return this.mFaviconPayload.getRowBytes() * this.mFaviconPayload.getHeight();
    }

    @Override
    public int compareTo(FaviconCacheElement faviconCacheElement) {
        if (this.mInvalidated && !faviconCacheElement.mInvalidated) {
            return -1;
        }
        if (!this.mInvalidated && faviconCacheElement.mInvalidated) {
            return 1;
        }
        if (this.mInvalidated) {
            return 0;
        }
        int n = this.mImageSize;
        int n2 = faviconCacheElement.mImageSize;
        if (n > n2) {
            return 1;
        }
        if (n2 > n) {
            return -1;
        }
        return 0;
    }

    public void onEvictedFromCache() {
        if (this.mIsPrimary) {
            this.mInvalidated = true;
            this.mFaviconPayload = null;
        } else {
            if (this.mBackpointer == null) {
                return;
            }
            this.mBackpointer.mFavicons.remove(this);
        }
    }
}

