/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.activities;

import android.app.AlertDialog;
import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Patterns;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.fxa.activities.FxAccountAbstractActivity;

public abstract class FxAccountAbstractSetupActivity
extends FxAccountAbstractActivity {
    private static final String LOG_TAG = FxAccountAbstractSetupActivity.class.getSimpleName();
    protected int minimumPasswordLength = 8;
    protected TextView localErrorTextView;
    protected EditText emailEdit;
    protected EditText passwordEdit;
    protected Button showPasswordButton;
    protected Button button;

    public FxAccountAbstractSetupActivity() {
        super(5);
    }

    protected FxAccountAbstractSetupActivity(int n) {
        super(n);
    }

    protected void createShowPasswordButton() {
        this.showPasswordButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                boolean bl = 0 == (FxAccountAbstractSetupActivity.this.passwordEdit.getInputType() & 0x80);
                int n = FxAccountAbstractSetupActivity.this.passwordEdit.getSelectionStart();
                int n2 = FxAccountAbstractSetupActivity.this.passwordEdit.getSelectionEnd();
                FxAccountAbstractSetupActivity.this.passwordEdit.setInputType(FxAccountAbstractSetupActivity.this.passwordEdit.getInputType() ^ 0x80);
                FxAccountAbstractSetupActivity.this.passwordEdit.setSelection(n, n2);
                if (bl) {
                    FxAccountAbstractSetupActivity.this.showPasswordButton.setText(R.string.fxaccount_password_show);
                } else {
                    FxAccountAbstractSetupActivity.this.showPasswordButton.setText(R.string.fxaccount_password_hide);
                }
            }
        });
    }

    protected void showRemoteError(Exception exception) {
        new AlertDialog.Builder((Context)this).setTitle((CharSequence)"Remote error!").setMessage((CharSequence)exception.toString()).show();
    }

    protected void addListeners() {
        TextChangedListener textChangedListener = new TextChangedListener();
        EditorActionListener editorActionListener = new EditorActionListener();
        FocusChangeListener focusChangeListener = new FocusChangeListener();
        this.emailEdit.addTextChangedListener((TextWatcher)textChangedListener);
        this.emailEdit.setOnEditorActionListener((TextView.OnEditorActionListener)editorActionListener);
        this.emailEdit.setOnFocusChangeListener((View.OnFocusChangeListener)focusChangeListener);
        this.passwordEdit.addTextChangedListener((TextWatcher)textChangedListener);
        this.passwordEdit.setOnEditorActionListener((TextView.OnEditorActionListener)editorActionListener);
        this.passwordEdit.setOnFocusChangeListener((View.OnFocusChangeListener)focusChangeListener);
    }

    protected boolean shouldButtonBeEnabled() {
        String string2 = this.emailEdit.getText().toString();
        String string3 = this.passwordEdit.getText().toString();
        boolean bl = string2.length() > 0 && Patterns.EMAIL_ADDRESS.matcher(string2).matches() && string3.length() >= this.minimumPasswordLength;
        return bl;
    }

    protected boolean updateButtonState() {
        boolean bl = this.shouldButtonBeEnabled();
        if (bl != this.button.isEnabled()) {
            Logger.debug(LOG_TAG, (bl ? "En" : "Dis") + "abling button.");
            this.button.setEnabled(bl);
        }
        return bl;
    }

    protected class TextChangedListener
    implements TextWatcher {
        protected TextChangedListener() {
        }

        public void afterTextChanged(Editable editable) {
            FxAccountAbstractSetupActivity.this.updateButtonState();
        }

        public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        }

        public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        }
    }

    protected class EditorActionListener
    implements TextView.OnEditorActionListener {
        protected EditorActionListener() {
        }

        public boolean onEditorAction(TextView textView, int n, KeyEvent keyEvent) {
            FxAccountAbstractSetupActivity.this.updateButtonState();
            return false;
        }
    }

    protected class FocusChangeListener
    implements View.OnFocusChangeListener {
        protected FocusChangeListener() {
        }

        public void onFocusChange(View view, boolean bl) {
            if (bl) {
                return;
            }
            FxAccountAbstractSetupActivity.this.updateButtonState();
        }
    }
}

