/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.activities;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import ch.boye.httpclientandroidlib.HttpResponse;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountClient10;
import org.mozilla.gecko.background.fxa.FxAccountClient20;
import org.mozilla.gecko.fxa.activities.FxAccountSetupTask;
import org.mozilla.gecko.sync.HTTPFailureException;
import org.mozilla.gecko.sync.net.SyncStorageResponse;

public class FxAccountConfirmAccountActivity
extends Activity
implements View.OnClickListener {
    protected static final String LOG_TAG = FxAccountConfirmAccountActivity.class.getSimpleName();
    protected byte[] sessionToken;
    protected TextView emailText;

    public View ensureFindViewById(View view, int n, String string2) {
        View view2 = view != null ? view.findViewById(n) : this.findViewById(n);
        if (view2 == null) {
            String string3 = "Could not find view " + string2 + ".";
            Logger.error(LOG_TAG, string3);
            throw new RuntimeException(string3);
        }
        return view2;
    }

    public void onCreate(Bundle bundle) {
        View view;
        Logger.debug(LOG_TAG, "onCreate(" + bundle + ")");
        super.onCreate(bundle);
        this.setContentView(R.layout.fxaccount_confirm_account);
        this.emailText = (TextView)this.ensureFindViewById(null, R.id.email, "email text");
        if (this.getIntent() != null && this.getIntent().getExtras() != null) {
            view = this.getIntent().getExtras();
            this.emailText.setText((CharSequence)view.getString("email"));
            this.sessionToken = view.getByteArray("sessionToken");
        }
        view = this.ensureFindViewById(null, R.id.resend_confirmation_email_link, "resend confirmation email link");
        view.setOnClickListener((View.OnClickListener)this);
        if (this.sessionToken == null) {
            view.setEnabled(false);
            view.setClickable(false);
        }
    }

    protected void resendCode(byte[] byArray) {
        String string2 = "https://api-accounts-onepw.dev.lcip.org";
        ResendCodeDelegate resendCodeDelegate = new ResendCodeDelegate();
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        FxAccountClient20 fxAccountClient20 = new FxAccountClient20(string2, executorService);
        new FxAccountResendCodeTask((Context)this, byArray, fxAccountClient20, resendCodeDelegate).execute(new Void[0]);
    }

    public void onClick(View view) {
        this.resendCode(this.sessionToken);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ResendCodeDelegate
    implements FxAccountClient10.RequestDelegate<Void> {
        protected ResendCodeDelegate() {
        }

        @Override
        public void handleError(Exception exception) {
            Logger.warn(LOG_TAG, "Got exception requesting fresh confirmation link; ignoring.", exception);
            Toast.makeText((Context)FxAccountConfirmAccountActivity.this.getApplicationContext(), (int)R.string.fxaccount_confirm_verification_link_not_sent, (int)1).show();
        }

        @Override
        public void handleFailure(int n, HttpResponse httpResponse) {
            this.handleError(new HTTPFailureException(new SyncStorageResponse(httpResponse)));
        }

        @Override
        public void handleSuccess(Void void_) {
            Toast.makeText((Context)FxAccountConfirmAccountActivity.this.getApplicationContext(), (int)R.string.fxaccount_confirm_verification_link_sent, (int)0).show();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FxAccountResendCodeTask
    extends FxAccountSetupTask<Void> {
        protected static final String LOG_TAG = FxAccountResendCodeTask.class.getSimpleName();
        protected final byte[] sessionToken;

        public FxAccountResendCodeTask(Context context, byte[] byArray, FxAccountClient20 fxAccountClient20, FxAccountClient10.RequestDelegate<Void> requestDelegate) {
            super(context, false, fxAccountClient20, requestDelegate);
            this.sessionToken = byArray;
        }

        protected FxAccountSetupTask.InnerRequestDelegate<Void> doInBackground(Void ... voidArray) {
            try {
                this.client.resendCode(this.sessionToken, this.innerDelegate);
                this.latch.await();
                return this.innerDelegate;
            }
            catch (Exception exception) {
                Logger.error(LOG_TAG, "Got exception signing in.", exception);
                this.delegate.handleError(exception);
                return null;
            }
        }
    }
}

