/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.R;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import org.mozilla.gecko.R;
import org.mozilla.gecko.util.GeckoJarReader;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.util.UiAsyncTask;

public final class BitmapUtils {
    private static final String LOGTAG = "GeckoBitmapUtils";

    private BitmapUtils() {
    }

    public static void getDrawable(final Context context, final String string2, final BitmapLoader bitmapLoader) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            bitmapLoader.onBitmapFound(null);
            return;
        }
        if (string2.startsWith("data")) {
            BitmapDrawable bitmapDrawable = new BitmapDrawable(context.getResources(), BitmapUtils.getBitmapFromDataURI(string2));
            bitmapLoader.onBitmapFound((Drawable)bitmapDrawable);
            return;
        }
        if (string2.startsWith("jar:") || string2.startsWith("file://")) {
            new UiAsyncTask<Void, Void, Drawable>(ThreadUtils.getBackgroundHandler()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Drawable doInBackground(Void ... voidArray) {
                    Drawable drawable2;
                    if (string2.startsWith("jar:jar")) {
                        return GeckoJarReader.getBitmapDrawable((Resources)context.getResources(), (String)string2);
                    }
                    if (string2.startsWith("jar:file")) {
                        return GeckoJarReader.getBitmapDrawable((Resources)context.getResources(), (String)Uri.decode((String)string2));
                    }
                    URL uRL = new URL(string2);
                    InputStream inputStream = (InputStream)uRL.getContent();
                    try {
                        drawable2 = Drawable.createFromStream((InputStream)inputStream, (String)"src");
                    }
                    catch (Throwable throwable) {
                        try {
                            inputStream.close();
                            throw throwable;
                        }
                        catch (Exception exception) {
                            Log.w((String)BitmapUtils.LOGTAG, (String)"Unable to set icon", (Throwable)exception);
                            return null;
                        }
                    }
                    inputStream.close();
                    return drawable2;
                }

                public void onPostExecute(Drawable drawable2) {
                    bitmapLoader.onBitmapFound(drawable2);
                }
            }.execute((Object[])new Void[0]);
            return;
        }
        if (string2.startsWith("-moz-icon://")) {
            Uri uri = Uri.parse((String)string2);
            String string3 = uri.getSchemeSpecificPart();
            string3 = string3.substring(string3.lastIndexOf(47) + 1);
            try {
                Drawable drawable2 = context.getPackageManager().getApplicationIcon(string3);
                bitmapLoader.onBitmapFound(drawable2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        if (string2.startsWith("drawable://")) {
            Uri uri = Uri.parse((String)string2);
            int n = BitmapUtils.getResource(uri, R.drawable.ic_status_logo);
            Drawable drawable3 = context.getResources().getDrawable(n);
            bitmapLoader.onBitmapFound(drawable3);
            return;
        }
        bitmapLoader.onBitmapFound(null);
    }

    public static Bitmap decodeByteArray(byte[] byArray) {
        return BitmapUtils.decodeByteArray(byArray, null);
    }

    public static Bitmap decodeByteArray(byte[] byArray, BitmapFactory.Options options) {
        return BitmapUtils.decodeByteArray(byArray, 0, byArray.length, options);
    }

    public static Bitmap decodeByteArray(byte[] byArray, int n, int n2) {
        return BitmapUtils.decodeByteArray(byArray, n, n2, null);
    }

    public static Bitmap decodeByteArray(byte[] byArray, int n, int n2, BitmapFactory.Options options) {
        if (byArray.length <= 0) {
            throw new IllegalArgumentException("bytes.length " + byArray.length + " must be a positive number");
        }
        Bitmap bitmap = null;
        try {
            bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)n, (int)n2, (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Log.e((String)LOGTAG, (String)("decodeByteArray(bytes.length=" + byArray.length + ", options= " + options + ") OOM!"), (Throwable)outOfMemoryError);
            return null;
        }
        if (bitmap == null) {
            Log.w((String)LOGTAG, (String)"decodeByteArray() returning null because BitmapFactory returned null");
            return null;
        }
        if (bitmap.getWidth() <= 0 || bitmap.getHeight() <= 0) {
            Log.w((String)LOGTAG, (String)("decodeByteArray() returning null because BitmapFactory returned a bitmap with dimensions " + bitmap.getWidth() + "x" + bitmap.getHeight()));
            return null;
        }
        return bitmap;
    }

    public static Bitmap decodeStream(InputStream inputStream) {
        try {
            return BitmapFactory.decodeStream((InputStream)inputStream);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Log.e((String)LOGTAG, (String)"decodeStream() OOM!", (Throwable)outOfMemoryError);
            return null;
        }
    }

    public static Bitmap decodeUrl(Uri uri) {
        return BitmapUtils.decodeUrl(uri.toString());
    }

    public static Bitmap decodeUrl(String string2) {
        URL uRL;
        try {
            uRL = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            Log.w((String)LOGTAG, (String)("decodeUrl: malformed URL " + string2));
            return null;
        }
        return BitmapUtils.decodeUrl(uRL);
    }

    public static Bitmap decodeUrl(URL uRL) {
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            Log.w((String)LOGTAG, (String)("decodeUrl: IOException downloading " + uRL));
            return null;
        }
        if (inputStream == null) {
            Log.w((String)LOGTAG, (String)("decodeUrl: stream not found downloading " + uRL));
            return null;
        }
        Bitmap bitmap = BitmapUtils.decodeStream(inputStream);
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            Log.w((String)LOGTAG, (String)("decodeUrl: IOException closing stream " + uRL), (Throwable)iOException);
        }
        return bitmap;
    }

    public static Bitmap decodeResource(Context context, int n) {
        return BitmapUtils.decodeResource(context, n, null);
    }

    public static Bitmap decodeResource(Context context, int n, BitmapFactory.Options options) {
        Resources resources = context.getResources();
        try {
            return BitmapFactory.decodeResource((Resources)resources, (int)n, (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Log.e((String)LOGTAG, (String)("decodeResource() OOM! Resource id=" + n), (Throwable)outOfMemoryError);
            return null;
        }
    }

    public static int getDominantColor(Bitmap bitmap) {
        return BitmapUtils.getDominantColor(bitmap, true);
    }

    public static int getDominantColor(Bitmap bitmap, boolean bl) {
        if (bitmap == null) {
            return Color.argb((int)255, (int)255, (int)255, (int)255);
        }
        int[] nArray = new int[36];
        int n = -1;
        float[] fArray = new float[36];
        float[] fArray2 = new float[36];
        float[] fArray3 = new float[36];
        float[] fArray4 = new float[3];
        int n2 = bitmap.getHeight();
        int n3 = bitmap.getWidth();
        int[] nArray2 = new int[n3 * n2];
        bitmap.getPixels(nArray2, 0, n3, 0, 0, n3, n2);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n4 = nArray2[j + i * n3];
                if (Color.alpha((int)n4) < 128) continue;
                Color.colorToHSV((int)n4, (float[])fArray4);
                if (bl && (fArray4[1] <= 0.35f || fArray4[2] <= 0.35f)) continue;
                int n5 = (int)Math.floor(fArray4[0] / 10.0f);
                fArray[n5] = fArray[n5] + fArray4[0];
                fArray2[n5] = fArray2[n5] + fArray4[1];
                fArray3[n5] = fArray3[n5] + fArray4[2];
                int n6 = n5;
                nArray[n6] = nArray[n6] + 1;
                if (n >= 0 && nArray[n5] <= nArray[n]) continue;
                n = n5;
            }
        }
        if (n < 0) {
            return Color.argb((int)255, (int)255, (int)255, (int)255);
        }
        fArray4[0] = fArray[n] / (float)nArray[n];
        fArray4[1] = fArray2[n] / (float)nArray[n];
        fArray4[2] = fArray3[n] / (float)nArray[n];
        return Color.HSVToColor((float[])fArray4);
    }

    public static Bitmap getBitmapFromDataURI(String string2) {
        String string3 = string2.substring(string2.indexOf(44) + 1);
        try {
            byte[] byArray = Base64.decode((String)string3, (int)0);
            return BitmapUtils.decodeByteArray(byArray);
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)("exception decoding bitmap from data URI: " + string2), (Throwable)exception);
            return null;
        }
    }

    public static Bitmap getBitmapFromDrawable(Drawable drawable2) {
        if (drawable2 instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        int n = drawable2.getIntrinsicWidth();
        n = n > 0 ? n : 1;
        int n2 = drawable2.getIntrinsicHeight();
        n2 = n2 > 0 ? n2 : 1;
        Bitmap bitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    public static int getResource(Uri uri, int n) {
        int n2 = n;
        String string2 = uri.getScheme();
        if ("drawable".equals(string2)) {
            String string3 = uri.getSchemeSpecificPart();
            string3 = string3.substring(string3.lastIndexOf(47) + 1);
            try {
                return Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    Class<R.drawable> clazz = R.drawable.class;
                    Field field = clazz.getField(string3);
                    n2 = field.getInt(null);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    try {
                        Class<R.drawable> clazz = R.drawable.class;
                        Field field = clazz.getField(string3);
                        n2 = field.getInt(null);
                    }
                    catch (NoSuchFieldException noSuchFieldException2) {
                    }
                    catch (Exception exception) {
                        Log.i((String)LOGTAG, (String)"Exception getting drawable", (Throwable)exception);
                    }
                }
                catch (Exception exception) {
                    Log.i((String)LOGTAG, (String)"Exception getting drawable", (Throwable)exception);
                }
                uri = null;
            }
        }
        return n2;
    }

    public static interface BitmapLoader {
        public void onBitmapFound(Drawable var1);
    }
}

