/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.graphics.PointF;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoThread;
import org.mozilla.gecko.gfx.DisplayPortMetrics;
import org.mozilla.gecko.gfx.Overscroll;
import org.mozilla.gecko.gfx.PanZoomController;
import org.mozilla.gecko.gfx.PanZoomTarget;
import org.mozilla.gecko.mozglue.generatorannotations.WrapElementForJNI;
import org.mozilla.gecko.util.EventDispatcher;
import org.mozilla.gecko.util.GeckoEventListener;

class NativePanZoomController
implements PanZoomController,
GeckoEventListener {
    private final PanZoomTarget mTarget;
    private final EventDispatcher mDispatcher;
    private final CallbackRunnable mCallbackRunnable;

    NativePanZoomController(PanZoomTarget panZoomTarget, View view, EventDispatcher eventDispatcher) {
        this.mTarget = panZoomTarget;
        this.mDispatcher = eventDispatcher;
        this.mCallbackRunnable = new CallbackRunnable();
        if (GeckoThread.checkLaunchState(GeckoThread.LaunchState.GeckoRunning)) {
            this.init();
        } else {
            this.mDispatcher.registerEventListener("Gecko:Ready", (GeckoEventListener)this);
        }
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        if ("Gecko:Ready".equals(string2)) {
            this.mDispatcher.unregisterEventListener("Gecko:Ready", (GeckoEventListener)this);
            this.init();
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        GeckoEvent geckoEvent = GeckoEvent.createMotionEvent(motionEvent, true);
        this.handleTouchEvent(geckoEvent);
        return false;
    }

    public boolean onMotionEvent(MotionEvent motionEvent) {
        return false;
    }

    public boolean onKeyEvent(KeyEvent keyEvent) {
        return false;
    }

    public PointF getVelocityVector() {
        return new PointF(0.0f, 0.0f);
    }

    public void pageRectUpdated() {
    }

    public void abortPanning() {
    }

    public native void abortAnimation();

    private native void init();

    private native void handleTouchEvent(GeckoEvent var1);

    private native void handleMotionEvent(GeckoEvent var1);

    private native long runDelayedCallback();

    public native void destroy();

    public native void notifyDefaultActionPrevented(boolean var1);

    public native boolean getRedrawHint();

    public native void setOverScrollMode(int var1);

    public native int getOverScrollMode();

    @WrapElementForJNI(allowMultithread=true, stubName="RequestContentRepaintWrapper")
    private void requestContentRepaint(float f, float f2, float f3, float f4, float f5) {
        this.mTarget.forceRedraw(new DisplayPortMetrics(f, f2, f + f3, f2 + f4, f5));
    }

    @WrapElementForJNI(allowMultithread=true, stubName="PostDelayedCallbackWrapper")
    private void postDelayedCallback(long l) {
        this.mTarget.postDelayed(this.mCallbackRunnable, l);
    }

    public void setOverscrollHandler(Overscroll overscroll) {
    }

    class CallbackRunnable
    implements Runnable {
        CallbackRunnable() {
        }

        public void run() {
            long l = NativePanZoomController.this.runDelayedCallback();
            if (l >= 0L) {
                NativePanZoomController.this.mTarget.postDelayed(this, l);
            }
        }
    }
}

