/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Html;
import android.text.Spanned;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.R;
import org.mozilla.gecko.gfx.BitmapUtils;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.ThreadUtils;

public class HomeBanner
extends LinearLayout
implements GeckoEventListener {
    private static final String LOGTAG = "GeckoHomeBanner";

    public HomeBanner(Context context) {
        this(context, null);
    }

    public HomeBanner(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        LayoutInflater.from((Context)context).inflate(R.layout.home_banner, (ViewGroup)this);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        ImageButton imageButton = (ImageButton)this.findViewById(R.id.close);
        imageButton.getDrawable().setAlpha(127);
        imageButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                HomeBanner.this.setVisibility(8);
            }
        });
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("HomeBanner:Click", (String)HomeBanner.this.getTag()));
            }
        });
        GeckoAppShell.getEventDispatcher().registerEventListener("HomeBanner:Data", (GeckoEventListener)this);
        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("HomeBanner:Get", null));
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        GeckoAppShell.getEventDispatcher().unregisterEventListener("HomeBanner:Data", (GeckoEventListener)this);
    }

    public boolean isDismissed() {
        return this.getVisibility() == 8;
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        TextView textView;
        Object object;
        try {
            this.setTag(jSONObject.getString("id"));
            object = Html.fromHtml((String)jSONObject.getString("text"));
            textView = (TextView)this.findViewById(R.id.text);
            ThreadUtils.postToUiThread((Runnable)new Runnable((Spanned)object){
                final /* synthetic */ Spanned val$text;
                {
                    this.val$text = spanned;
                }

                public void run() {
                    textView.setText((CharSequence)this.val$text);
                    HomeBanner.this.setVisibility(0);
                }
            });
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)("Exception handling " + string2 + " message"), (Throwable)jSONException);
            return;
        }
        object = jSONObject.optString("iconURI");
        textView = (ImageView)this.findViewById(R.id.icon);
        if (TextUtils.isEmpty((CharSequence)object)) {
            textView.setVisibility(8);
            return;
        }
        BitmapUtils.getDrawable(this.getContext(), (String)object, new BitmapUtils.BitmapLoader((ImageView)textView){
            final /* synthetic */ ImageView val$iconView;
            {
                this.val$iconView = imageView;
            }

            public void onBitmapFound(final Drawable drawable2) {
                if (drawable2 == null) {
                    this.val$iconView.setVisibility(8);
                    return;
                }
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    public void run() {
                        val$iconView.setImageDrawable(drawable2);
                    }
                });
            }
        });
    }
}

