/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.R;
import org.mozilla.gecko.home.HomeConfig;
import org.mozilla.gecko.util.HardwareUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HomeConfigPrefsBackend
implements HomeConfig.HomeConfigBackend {
    private static final String LOGTAG = "GeckoHomeConfigBackend";
    private static final String PREFS_KEY = "home_panels";
    private static final String TOP_SITES_PANEL_ID = "4becc86b-41eb-429a-a042-88fe8b5a094e";
    private static final String BOOKMARKS_PANEL_ID = "7f6d419a-cd6c-4e34-b26f-f68b1b551907";
    private static final String READING_LIST_PANEL_ID = "20f4549a-64ad-4c32-93e4-1dcef792733b";
    private static final String HISTORY_PANEL_ID = "f134bf20-11f7-4867-ab8b-e8e705d7fbe8";
    private final Context mContext;
    private PrefsListener mPrefsListener;
    private HomeConfig.OnChangeListener mChangeListener;

    public HomeConfigPrefsBackend(Context context) {
        this.mContext = context;
    }

    private SharedPreferences getSharedPreferences() {
        return PreferenceManager.getDefaultSharedPreferences((Context)this.mContext);
    }

    private List<HomeConfig.PanelConfig> loadDefaultConfig() {
        ArrayList<HomeConfig.PanelConfig> arrayList = new ArrayList<HomeConfig.PanelConfig>();
        arrayList.add(new HomeConfig.PanelConfig(HomeConfig.PanelType.TOP_SITES, this.mContext.getString(R.string.home_top_sites_title), TOP_SITES_PANEL_ID, EnumSet.of(HomeConfig.PanelConfig.Flags.DEFAULT_PANEL)));
        arrayList.add(new HomeConfig.PanelConfig(HomeConfig.PanelType.BOOKMARKS, this.mContext.getString(R.string.bookmarks_title), BOOKMARKS_PANEL_ID));
        if (!HardwareUtils.isLowMemoryPlatform()) {
            arrayList.add(new HomeConfig.PanelConfig(HomeConfig.PanelType.READING_LIST, this.mContext.getString(R.string.reading_list_title), READING_LIST_PANEL_ID));
        }
        HomeConfig.PanelConfig panelConfig = new HomeConfig.PanelConfig(HomeConfig.PanelType.HISTORY, this.mContext.getString(R.string.home_history_title), HISTORY_PANEL_ID);
        if (HardwareUtils.isTablet()) {
            arrayList.add(panelConfig);
        } else {
            arrayList.add(0, panelConfig);
        }
        return arrayList;
    }

    private List<HomeConfig.PanelConfig> loadConfigFromString(String string2) {
        JSONArray jSONArray;
        try {
            jSONArray = new JSONArray(string2);
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"Error loading the list of home panels from JSON prefs", (Throwable)jSONException);
            return this.loadDefaultConfig();
        }
        ArrayList<HomeConfig.PanelConfig> arrayList = new ArrayList<HomeConfig.PanelConfig>();
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            try {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                HomeConfig.PanelConfig panelConfig = new HomeConfig.PanelConfig(jSONObject);
                arrayList.add(panelConfig);
                continue;
            }
            catch (Exception exception) {
                Log.e((String)LOGTAG, (String)"Exception loading PanelConfig from JSON", (Throwable)exception);
            }
        }
        return arrayList;
    }

    @Override
    public List<HomeConfig.PanelConfig> load() {
        SharedPreferences sharedPreferences = this.getSharedPreferences();
        String string2 = sharedPreferences.getString(PREFS_KEY, null);
        List<HomeConfig.PanelConfig> list = TextUtils.isEmpty((CharSequence)string2) ? this.loadDefaultConfig() : this.loadConfigFromString(string2);
        return Collections.unmodifiableList(list);
    }

    @Override
    public void save(List<HomeConfig.PanelConfig> list) {
        Object object;
        HomeConfig.PanelConfig panelConfig;
        JSONArray jSONArray = new JSONArray();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            try {
                panelConfig = list.get(i);
                object = panelConfig.toJSON();
                jSONArray.put(object);
                continue;
            }
            catch (Exception exception) {
                Log.e((String)LOGTAG, (String)"Exception converting PanelConfig to JSON", (Throwable)exception);
            }
        }
        SharedPreferences sharedPreferences = this.getSharedPreferences();
        panelConfig = sharedPreferences.edit();
        object = jSONArray.toString();
        panelConfig.putString(PREFS_KEY, (String)object);
        panelConfig.commit();
    }

    @Override
    public void setOnChangeListener(HomeConfig.OnChangeListener onChangeListener) {
        SharedPreferences sharedPreferences = this.getSharedPreferences();
        if (this.mChangeListener != null) {
            sharedPreferences.unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this.mPrefsListener);
            this.mPrefsListener = null;
        }
        this.mChangeListener = onChangeListener;
        if (this.mChangeListener != null) {
            this.mPrefsListener = new PrefsListener();
            sharedPreferences.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this.mPrefsListener);
        }
    }

    private class PrefsListener
    implements SharedPreferences.OnSharedPreferenceChangeListener {
        private PrefsListener() {
        }

        public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String string2) {
            if (TextUtils.equals((CharSequence)string2, (CharSequence)HomeConfigPrefsBackend.PREFS_KEY)) {
                HomeConfigPrefsBackend.this.mChangeListener.onChange();
            }
        }
    }
}

