/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.prompts;

import android.content.Context;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.prompts.Prompt;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.GeckoEventResponder;
import org.mozilla.gecko.util.ThreadUtils;

public class PromptService
implements GeckoEventResponder {
    private static final String LOGTAG = "GeckoPromptService";
    private final ConcurrentLinkedQueue<String> mPromptQueue;
    private final Context mContext;

    public PromptService(Context context) {
        GeckoAppShell.getEventDispatcher().registerEventListener("Prompt:Show", (GeckoEventListener)this);
        GeckoAppShell.getEventDispatcher().registerEventListener("Prompt:ShowTop", (GeckoEventListener)this);
        this.mPromptQueue = new ConcurrentLinkedQueue();
        this.mContext = context;
    }

    public void destroy() {
        GeckoAppShell.getEventDispatcher().unregisterEventListener("Prompt:Show", (GeckoEventListener)this);
        GeckoAppShell.getEventDispatcher().unregisterEventListener("Prompt:ShowTop", (GeckoEventListener)this);
    }

    public void show(final String string2, final String string3, final Prompt.PromptListItem[] promptListItemArray, final boolean bl, final Prompt.PromptCallback promptCallback) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            public void run() {
                Prompt prompt = promptCallback != null ? new Prompt(PromptService.this.mContext, promptCallback) : new Prompt(PromptService.this.mContext, PromptService.this.mPromptQueue);
                prompt.show(string2, string3, promptListItemArray, bl);
            }
        });
    }

    public void handleMessage(String string2, final JSONObject jSONObject) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            public void run() {
                boolean bl = jSONObject.optBoolean("async");
                Prompt prompt = bl ? new Prompt(PromptService.this.mContext, new Prompt.PromptCallback(){

                    public void onPromptFinished(String string2) {
                        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Prompt:Reply", string2));
                    }
                }) : new Prompt(PromptService.this.mContext, PromptService.this.mPromptQueue);
                prompt.show(jSONObject);
            }
        });
    }

    public String getResponse(JSONObject jSONObject) {
        String string2;
        if (jSONObject.optBoolean("async")) {
            return "";
        }
        while (null == (string2 = this.mPromptQueue.poll())) {
            GeckoAppShell.processNextNativeEvent(true);
        }
        return string2;
    }
}

