/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.config;

import android.accounts.Account;
import android.content.Context;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.setup.SyncAccounts;

public class AccountPickler {
    public static final String LOG_TAG = "AccountPickler";
    public static final long VERSION = 1L;

    public static boolean deletePickle(Context context, String string2) {
        return context.deleteFile(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pickle(Context context, String string2, SyncAccounts.SyncAccountParameters syncAccountParameters, boolean bl) {
        ExtendedJSONObject extendedJSONObject = syncAccountParameters.asJSON();
        extendedJSONObject.put("syncAutomatically", bl);
        extendedJSONObject.put("version", new Long(1L));
        extendedJSONObject.put("timestamp", new Long(System.currentTimeMillis()));
        PrintStream printStream = null;
        try {
            FileOutputStream fileOutputStream = context.openFileOutput(string2, 0);
            printStream = new PrintStream(fileOutputStream);
            printStream.print(extendedJSONObject.toJSONString());
            Logger.debug(LOG_TAG, "Persisted " + extendedJSONObject.keySet().size() + " account settings to " + string2 + ".");
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Caught exception persisting account settings to " + string2 + "; ignoring.", exception);
        }
        finally {
            if (printStream != null) {
                printStream.close();
            }
        }
    }

    public static Account unpickle(Context context, String string2) {
        Account account;
        String string3 = Utils.readFile(context, string2);
        if (string3 == null) {
            Logger.info(LOG_TAG, "Pickle file '" + string2 + "' not found; aborting.");
            return null;
        }
        ExtendedJSONObject extendedJSONObject = null;
        try {
            extendedJSONObject = ExtendedJSONObject.parseJSONObject(string3);
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Got exception reading pickle file '" + string2 + "'; aborting.", exception);
            return null;
        }
        SyncAccounts.SyncAccountParameters syncAccountParameters = null;
        try {
            syncAccountParameters = new SyncAccounts.SyncAccountParameters(context, null, extendedJSONObject);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.warn(LOG_TAG, "Un-pickled data included null username, password, or serverURL; aborting.", illegalArgumentException);
            return null;
        }
        boolean bl = true;
        if (extendedJSONObject.containsKey("syncAutomatically") && Boolean.FALSE.equals(extendedJSONObject.get("syncAutomatically"))) {
            bl = false;
        }
        if ((account = SyncAccounts.createSyncAccountPreservingExistingPreferences(syncAccountParameters, bl)) == null) {
            Logger.warn(LOG_TAG, "Failed to add Android Account; aborting.");
            return null;
        }
        Integer n = extendedJSONObject.getIntegerSafely("version");
        Integer n2 = extendedJSONObject.getIntegerSafely("timestamp");
        if (n == null || n2 == null) {
            Logger.warn(LOG_TAG, "Did not find version or timestamp in pickle file; ignoring.");
            n = new Integer(-1);
            n2 = new Integer(-1);
        }
        Logger.info(LOG_TAG, "Un-pickled Android account named " + syncAccountParameters.username + " (version " + n + ", pickled at " + n2 + ").");
        return account;
    }
}

