/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories.domain;

import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.repositories.android.RepoUtils;
import org.mozilla.gecko.sync.repositories.domain.Record;

public class PasswordRecord
extends Record {
    private static final String LOG_TAG = "PasswordRecord";
    public static final String COLLECTION_NAME = "passwords";
    public static long PASSWORDS_TTL = -1L;
    public static final String PAYLOAD_HOSTNAME = "hostname";
    public static final String PAYLOAD_FORM_SUBMIT_URL = "formSubmitURL";
    public static final String PAYLOAD_HTTP_REALM = "httpRealm";
    public static final String PAYLOAD_USERNAME = "username";
    public static final String PAYLOAD_PASSWORD = "password";
    public static final String PAYLOAD_USERNAME_FIELD = "usernameField";
    public static final String PAYLOAD_PASSWORD_FIELD = "passwordField";
    public String id;
    public String hostname;
    public String formSubmitURL;
    public String httpRealm;
    public String usernameField;
    public String passwordField;
    public String encryptedUsername;
    public String encryptedPassword;
    public String encType;
    public long timeCreated;
    public long timeLastUsed;
    public long timePasswordChanged;
    public long timesUsed;

    public PasswordRecord(String string2, String string3, long l, boolean bl) {
        super(string2, string3, l, bl);
        this.ttl = PASSWORDS_TTL;
    }

    public PasswordRecord(String string2, String string3, long l) {
        this(string2, string3, l, false);
    }

    public PasswordRecord(String string2, String string3) {
        this(string2, string3, 0L, false);
    }

    public PasswordRecord(String string2) {
        this(string2, COLLECTION_NAME, 0L, false);
    }

    public PasswordRecord() {
        this(Utils.generateGuid(), COLLECTION_NAME, 0L, false);
    }

    public Record copyWithIDs(String string2, long l) {
        PasswordRecord passwordRecord = new PasswordRecord(string2, this.collection, this.lastModified, this.deleted);
        passwordRecord.androidID = l;
        passwordRecord.sortIndex = this.sortIndex;
        passwordRecord.ttl = this.ttl;
        passwordRecord.id = this.id;
        passwordRecord.hostname = this.hostname;
        passwordRecord.formSubmitURL = this.formSubmitURL;
        passwordRecord.httpRealm = this.httpRealm;
        passwordRecord.usernameField = this.usernameField;
        passwordRecord.passwordField = this.passwordField;
        passwordRecord.encryptedUsername = this.encryptedUsername;
        passwordRecord.encryptedPassword = this.encryptedPassword;
        passwordRecord.encType = this.encType;
        passwordRecord.timeCreated = this.timeCreated;
        passwordRecord.timeLastUsed = this.timeLastUsed;
        passwordRecord.timePasswordChanged = this.timePasswordChanged;
        passwordRecord.timesUsed = this.timesUsed;
        return passwordRecord;
    }

    public void initFromPayload(ExtendedJSONObject extendedJSONObject) {
        this.hostname = extendedJSONObject.getString(PAYLOAD_HOSTNAME);
        this.formSubmitURL = extendedJSONObject.getString(PAYLOAD_FORM_SUBMIT_URL);
        this.httpRealm = extendedJSONObject.getString(PAYLOAD_HTTP_REALM);
        this.encryptedUsername = extendedJSONObject.getString(PAYLOAD_USERNAME);
        this.encryptedPassword = extendedJSONObject.getString(PAYLOAD_PASSWORD);
        this.usernameField = extendedJSONObject.getString(PAYLOAD_USERNAME_FIELD);
        this.passwordField = extendedJSONObject.getString(PAYLOAD_PASSWORD_FIELD);
    }

    public void populatePayload(ExtendedJSONObject extendedJSONObject) {
        this.putPayload(extendedJSONObject, PAYLOAD_HOSTNAME, this.hostname);
        this.putPayload(extendedJSONObject, PAYLOAD_FORM_SUBMIT_URL, this.formSubmitURL);
        this.putPayload(extendedJSONObject, PAYLOAD_HTTP_REALM, this.httpRealm);
        this.putPayload(extendedJSONObject, PAYLOAD_USERNAME, this.encryptedUsername);
        this.putPayload(extendedJSONObject, PAYLOAD_PASSWORD, this.encryptedPassword);
        this.putPayload(extendedJSONObject, PAYLOAD_USERNAME_FIELD, this.usernameField);
        this.putPayload(extendedJSONObject, PAYLOAD_PASSWORD_FIELD, this.passwordField);
    }

    public boolean congruentWith(Object object) {
        if (object == null || !(object instanceof PasswordRecord)) {
            return false;
        }
        PasswordRecord passwordRecord = (PasswordRecord)object;
        if (!super.congruentWith(passwordRecord)) {
            return false;
        }
        return RepoUtils.stringsEqual(this.hostname, passwordRecord.hostname) && RepoUtils.stringsEqual(this.formSubmitURL, passwordRecord.formSubmitURL) && RepoUtils.stringsEqual(this.usernameField, passwordRecord.usernameField) && RepoUtils.stringsEqual(this.passwordField, passwordRecord.passwordField) && RepoUtils.stringsEqual(this.encryptedUsername, passwordRecord.encryptedUsername) && RepoUtils.stringsEqual(this.encryptedPassword, passwordRecord.encryptedPassword);
    }

    public boolean equalPayloads(Object object) {
        if (object == null || !(object instanceof PasswordRecord)) {
            return false;
        }
        PasswordRecord passwordRecord = (PasswordRecord)object;
        Logger.debug(LOG_TAG, "thisRecord:" + this.toString());
        Logger.debug(LOG_TAG, "otherRecord:" + object.toString());
        if (this.deleted) {
            if (passwordRecord.deleted) {
                return RepoUtils.stringsEqual(this.guid, passwordRecord.guid);
            }
            return false;
        }
        if (!super.equalPayloads(passwordRecord)) {
            Logger.debug(LOG_TAG, "super.equalPayloads returned false.");
            return false;
        }
        return RepoUtils.stringsEqual(this.hostname, passwordRecord.hostname) && RepoUtils.stringsEqual(this.formSubmitURL, passwordRecord.formSubmitURL) && RepoUtils.stringsEqual(this.usernameField, passwordRecord.usernameField) && RepoUtils.stringsEqual(this.passwordField, passwordRecord.passwordField) && RepoUtils.stringsEqual(this.encryptedUsername, passwordRecord.encryptedUsername) && RepoUtils.stringsEqual(this.encryptedPassword, passwordRecord.encryptedPassword);
    }

    public String toString() {
        return "PasswordRecord {lastModified: " + this.lastModified + ", " + "hostname null?: " + (this.hostname == null) + ", " + "formSubmitURL null?: " + (this.formSubmitURL == null) + ", " + "httpRealm null?: " + (this.httpRealm == null) + ", " + "usernameField null?: " + (this.usernameField == null) + ", " + "passwordField null?: " + (this.passwordField == null) + ", " + "encryptedUsername null?: " + (this.encryptedUsername == null) + ", " + "encryptedPassword null?: " + (this.encryptedPassword == null) + ", " + "encType: " + this.encType + ", " + "timeCreated: " + this.timeCreated + ", " + "timeLastUsed: " + this.timeLastUsed + ", " + "timePasswordChanged: " + this.timePasswordChanged + ", " + "timesUsed: " + this.timesUsed;
    }
}

