/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.synchronizer;

import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.repositories.domain.Record;
import org.mozilla.gecko.sync.synchronizer.RecordConsumer;
import org.mozilla.gecko.sync.synchronizer.RecordsConsumerDelegate;

class ConcurrentRecordConsumer
extends RecordConsumer {
    private static final String LOG_TAG = "CRecordConsumer";
    protected boolean allRecordsQueued = false;
    private long counter = 0L;
    private Object monitor = new Object();
    private Object countMonitor = new Object();

    public ConcurrentRecordConsumer(RecordsConsumerDelegate recordsConsumerDelegate) {
        this.delegate = recordsConsumerDelegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doNotify() {
        Object object = this.monitor;
        synchronized (object) {
            this.monitor.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueFilled() {
        Logger.debug(LOG_TAG, "Queue filled.");
        Object object = this.monitor;
        synchronized (object) {
            this.allRecordsQueued = true;
            this.monitor.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void halt() {
        Object object = this.monitor;
        synchronized (object) {
            this.stopImmediately = true;
            this.monitor.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stored() {
        Logger.trace(LOG_TAG, "Record stored. Notifying.");
        Object object = this.countMonitor;
        synchronized (object) {
            ++this.counter;
        }
    }

    private void consumerIsDone() {
        Logger.debug(LOG_TAG, "Consumer is done. Processed " + this.counter + (this.counter == 1L ? " record." : " records."));
        this.delegate.consumerIsDone(!this.allRecordsQueued);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            Object object;
            Record record;
            if ((record = this.delegate.getQueue().poll()) != null) {
                object = this.monitor;
                synchronized (object) {
                    Logger.trace(LOG_TAG, "run() took monitor.");
                    if (this.stopImmediately) {
                        Logger.debug(LOG_TAG, "Stopping immediately. Clearing queue.");
                        this.delegate.getQueue().clear();
                        Logger.debug(LOG_TAG, "Notifying consumer.");
                        this.consumerIsDone();
                        return;
                    }
                    Logger.debug(LOG_TAG, "run() dropped monitor.");
                }
                Logger.trace(LOG_TAG, "Storing record with guid " + record.guid + ".");
                try {
                    this.delegate.store(record);
                }
                catch (Exception exception) {
                    Logger.error(LOG_TAG, "Caught error in store.", exception);
                }
                Logger.trace(LOG_TAG, "Done with record.");
                continue;
            }
            object = this.monitor;
            synchronized (object) {
                Logger.trace(LOG_TAG, "run() took monitor.");
                if (this.allRecordsQueued) {
                    Logger.debug(LOG_TAG, "Done with records and no more to come. Notifying consumerIsDone.");
                    this.consumerIsDone();
                    return;
                }
                if (this.stopImmediately) {
                    Logger.debug(LOG_TAG, "Done with records and told to stop immediately. Notifying consumerIsDone.");
                    this.consumerIsDone();
                    return;
                }
                try {
                    Logger.debug(LOG_TAG, "Not told to stop but no records. Waiting.");
                    this.monitor.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Logger.trace(LOG_TAG, "run() dropped monitor.");
            }
        }
    }
}

