/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.webapp;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.TextView;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoApp;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoThread;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.webapp.ApkResources;
import org.mozilla.gecko.webapp.InstallHelper;
import org.mozilla.gecko.webapp.WebAppAllocator;

public class WebAppImpl
extends GeckoApp
implements InstallHelper.InstallCallback {
    private static final String LOGTAG = "GeckoWebAppImpl";
    private URL mOrigin;
    private TextView mTitlebarText = null;
    private View mTitlebar = null;
    private View mSplashscreen;
    private ApkResources mApkResources;

    protected int getIndex() {
        return 0;
    }

    public int getLayout() {
        return R.layout.web_app;
    }

    public boolean hasTabsSideBar() {
        return false;
    }

    public void onCreate(Bundle bundle) {
        boolean bl;
        String string2 = this.getIntent().getAction();
        Bundle bundle2 = this.getIntent().getExtras();
        if (bundle2 == null) {
            bundle2 = bundle;
        }
        if (bundle2 == null) {
            bundle2 = new Bundle();
        }
        boolean bl2 = bundle2.getBoolean("isInstalled", false);
        String string3 = bundle2.getString("packageName");
        if (string3 == null) {
            Log.w((String)LOGTAG, (String)"Can't find package name for webapp");
            this.setResult(0);
            this.finish();
        }
        try {
            this.mApkResources = new ApkResources((Context)this, string3);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e((String)LOGTAG, (String)("Can't find package for webapp " + string3), (Throwable)nameNotFoundException);
            this.setResult(0);
            this.finish();
        }
        super.onCreate(bundle);
        this.mTitlebarText = (TextView)this.findViewById(R.id.webapp_title);
        this.mTitlebar = this.findViewById(R.id.webapp_titlebar);
        this.mSplashscreen = this.findViewById(R.id.splashscreen);
        String string4 = WebAppAllocator.getInstance((Context)this).getOrigin(this.getIndex());
        boolean bl3 = bl = string4 == null;
        if (!GeckoThread.checkLaunchState(GeckoThread.LaunchState.GeckoRunning) || !bl2 || bl) {
            this.overridePendingTransition(R.anim.grow_fade_in_center, 0x10A0001);
            this.showSplash(true);
        } else {
            this.mSplashscreen.setVisibility(8);
        }
        if (!bl2 || bl) {
            InstallHelper installHelper = new InstallHelper(this.getApplicationContext(), this.mApkResources, this);
            if (!bl2) {
                try {
                    installHelper.startInstall(this.getDefaultProfileName());
                }
                catch (IOException iOException) {
                    Log.e((String)LOGTAG, (String)"Couldn't install packaged app", (Throwable)iOException);
                }
            } else {
                Log.i((String)LOGTAG, (String)"Waiting for existing install to complete");
                installHelper.registerGeckoListener();
            }
            return;
        }
        this.launchWebApp(string4, this.mApkResources.getManifestUrl(), this.mApkResources.getAppName());
        this.setTitle(this.mApkResources.getAppName());
    }

    protected String getURIFromIntent(Intent intent) {
        String string2 = super.getURIFromIntent(intent);
        if (string2 != null) {
            return string2;
        }
        return this.mApkResources.getManifestUrl();
    }

    protected void loadStartupTab(String string2) {
    }

    private void showSplash(boolean bl) {
        Object object;
        int n = WebAppAllocator.getInstance().getColor(this.getIndex());
        this.setBackgroundGradient(n);
        ImageView imageView = (ImageView)this.findViewById(R.id.splashscreen_icon);
        Drawable drawable2 = null;
        if (bl) {
            object = this.mApkResources.getAppIconUri();
            imageView.setImageURI(object);
            drawable2 = imageView.getDrawable();
        } else {
            object = this.getProfile().getDir();
            File file = new File((File)object, "logo.png");
            if (file.exists()) {
                drawable2 = Drawable.createFromPath((String)file.getPath());
                imageView.setImageDrawable(drawable2);
            }
        }
        if (drawable2 != null) {
            object = AnimationUtils.loadAnimation((Context)this, (int)R.anim.grow_fade_in_center);
            object.setStartOffset(500L);
            object.setDuration(1000L);
            imageView.startAnimation((Animation)object);
        }
    }

    public void setBackgroundGradient(int n) {
        int[] nArray = new int[2];
        float[] fArray = new float[3];
        Color.colorToHSV((int)n, (float[])fArray);
        fArray[2] = Math.min(fArray[2] * 2.0f, 1.0f);
        nArray[0] = Color.HSVToColor((int)255, (float[])fArray);
        fArray[2] = (float)((double)fArray[2] * 0.75);
        nArray[1] = Color.HSVToColor((int)255, (float[])fArray);
        GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TL_BR, nArray);
        gradientDrawable.setGradientType(1);
        Display display = this.getWindowManager().getDefaultDisplay();
        gradientDrawable.setGradientCenter(0.5f, 0.5f);
        gradientDrawable.setGradientRadius((float)Math.max(display.getWidth() / 2, display.getHeight() / 2));
        this.mSplashscreen.setBackgroundDrawable((Drawable)gradientDrawable);
    }

    protected String getDefaultProfileName() {
        return "webapp" + this.getIndex();
    }

    protected boolean getSessionRestoreState(Bundle bundle) {
        return false;
    }

    public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, Object object) {
        switch (tabEvents) {
            case SELECTED: 
            case LOCATION_CHANGE: {
                URL uRL;
                if (!Tabs.getInstance().isSelectedTab(tab)) break;
                String string2 = tab.getURL();
                try {
                    uRL = new URL(string2);
                }
                catch (MalformedURLException malformedURLException) {
                    this.mTitlebarText.setText((CharSequence)string2);
                    if (string2 != null && !string2.startsWith("app://")) {
                        this.mTitlebar.setVisibility(0);
                    } else {
                        this.mTitlebar.setVisibility(8);
                    }
                    return;
                }
                if (this.mOrigin != null && this.mOrigin.getHost().equals(uRL.getHost())) {
                    this.mTitlebar.setVisibility(8);
                    break;
                }
                this.mTitlebarText.setText((CharSequence)(uRL.getProtocol() + "://" + uRL.getHost()));
                this.mTitlebar.setVisibility(0);
                break;
            }
            case LOADED: {
                this.hideSplash();
                break;
            }
            case START: {
                if (this.mSplashscreen == null || this.mSplashscreen.getVisibility() != 0) break;
                View view = this.findViewById(R.id.splashscreen_progress);
                view.setVisibility(0);
                Animation animation = AnimationUtils.loadAnimation((Context)this, (int)0x10A0000);
                animation.setDuration(1000L);
                view.startAnimation(animation);
            }
        }
        super.onTabChanged(tab, tabEvents, object);
    }

    protected void hideSplash() {
        if (this.mSplashscreen != null && this.mSplashscreen.getVisibility() == 0) {
            Animation animation = AnimationUtils.loadAnimation((Context)this, (int)0x10A0001);
            animation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationEnd(Animation animation) {
                    WebAppImpl.this.mSplashscreen.setVisibility(8);
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationStart(Animation animation) {
                }
            });
            this.mSplashscreen.startAnimation(animation);
        }
    }

    public void installCompleted(InstallHelper installHelper, String string2, JSONObject jSONObject) {
        if (string2 == null) {
            return;
        }
        if (string2.equals("WebApps:PostInstall")) {
            String string3 = jSONObject.optString("origin");
            String string4 = jSONObject.optString("manifestURL");
            String string5 = jSONObject.optString("name", "WebApp");
            this.launchWebApp(string3, string4, string5);
        }
    }

    public void installErrored(InstallHelper installHelper, Exception exception) {
        Log.e((String)LOGTAG, (String)"Install errored", (Throwable)exception);
    }

    public void launchWebApp(String string2, String string3, String string4) {
        block7: {
            try {
                this.mOrigin = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                if (!string2.startsWith("app://")) {
                    return;
                }
                Log.i((String)LOGTAG, (String)"Webapp is not registered with allocator");
                Uri uri = this.getIntent().getData();
                if (uri == null) break block7;
                try {
                    this.mOrigin = new URL(uri.toString());
                }
                catch (MalformedURLException malformedURLException2) {
                    Log.e((String)LOGTAG, (String)"Unable to parse intent url: ", (Throwable)malformedURLException);
                }
            }
        }
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.putOpt("url", (Object)string3);
            jSONObject.putOpt("name", (Object)this.mApkResources.getAppName());
            Log.i((String)LOGTAG, (String)("Trying to launch: " + jSONObject));
            GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Webapps:Load", jSONObject.toString()));
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"Error populating launch message", (Throwable)jSONException);
        }
    }
}

