/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Checkable;
import android.widget.LinearLayout;

public class TabRow
extends LinearLayout
implements Checkable {
    private static final String LOGTAG = "GeckoTabRow";
    private static final int[] STATE_CHECKED = new int[]{0x10100A0};
    private boolean mChecked = false;

    public TabRow(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public int[] onCreateDrawableState(int n) {
        int[] nArray = super.onCreateDrawableState(n + 1);
        if (this.mChecked) {
            TabRow.mergeDrawableStates((int[])nArray, (int[])STATE_CHECKED);
        }
        return nArray;
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    public void setChecked(boolean bl) {
        if (this.mChecked != bl) {
            this.mChecked = bl;
            this.refreshDrawableState();
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                View view = this.getChildAt(i);
                if (!(view instanceof Checkable)) continue;
                ((Checkable)view).setChecked(bl);
            }
        }
    }

    public void toggle() {
        this.mChecked = !this.mChecked;
    }
}

