/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Queue;
import org.mozilla.gecko.ActivityHandlerHelper;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.mozglue.GeckoLoader;
import org.mozilla.gecko.util.ActivityResultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class FilePickerResultHandler
implements ActivityResultHandler {
    private static final String LOGTAG = "GeckoFilePickerResultHandler";
    protected final Queue<String> mFilePickerResult;
    protected final ActivityHandlerHelper.FileResultHandler mHandler;

    protected FilePickerResultHandler(Queue<String> queue, ActivityHandlerHelper.FileResultHandler fileResultHandler) {
        this.mFilePickerResult = queue;
        this.mHandler = fileResultHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String handleActivityResult(int n, Intent intent) {
        if (intent == null || n != -1) {
            return "";
        }
        Uri uri = intent.getData();
        if (uri == null) {
            return "";
        }
        if ("file".equals(uri.getScheme())) {
            String string2 = uri.getPath();
            return string2 == null ? "" : string2;
        }
        try {
            Object object;
            int n2;
            ContentResolver contentResolver = GeckoAppShell.getContext().getContentResolver();
            Cursor cursor = contentResolver.query(uri, new String[]{"_display_name"}, null, null, null);
            String string3 = null;
            if (cursor != null) {
                try {
                    if (cursor.moveToNext()) {
                        string3 = cursor.getString(0);
                    }
                }
                finally {
                    cursor.close();
                }
            }
            String string4 = "tmp_";
            String string5 = null;
            if (string3 == null || (n2 = string3.lastIndexOf(46)) == -1) {
                object = contentResolver.getType(uri);
                string5 = "." + GeckoAppShell.getExtensionFromMimeType((String)object);
            } else {
                string5 = string3.substring(n2);
                string4 = string4 + string3.substring(0, n2);
            }
            Log.i((String)LOGTAG, (String)("Filename: " + string4 + " . " + string5));
            object = File.createTempFile(string4, string5, GeckoLoader.getGREDir((Context)GeckoAppShell.getContext()));
            FileOutputStream fileOutputStream = new FileOutputStream((File)object);
            InputStream inputStream = contentResolver.openInputStream(uri);
            byte[] byArray = new byte[4096];
            int n3 = inputStream.read(byArray);
            while (n3 != -1) {
                fileOutputStream.write(byArray, 0, n3);
                n3 = inputStream.read(byArray);
            }
            fileOutputStream.close();
            String string6 = ((File)object).getAbsolutePath();
            return string6 == null ? "" : string6;
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"showing file picker", (Throwable)exception);
            return "";
        }
    }
}

